/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSelector;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.values.storable.Value;

public class FusionIndexPopulatorTest {
    private IndexPopulator nativePopulator;
    private IndexPopulator lucenePopulator;
    private FusionIndexPopulator fusionIndexPopulator;
    private final long indexId = 8L;
    private final FusionSchemaIndexProvider.DropAction dropAction = (FusionSchemaIndexProvider.DropAction)Mockito.mock(FusionSchemaIndexProvider.DropAction.class);

    @Before
    public void mockComponents() {
        this.nativePopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        this.lucenePopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        this.fusionIndexPopulator = new FusionIndexPopulator(this.nativePopulator, this.lucenePopulator, (FusionSchemaIndexProvider.Selector)new NativeSelector(), 8L, this.dropAction);
    }

    @Test
    public void createMustCreateBothNativeAndLucene() throws Exception {
        this.fusionIndexPopulator.create();
        ((IndexPopulator)Mockito.verify((Object)this.nativePopulator, (VerificationMode)Mockito.times((int)1))).create();
        ((IndexPopulator)Mockito.verify((Object)this.lucenePopulator, (VerificationMode)Mockito.times((int)1))).create();
    }

    @Test
    public void createMustThrowIfCreateNativeThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.nativePopulator)).create();
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.create();
            return null;
        });
    }

    @Test
    public void createMustThrowIfCreateLuceneThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.lucenePopulator)).create();
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.create();
            return null;
        });
    }

    @Test
    public void dropMustDropBothNativeAndLucene() throws Exception {
        this.fusionIndexPopulator.drop();
        ((IndexPopulator)Mockito.verify((Object)this.nativePopulator, (VerificationMode)Mockito.times((int)1))).drop();
        ((IndexPopulator)Mockito.verify((Object)this.lucenePopulator, (VerificationMode)Mockito.times((int)1))).drop();
        ((FusionSchemaIndexProvider.DropAction)Mockito.verify((Object)this.dropAction)).drop(8L);
    }

    @Test
    public void dropMustThrowIfDropNativeThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.nativePopulator)).drop();
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.drop();
            return null;
        });
    }

    @Test
    public void dropMustThrowIfDropLuceneThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.lucenePopulator)).drop();
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.drop();
            return null;
        });
    }

    @Test
    public void addMustSelectCorrectPopulator() throws Exception {
        Value[] numberValues = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] otherValues = FusionIndexTestHelp.valuesNotSupportedByNative();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (Value numberValue : numberValues) {
            this.verifyAddWithCorrectPopulator(this.nativePopulator, this.lucenePopulator, numberValue);
        }
        for (Value otherValue : otherValues) {
            this.verifyAddWithCorrectPopulator(this.lucenePopulator, this.nativePopulator, otherValue);
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyAddWithCorrectPopulator(this.lucenePopulator, this.nativePopulator, firstValue, secondValue);
            }
        }
    }

    private void verifyAddWithCorrectPopulator(IndexPopulator correctPopulator, IndexPopulator wrongPopulator, Value ... numberValues) throws IndexEntryConflictException, IOException {
        List<IndexEntryUpdate> update = Arrays.asList(FusionIndexTestHelp.add(numberValues));
        this.fusionIndexPopulator.add(update);
        ((IndexPopulator)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).add(update);
        ((IndexPopulator)Mockito.verify((Object)wrongPopulator, (VerificationMode)Mockito.times((int)0))).add(update);
    }

    @Test
    public void verifyDeferredConstraintsMustThrowIfNativeThrow() throws Exception {
        IndexEntryConflictException failure = (IndexEntryConflictException)((Object)Mockito.mock(IndexEntryConflictException.class));
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.nativePopulator)).verifyDeferredConstraints((PropertyAccessor)org.mockito.Matchers.any());
        FusionIndexTestHelp.verifyCallFail((Exception)((Object)failure), () -> {
            this.fusionIndexPopulator.verifyDeferredConstraints(null);
            return null;
        });
    }

    @Test
    public void verifyDeferredConstraintsMustThrowIfLuceneThrow() throws Exception {
        IndexEntryConflictException failure = (IndexEntryConflictException)((Object)Mockito.mock(IndexEntryConflictException.class));
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.lucenePopulator)).verifyDeferredConstraints((PropertyAccessor)org.mockito.Matchers.any());
        FusionIndexTestHelp.verifyCallFail((Exception)((Object)failure), () -> {
            this.fusionIndexPopulator.verifyDeferredConstraints(null);
            return null;
        });
    }

    @Test
    public void successfulCloseMustCloseBothNativeAndLucene() throws Exception {
        this.closeAndVerifyPropagation(this.nativePopulator, this.lucenePopulator, this.fusionIndexPopulator, true);
    }

    @Test
    public void unsuccessfulCloseMustCloseBothNativeAndLucene() throws Exception {
        this.closeAndVerifyPropagation(this.nativePopulator, this.lucenePopulator, this.fusionIndexPopulator, false);
    }

    private void closeAndVerifyPropagation(IndexPopulator nativePopulator, IndexPopulator lucenePopulator, FusionIndexPopulator fusionIndexPopulator, boolean populationCompletedSuccessfully) throws IOException {
        fusionIndexPopulator.close(populationCompletedSuccessfully);
        ((IndexPopulator)Mockito.verify((Object)nativePopulator, (VerificationMode)Mockito.times((int)1))).close(populationCompletedSuccessfully);
        ((IndexPopulator)Mockito.verify((Object)lucenePopulator, (VerificationMode)Mockito.times((int)1))).close(populationCompletedSuccessfully);
    }

    @Test
    public void closeMustThrowIfCloseNativeThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.nativePopulator)).close(org.mockito.Matchers.anyBoolean());
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.close(org.mockito.Matchers.anyBoolean());
            return null;
        });
    }

    @Test
    public void closeMustThrowIfCloseLuceneThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.lucenePopulator)).close(org.mockito.Matchers.anyBoolean());
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.close(org.mockito.Matchers.anyBoolean());
            return null;
        });
    }

    @Test
    public void closeMustCloseNativeIfLuceneThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.lucenePopulator)).close(org.mockito.Matchers.anyBoolean());
        try {
            this.fusionIndexPopulator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((IndexPopulator)Mockito.verify((Object)this.nativePopulator, (VerificationMode)Mockito.times((int)1))).close(true);
    }

    @Test
    public void closeMustCloseLuceneIfNativeThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.nativePopulator)).close(org.mockito.Matchers.anyBoolean());
        try {
            this.fusionIndexPopulator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((IndexPopulator)Mockito.verify((Object)this.lucenePopulator, (VerificationMode)Mockito.times((int)1))).close(true);
    }

    @Test
    public void closeMustThrowIfBothThrow() throws Exception {
        IOException nativeFailure = new IOException("native");
        IOException luceneFailure = new IOException("lucene");
        ((IndexPopulator)Mockito.doThrow((Throwable)nativeFailure).when((Object)this.nativePopulator)).close(org.mockito.Matchers.anyBoolean());
        ((IndexPopulator)Mockito.doThrow((Throwable)luceneFailure).when((Object)this.lucenePopulator)).close(org.mockito.Matchers.anyBoolean());
        try {
            this.fusionIndexPopulator.close(org.mockito.Matchers.anyBoolean());
            Assert.fail((String)"Should have failed");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e, (Matcher)AnyOf.anyOf((Matcher)Matchers.sameInstance((Object)nativeFailure), (Matcher)Matchers.sameInstance((Object)luceneFailure)));
        }
    }

    @Test
    public void markAsFailedMustMarkBothNativeAndLucene() throws Exception {
        String failureMessage = "failure";
        this.fusionIndexPopulator.markAsFailed(failureMessage);
        ((IndexPopulator)Mockito.verify((Object)this.nativePopulator, (VerificationMode)Mockito.times((int)1))).markAsFailed(failureMessage);
        ((IndexPopulator)Mockito.verify((Object)this.lucenePopulator, (VerificationMode)Mockito.times((int)1))).markAsFailed(failureMessage);
    }

    @Test
    public void markAsFailedMustThrowIfNativeThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.nativePopulator)).markAsFailed(org.mockito.Matchers.anyString());
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.markAsFailed(org.mockito.Matchers.anyString());
            return null;
        });
    }

    @Test
    public void markAsFailedMustThrowIfLuceneThrow() throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)this.lucenePopulator)).markAsFailed(org.mockito.Matchers.anyString());
        FusionIndexTestHelp.verifyCallFail(failure, () -> {
            this.fusionIndexPopulator.markAsFailed(org.mockito.Matchers.anyString());
            return null;
        });
    }

    @Test
    public void shouldIncludeSampleOnCorrectPopulator() throws Exception {
        IndexEntryUpdate<LabelSchemaDescriptor> update;
        Value[] numberValues = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] otherValues = FusionIndexTestHelp.valuesNotSupportedByNative();
        for (Value value : numberValues) {
            update = FusionIndexTestHelp.add(value);
            this.fusionIndexPopulator.includeSample(update);
            ((IndexPopulator)Mockito.verify((Object)this.nativePopulator)).includeSample(update);
            Mockito.reset((Object[])new IndexPopulator[]{this.nativePopulator});
        }
        for (Value value : otherValues) {
            update = FusionIndexTestHelp.add(value);
            this.fusionIndexPopulator.includeSample(update);
            ((IndexPopulator)Mockito.verify((Object)this.lucenePopulator)).includeSample(update);
            Mockito.reset((Object[])new IndexPopulator[]{this.lucenePopulator});
        }
    }
}

