/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.index.schema.NativeSelector;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

public class FusionIndexReaderTest {
    private IndexReader nativeReader;
    private IndexReader luceneReader;
    private FusionIndexReader fusionIndexReader;
    private static final int PROP_KEY = 1;

    @Before
    public void setup() {
        this.nativeReader = (IndexReader)Mockito.mock(IndexReader.class);
        this.luceneReader = (IndexReader)Mockito.mock(IndexReader.class);
        this.fusionIndexReader = new FusionIndexReader(this.nativeReader, this.luceneReader, (FusionSchemaIndexProvider.Selector)new NativeSelector());
    }

    @Test
    public void closeMustCloseBothNativeAndLucene() throws Exception {
        this.fusionIndexReader.close();
        ((IndexReader)Mockito.verify((Object)this.nativeReader, (VerificationMode)Mockito.times((int)1))).close();
        ((IndexReader)Mockito.verify((Object)this.luceneReader, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void countIndexedNodesMustSelectCorrectReader() throws Exception {
        Value[] nativeValues = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] otherValues = FusionIndexTestHelp.valuesNotSupportedByNative();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (Value nativeValue : nativeValues) {
            this.verifyCountIndexedNodesWithCorrectReader(this.nativeReader, this.luceneReader, nativeValue);
        }
        for (Value otherValue : otherValues) {
            this.verifyCountIndexedNodesWithCorrectReader(this.luceneReader, this.nativeReader, otherValue);
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyCountIndexedNodesWithCorrectReader(this.luceneReader, this.nativeReader, firstValue, secondValue);
            }
        }
    }

    private void verifyCountIndexedNodesWithCorrectReader(IndexReader correct, IndexReader wrong, Value ... nativeValue) {
        this.fusionIndexReader.countIndexedNodes(0L, nativeValue);
        ((IndexReader)Mockito.verify((Object)correct, (VerificationMode)Mockito.times((int)1))).countIndexedNodes(0L, nativeValue);
        ((IndexReader)Mockito.verify((Object)wrong, (VerificationMode)Mockito.times((int)0))).countIndexedNodes(0L, nativeValue);
    }

    @Test
    public void mustSelectLuceneForCompositePredicate() throws Exception {
        this.verifyQueryWithCorrectReader(this.luceneReader, this.nativeReader, (IndexQuery)Matchers.any(IndexQuery.class), (IndexQuery)Matchers.any(IndexQuery.class));
    }

    @Test
    public void mustSelectNativeForExactPredicateWithNumberValue() throws Exception {
        for (Value numberValue : FusionIndexTestHelp.valuesSupportedByNative()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)numberValue);
            this.verifyQueryWithCorrectReader(this.nativeReader, this.luceneReader, new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectLuceneForExactPredicateWithNonNumberValue() throws Exception {
        for (Value nonNumberValue : FusionIndexTestHelp.valuesNotSupportedByNative()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)nonNumberValue);
            this.verifyQueryWithCorrectReader(this.luceneReader, this.nativeReader, new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectLuceneForRangeStringPredicate() throws Exception {
        IndexQuery.StringRangePredicate stringRange = IndexQuery.range((int)1, (String)"abc", (boolean)true, (String)"def", (boolean)false);
        this.verifyQueryWithCorrectReader(this.luceneReader, this.nativeReader, new IndexQuery[]{stringRange});
    }

    @Test
    public void mustSelectNativeForRangeNumericPredicate() throws Exception {
        IndexQuery.NumberRangePredicate numberRange = IndexQuery.range((int)1, (Number)0, (boolean)true, (Number)1, (boolean)false);
        this.verifyQueryWithCorrectReader(this.nativeReader, this.luceneReader, new IndexQuery[]{numberRange});
    }

    @Test
    public void mustSelectLuceneForStringPrefixPredicate() throws Exception {
        IndexQuery.StringPrefixPredicate stringPrefix = IndexQuery.stringPrefix((int)1, (String)"abc");
        this.verifyQueryWithCorrectReader(this.luceneReader, this.nativeReader, new IndexQuery[]{stringPrefix});
    }

    @Test
    public void mustSelectLuceneForStringSuffixPredicate() throws Exception {
        IndexQuery.StringSuffixPredicate stringPrefix = IndexQuery.stringSuffix((int)1, (String)"abc");
        this.verifyQueryWithCorrectReader(this.luceneReader, this.nativeReader, new IndexQuery[]{stringPrefix});
    }

    @Test
    public void mustSelectLuceneForStringContainsPredicate() throws Exception {
        IndexQuery.StringContainsPredicate stringContains = IndexQuery.stringContains((int)1, (String)"abc");
        this.verifyQueryWithCorrectReader(this.luceneReader, this.nativeReader, new IndexQuery[]{stringContains});
    }

    @Test
    public void mustCombineResultFromExistsPredicate() throws Exception {
        IndexQuery.ExistsPredicate exists = IndexQuery.exists((int)1);
        Mockito.when((Object)this.nativeReader.query(new IndexQuery[]{exists})).thenReturn((Object)Primitive.iterator((long[])new long[]{0L, 1L, 3L, 4L, 7L}));
        Mockito.when((Object)this.luceneReader.query(new IndexQuery[]{exists})).thenReturn((Object)Primitive.iterator((long[])new long[]{2L, 5L, 6L}));
        PrimitiveLongIterator result = this.fusionIndexReader.query(new IndexQuery[]{exists});
        PrimitiveLongSet resultSet = PrimitiveLongCollections.asSet((PrimitiveLongIterator)result);
        for (long i = 0L; i < 8L; ++i) {
            Assert.assertTrue((String)("Expected to contain " + i + ", but was " + resultSet), (boolean)resultSet.contains(i));
        }
    }

    private void verifyQueryWithCorrectReader(IndexReader expectedReader, IndexReader unexpectedReader, IndexQuery ... indexQuery) throws IndexNotApplicableKernelException {
        this.fusionIndexReader.query(indexQuery);
        ((IndexReader)Mockito.verify((Object)expectedReader, (VerificationMode)Mockito.times((int)1))).query(indexQuery);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{unexpectedReader});
    }
}

