/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class FusionIndexTestHelp {
    private static LabelSchemaDescriptor indexKey = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private static LabelSchemaDescriptor compositeIndexKey = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1});
    private static final Value[] numberValues = new Value[]{Values.byteValue((byte)1), Values.shortValue((short)2), Values.intValue((int)3), Values.longValue((long)4L), Values.floatValue((float)5.6f), Values.doubleValue((double)7.8)};
    private static final Value[] otherValues = new Value[]{Values.booleanValue((boolean)true), Values.charValue((char)'a'), Values.stringValue((String)"bcd"), Values.booleanArray((boolean[])new boolean[2]), Values.byteArray((byte[])new byte[]{1, 2}), Values.shortArray((short[])new short[]{3, 4}), Values.intArray((int[])new int[]{5, 6}), Values.longArray((long[])new long[]{7L, 8L}), Values.floatArray((float[])new float[]{9.1f, 11.12f}), Values.doubleArray((double[])new double[]{13.14, 15.16}), Values.charArray((char[])new char[2]), Values.stringArray((String[])new String[]{"a", "b"}), Values.NO_VALUE};

    FusionIndexTestHelp() {
    }

    static Value[] valuesSupportedByNative() {
        return numberValues;
    }

    static Value[] valuesNotSupportedByNative() {
        return otherValues;
    }

    static Value[] allValues() {
        return (Value[])ArrayUtils.addAll((Object[])numberValues, (Object[])otherValues);
    }

    static void verifyCallFail(Exception expectedFailure, Callable failingCall) throws Exception {
        try {
            failingCall.call();
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertSame((Object)expectedFailure, (Object)e);
        }
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> add(Value ... value) {
        switch (value.length) {
            case 1: {
                return IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)indexKey, (Value[])value);
            }
            case 2: {
                return IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)compositeIndexKey, (Value[])value);
            }
        }
        return null;
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> remove(Value ... value) {
        switch (value.length) {
            case 1: {
                return IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)indexKey, (Value[])value);
            }
            case 2: {
                return IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)compositeIndexKey, (Value[])value);
            }
        }
        return null;
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> change(Value[] before, Value[] after) {
        return IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)compositeIndexKey, (Value[])before, (Value[])after);
    }

    static IndexEntryUpdate<LabelSchemaDescriptor> change(Value before, Value after) {
        return IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)indexKey, (Value)before, (Value)after);
    }

    static void verifyOtherIsClosedOnSingleThrow(AutoCloseable failingCloseable, AutoCloseable successfulCloseable, AutoCloseable fusionCloseable) throws Exception {
        IOException failure = new IOException("fail");
        ((AutoCloseable)Mockito.doThrow((Throwable)failure).when((Object)failingCloseable)).close();
        try {
            fusionCloseable.close();
            Assert.fail((String)"Should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((AutoCloseable)Mockito.verify((Object)successfulCloseable, (VerificationMode)Mockito.times((int)1))).close();
    }

    static void verifyFusionCloseThrowOnSingleCloseThrow(AutoCloseable failingCloseable, AutoCloseable fusionCloseable) throws Exception {
        IOException expectedFailure = new IOException("fail");
        ((AutoCloseable)Mockito.doThrow((Throwable)expectedFailure).when((Object)failingCloseable)).close();
        try {
            fusionCloseable.close();
            Assert.fail((String)"Should have failed");
        }
        catch (IOException e) {
            Assert.assertSame((Object)expectedFailure, (Object)e);
        }
    }

    static void verifyFusionCloseThrowIfBothThrow(AutoCloseable nativeCloseable, AutoCloseable luceneCloseable, AutoCloseable fusionCloseable) throws Exception {
        IOException nativeFailure = new IOException("native");
        IOException luceneFailure = new IOException("lucene");
        ((AutoCloseable)Mockito.doThrow((Throwable)nativeFailure).when((Object)nativeCloseable)).close();
        ((AutoCloseable)Mockito.doThrow((Throwable)luceneFailure).when((Object)luceneCloseable)).close();
        try {
            fusionCloseable.close();
            Assert.fail((String)"Should have failed");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e, (Matcher)AnyOf.anyOf((Matcher)Matchers.sameInstance((Object)nativeFailure), (Matcher)Matchers.sameInstance((Object)luceneFailure)));
        }
    }
}

