/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSelector;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.values.storable.Value;

public class FusionIndexUpdaterTest {
    private IndexUpdater nativeUpdater;
    private IndexUpdater luceneUpdater;
    private FusionIndexUpdater fusionIndexUpdater;

    @Before
    public void setup() {
        this.nativeUpdater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        this.luceneUpdater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        this.fusionIndexUpdater = new FusionIndexUpdater(this.nativeUpdater, this.luceneUpdater, (FusionSchemaIndexProvider.Selector)new NativeSelector());
    }

    @Test
    public void processMustSelectCorrectForAdd() throws Exception {
        Value[] supportedByNative = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] notSupportedByNative = FusionIndexTestHelp.valuesNotSupportedByNative();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (Value value : supportedByNative) {
            this.verifyAddWithCorrectUpdater(this.nativeUpdater, this.luceneUpdater, value);
        }
        for (Value value : notSupportedByNative) {
            this.verifyAddWithCorrectUpdater(this.luceneUpdater, this.nativeUpdater, value);
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyAddWithCorrectUpdater(this.luceneUpdater, this.nativeUpdater, firstValue, secondValue);
            }
        }
    }

    @Test
    public void processMustSelectCorrectForRemove() throws Exception {
        Value[] supportedByNative = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] notSupportedByNative = FusionIndexTestHelp.valuesNotSupportedByNative();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (Value value : supportedByNative) {
            this.verifyRemoveWithCorrectUpdater(this.nativeUpdater, this.luceneUpdater, value);
        }
        for (Value value : notSupportedByNative) {
            this.verifyRemoveWithCorrectUpdater(this.luceneUpdater, this.nativeUpdater, value);
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyRemoveWithCorrectUpdater(this.luceneUpdater, this.nativeUpdater, firstValue, secondValue);
            }
        }
    }

    @Test
    public void processMustSelectCorrectForChangeSupportedByNative() throws Exception {
        Value[] supportedByNative;
        for (Value before : supportedByNative = FusionIndexTestHelp.valuesSupportedByNative()) {
            for (Value after : supportedByNative) {
                this.verifyChangeWithCorrectUpdaterNotMixed(this.nativeUpdater, this.luceneUpdater, before, after);
            }
        }
    }

    @Test
    public void processMustSelectCorrectForChangeNotSupportedByNative() throws Exception {
        Value[] notSupportedByNative;
        for (Value before : notSupportedByNative = FusionIndexTestHelp.valuesNotSupportedByNative()) {
            for (Value after : notSupportedByNative) {
                this.verifyChangeWithCorrectUpdaterNotMixed(this.luceneUpdater, this.nativeUpdater, before, after);
            }
        }
    }

    @Test
    public void processMustSelectCorrectForChangeFromNativeToLucene() throws Exception {
        Value[] supportedByNative = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] notSupportedByNative = FusionIndexTestHelp.valuesNotSupportedByNative();
        this.verifyChangeWithCorrectUpdaterMixed(this.nativeUpdater, this.luceneUpdater, supportedByNative, notSupportedByNative);
    }

    @Test
    public void processMustSelectCorrectForChangeFromLuceneToNative() throws Exception {
        Value[] supportedByNative = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] notSupportedByNative = FusionIndexTestHelp.valuesNotSupportedByNative();
        this.verifyChangeWithCorrectUpdaterMixed(this.luceneUpdater, this.nativeUpdater, notSupportedByNative, supportedByNative);
    }

    private void verifyAddWithCorrectUpdater(IndexUpdater correctPopulator, IndexUpdater wrongPopulator, Value ... numberValues) throws IndexEntryConflictException, IOException {
        IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.add(numberValues);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).process(update);
        ((IndexUpdater)Mockito.verify((Object)wrongPopulator, (VerificationMode)Mockito.times((int)0))).process(update);
    }

    private void verifyRemoveWithCorrectUpdater(IndexUpdater correctPopulator, IndexUpdater wrongPopulator, Value ... numberValues) throws IndexEntryConflictException, IOException {
        IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.remove(numberValues);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).process(update);
        ((IndexUpdater)Mockito.verify((Object)wrongPopulator, (VerificationMode)Mockito.times((int)0))).process(update);
    }

    private void verifyChangeWithCorrectUpdaterNotMixed(IndexUpdater correctPopulator, IndexUpdater wrongPopulator, Value before, Value after) throws IndexEntryConflictException, IOException {
        IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.change(before, after);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).process(update);
        ((IndexUpdater)Mockito.verify((Object)wrongPopulator, (VerificationMode)Mockito.times((int)0))).process(update);
    }

    private void verifyChangeWithCorrectUpdaterMixed(IndexUpdater expectRemoveFrom, IndexUpdater expectAddTo, Value[] beforeValues, Value[] afterValues) throws IOException, IndexEntryConflictException {
        for (int beforeIndex = 0; beforeIndex < beforeValues.length; ++beforeIndex) {
            Value before = beforeValues[beforeIndex];
            for (int afterIndex = 0; afterIndex < afterValues.length; ++afterIndex) {
                Value after = afterValues[afterIndex];
                IndexEntryUpdate<LabelSchemaDescriptor> change = FusionIndexTestHelp.change(before, after);
                IndexEntryUpdate<LabelSchemaDescriptor> remove = FusionIndexTestHelp.remove(before);
                IndexEntryUpdate<LabelSchemaDescriptor> add = FusionIndexTestHelp.add(after);
                this.fusionIndexUpdater.process(change);
                ((IndexUpdater)Mockito.verify((Object)expectRemoveFrom, (VerificationMode)Mockito.times((int)(afterIndex + 1)))).process(remove);
                ((IndexUpdater)Mockito.verify((Object)expectAddTo, (VerificationMode)Mockito.times((int)(beforeIndex + 1)))).process(add);
            }
        }
    }

    @Test
    public void closeMustCloseBothNativeAndLucene() throws Exception {
        this.fusionIndexUpdater.close();
        ((IndexUpdater)Mockito.verify((Object)this.nativeUpdater, (VerificationMode)Mockito.times((int)1))).close();
        ((IndexUpdater)Mockito.verify((Object)this.luceneUpdater, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void closeMustThrowIfLuceneThrow() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)this.luceneUpdater, (AutoCloseable)this.fusionIndexUpdater);
    }

    @Test
    public void closeMustThrowIfNativeThrow() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)this.nativeUpdater, (AutoCloseable)this.fusionIndexUpdater);
    }

    @Test
    public void closeMustCloseNativeIfLuceneThrow() throws Exception {
        FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)this.luceneUpdater, (AutoCloseable)this.nativeUpdater, (AutoCloseable)this.fusionIndexUpdater);
    }

    @Test
    public void closeMustCloseLuceneIfNativeThrow() throws Exception {
        FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)this.nativeUpdater, (AutoCloseable)this.luceneUpdater, (AutoCloseable)this.fusionIndexUpdater);
    }

    @Test
    public void closeMustThrowIfBothThrow() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowIfBothThrow((AutoCloseable)this.nativeUpdater, (AutoCloseable)this.luceneUpdater, (AutoCloseable)this.fusionIndexUpdater);
    }
}

