/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.NativeSelector;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;

public class FusionSchemaIndexProviderTest {
    private static final SchemaIndexProvider.Descriptor DESCRIPTOR = new SchemaIndexProvider.Descriptor("test-fusion", "1");
    private SchemaIndexProvider nativeProvider;
    private SchemaIndexProvider luceneProvider;
    @Rule
    public RandomRule random = new RandomRule();

    @Before
    public void setup() {
        this.nativeProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        this.luceneProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)this.nativeProvider.getProviderDescriptor()).thenReturn((Object)new SchemaIndexProvider.Descriptor("native", "1"));
        Mockito.when((Object)this.luceneProvider.getProviderDescriptor()).thenReturn((Object)new SchemaIndexProvider.Descriptor("lucene", "1"));
    }

    @Test
    public void mustSelectCorrectTargetForAllGivenValueCombinations() throws Exception {
        SchemaIndexProvider selected;
        Value[] numberValues = FusionIndexTestHelp.valuesSupportedByNative();
        Value[] otherValues = FusionIndexTestHelp.valuesNotSupportedByNative();
        Value[] allValues = FusionIndexTestHelp.allValues();
        NativeSelector selector = new NativeSelector();
        for (Value numberValue : numberValues) {
            selected = (SchemaIndexProvider)selector.select((Object)this.nativeProvider, (Object)this.luceneProvider, new Value[]{numberValue});
            Assert.assertSame((Object)this.nativeProvider, (Object)selected);
        }
        for (Value otherValue : otherValues) {
            selected = (SchemaIndexProvider)selector.select((Object)this.nativeProvider, (Object)this.luceneProvider, new Value[]{otherValue});
            Assert.assertSame((Object)this.luceneProvider, (Object)selected);
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                SchemaIndexProvider selected2 = (SchemaIndexProvider)selector.select((Object)this.nativeProvider, (Object)this.luceneProvider, new Value[]{firstValue, secondValue});
                Assert.assertSame((Object)this.luceneProvider, (Object)selected2);
            }
        }
    }

    @Test
    public void mustCombineSamples() throws Exception {
        int nativeIndexSize = this.random.nextInt(0, 1000000);
        int nativeUniqueValues = this.random.nextInt(0, 1000000);
        int nativeSampleSize = this.random.nextInt(0, 1000000);
        IndexSample nativeSample = new IndexSample((long)nativeIndexSize, (long)nativeUniqueValues, (long)nativeSampleSize);
        int luceneIndexSize = this.random.nextInt(0, 1000000);
        int luceneUniqueValues = this.random.nextInt(0, 1000000);
        int luceneSampleSize = this.random.nextInt(0, 1000000);
        IndexSample luceneSample = new IndexSample((long)luceneIndexSize, (long)luceneUniqueValues, (long)luceneSampleSize);
        IndexSample fusionSample = FusionSchemaIndexProvider.combineSamples((IndexSample)nativeSample, (IndexSample)luceneSample);
        Assert.assertEquals((long)(nativeIndexSize + luceneIndexSize), (long)fusionSample.indexSize());
        Assert.assertEquals((long)(nativeUniqueValues + luceneUniqueValues), (long)fusionSample.uniqueValues());
        Assert.assertEquals((long)(nativeSampleSize + luceneSampleSize), (long)fusionSample.sampleSize());
    }

    @Test
    public void getPopulationFailureMustThrowIfNoFailure() throws Exception {
        FusionSchemaIndexProvider fusionSchemaIndexProvider = this.fusionProvider();
        IllegalStateException nativeThrow = new IllegalStateException("no native failure");
        IllegalStateException luceneThrow = new IllegalStateException("no lucene failure");
        Mockito.when((Object)this.nativeProvider.getPopulationFailure(Matchers.anyLong())).thenThrow(new Throwable[]{nativeThrow});
        Mockito.when((Object)this.luceneProvider.getPopulationFailure(Matchers.anyLong())).thenThrow(new Throwable[]{luceneThrow});
        try {
            fusionSchemaIndexProvider.getPopulationFailure(0L);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getPopulationFailureMustReportFailureWhenNativeFailure() throws Exception {
        FusionSchemaIndexProvider fusionSchemaIndexProvider = this.fusionProvider();
        String nativeFailure = "native failure";
        IllegalStateException luceneThrow = new IllegalStateException("no lucene failure");
        Mockito.when((Object)this.nativeProvider.getPopulationFailure(Matchers.anyLong())).thenReturn((Object)nativeFailure);
        Mockito.when((Object)this.luceneProvider.getPopulationFailure(Matchers.anyLong())).thenThrow(new Throwable[]{luceneThrow});
        Assert.assertThat((Object)fusionSchemaIndexProvider.getPopulationFailure(0L), (Matcher)CoreMatchers.containsString((String)nativeFailure));
    }

    @Test
    public void getPopulationFailureMustReportFailureWhenLuceneFailure() throws Exception {
        FusionSchemaIndexProvider fusionSchemaIndexProvider = this.fusionProvider();
        String luceneFailure = "lucene failure";
        IllegalStateException nativeThrow = new IllegalStateException("no native failure");
        Mockito.when((Object)this.nativeProvider.getPopulationFailure(Matchers.anyLong())).thenThrow(new Throwable[]{nativeThrow});
        Mockito.when((Object)this.luceneProvider.getPopulationFailure(Matchers.anyLong())).thenReturn((Object)luceneFailure);
        Assert.assertThat((Object)fusionSchemaIndexProvider.getPopulationFailure(0L), (Matcher)CoreMatchers.containsString((String)luceneFailure));
    }

    @Test
    public void getPopulationFailureMustReportFailureWhenBothFailure() throws Exception {
        FusionSchemaIndexProvider fusionSchemaIndexProvider = this.fusionProvider();
        String luceneFailure = "lucene failure";
        String nativeFailure = "native failure";
        Mockito.when((Object)this.nativeProvider.getPopulationFailure(Matchers.anyLong())).thenReturn((Object)nativeFailure);
        Mockito.when((Object)this.luceneProvider.getPopulationFailure(Matchers.anyLong())).thenReturn((Object)luceneFailure);
        String populationFailure = fusionSchemaIndexProvider.getPopulationFailure(0L);
        Assert.assertThat((Object)populationFailure, (Matcher)CoreMatchers.containsString((String)nativeFailure));
        Assert.assertThat((Object)populationFailure, (Matcher)CoreMatchers.containsString((String)luceneFailure));
    }

    @Test
    public void shouldReportFailedIfAnyIsFailed() throws Exception {
        FusionSchemaIndexProvider provider = this.fusionProvider();
        IndexDescriptor indexDescriptor = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        for (InternalIndexState state : InternalIndexState.values()) {
            this.setInitialState(this.nativeProvider, InternalIndexState.FAILED);
            this.setInitialState(this.luceneProvider, state);
            InternalIndexState failed1 = provider.getInitialState(0L, indexDescriptor);
            this.setInitialState(this.nativeProvider, state);
            this.setInitialState(this.luceneProvider, InternalIndexState.FAILED);
            InternalIndexState failed2 = provider.getInitialState(0L, indexDescriptor);
            Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)failed1);
            Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)failed2);
        }
    }

    @Test
    public void shouldReportPopulatingIfAnyIsPopulating() throws Exception {
        FusionSchemaIndexProvider provider = this.fusionProvider();
        IndexDescriptor indexDescriptor = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        for (InternalIndexState state : (InternalIndexState[])ArrayUtil.array((Object[])new InternalIndexState[]{InternalIndexState.ONLINE, InternalIndexState.POPULATING})) {
            this.setInitialState(this.nativeProvider, InternalIndexState.POPULATING);
            this.setInitialState(this.luceneProvider, state);
            InternalIndexState failed1 = provider.getInitialState(0L, indexDescriptor);
            this.setInitialState(this.nativeProvider, state);
            this.setInitialState(this.luceneProvider, InternalIndexState.POPULATING);
            InternalIndexState failed2 = provider.getInitialState(0L, indexDescriptor);
            Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)failed1);
            Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)failed2);
        }
    }

    private FusionSchemaIndexProvider fusionProvider() {
        return new FusionSchemaIndexProvider(this.nativeProvider, this.luceneProvider, (FusionSchemaIndexProvider.Selector)new NativeSelector(), DESCRIPTOR, 10, IndexDirectoryStructure.NONE, (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class));
    }

    private void setInitialState(SchemaIndexProvider mockedProvider, InternalIndexState state) {
        Mockito.when((Object)mockedProvider.getInitialState(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)state);
    }
}

