/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class AcquireAndReleaseLocksCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public AcquireAndReleaseLocksCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    public void exclusiveShouldWaitForExclusive() throws Exception {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void exclusiveShouldWaitForShared() throws Exception {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientC.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientC.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void sharedShouldWaitForExclusive() throws Exception {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void shouldTrySharedLock() throws Exception {
        junit.framework.Assert.assertTrue((boolean)this.clientA.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    public void shouldTryExclusiveLock() throws Exception {
        junit.framework.Assert.assertTrue((boolean)this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    public void shouldTryUpgradeSharedToExclusive() throws Exception {
        junit.framework.Assert.assertTrue((boolean)this.clientA.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        junit.framework.Assert.assertTrue((boolean)this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    public void shouldUpgradeExclusiveOnTry() throws Exception {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        junit.framework.Assert.assertTrue((boolean)this.clientA.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldAcquireMultipleSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assert.assertEquals((long)3L, (long)this.lockCount());
    }

    @Test
    public void shouldAcquireMultipleExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assert.assertEquals((long)3L, (long)this.lockCount());
    }

    @Test
    public void shouldAcquireMultipleAlreadyAcquiredSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assert.assertEquals((long)4L, (long)this.lockCount());
    }

    @Test
    public void shouldAcquireMultipleAlreadyAcquiredExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assert.assertEquals((long)4L, (long)this.lockCount());
    }

    @Test
    public void shouldAcquireMultipleSharedLocksWhileHavingSomeExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assert.assertEquals((long)4L, (long)this.lockCount());
    }

    @Test
    public void shouldReleaseSharedLocksAcquiredInABatch() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L, 10L, 100L});
        Assert.assertEquals((long)3L, (long)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assert.assertEquals((long)2L, (long)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{10L});
        Assert.assertEquals((long)1L, (long)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L});
        Assert.assertEquals((long)0L, (long)this.lockCount());
    }

    @Test
    public void shouldReleaseExclusiveLocksAcquiredInABatch() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L, 10L, 100L});
        Assert.assertEquals((long)3L, (long)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assert.assertEquals((long)2L, (long)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{10L});
        Assert.assertEquals((long)1L, (long)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L});
        Assert.assertEquals((long)0L, (long)this.lockCount());
    }

    @Test
    public void releaseMultipleSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        Assert.assertEquals((long)3L, (long)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assert.assertEquals((long)1L, (long)this.lockCount());
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
    }

    @Test
    public void releaseMultipleExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        Assert.assertEquals((long)3L, (long)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{10L, 100L});
        Assert.assertEquals((long)1L, (long)this.lockCount());
        junit.framework.Assert.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
    }

    @Test
    public void releaseMultipleAlreadyAcquiredSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assert.assertEquals((long)4L, (long)this.lockCount());
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assert.assertEquals((long)2L, (long)this.lockCount());
    }

    @Test
    public void releaseMultipleAlreadyAcquiredExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assert.assertEquals((long)4L, (long)this.lockCount());
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10000L));
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        Assert.assertEquals((long)2L, (long)this.lockCount());
    }

    @Test
    public void releaseSharedLocksAcquiredSeparately() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        Assert.assertEquals((long)3L, (long)this.lockCount());
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 2L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 3L));
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L, 2L, 3L});
        Assert.assertEquals((long)0L, (long)this.lockCount());
        junit.framework.Assert.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 2L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 3L));
    }

    @Test
    public void releaseExclusiveLocksAcquiredSeparately() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        Assert.assertEquals((long)3L, (long)this.lockCount());
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 2L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 3L));
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L, 2L, 3L});
        Assert.assertEquals((long)0L, (long)this.lockCount());
        junit.framework.Assert.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 2L));
        junit.framework.Assert.assertTrue((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 3L));
    }

    @Test
    public void releaseMultipleSharedLocksWhileHavingSomeExclusiveLocks() {
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assert.assertEquals((long)4L, (long)this.lockCount());
        this.clientA.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assert.assertEquals((long)4L, (long)this.lockCount());
    }

    @Test
    public void releaseMultipleExclusiveLocksWhileHavingSomeSharedLocks() {
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L, 10000L});
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{10L, 100L, 1000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assert.assertEquals((long)4L, (long)this.lockCount());
        this.clientA.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{100L, 1000L});
        TestCase.assertFalse((boolean)this.clientB.trySharedLock((ResourceType)ResourceTypes.NODE, 10L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 100L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1000L));
        TestCase.assertFalse((boolean)this.clientB.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 10000L));
        Assert.assertEquals((long)4L, (long)this.lockCount());
    }

    private int lockCount() {
        LockCountVisitor lockVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockVisitor);
        return lockVisitor.getLockCount();
    }
}

