/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockWorkerState;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.OtherThreadExecutor;

public class LockWorker
extends OtherThreadExecutor<LockWorkerState> {
    public LockWorker(String name, Locks locks) {
        super(name, (Object)new LockWorkerState(locks));
    }

    private Future<Void> perform(AcquireLockCommand acquireLockCommand, boolean wait) throws Exception {
        Future future = this.executeDontWait(acquireLockCommand);
        if (wait) {
            this.awaitFuture(future);
        } else {
            this.waitUntilWaiting();
        }
        return future;
    }

    public Future<Void> getReadLock(final long resource, final boolean wait) throws Exception {
        return this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) throws AcquireLockTimeoutException {
                state.doing("+R " + resource + ", wait:" + wait);
                state.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{resource});
                state.done();
            }
        }, wait);
    }

    public Future<Void> getWriteLock(final long resource, final boolean wait) throws Exception {
        return this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) throws AcquireLockTimeoutException {
                state.doing("+W " + resource + ", wait:" + wait);
                state.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{resource});
                state.done();
            }
        }, wait);
    }

    public void releaseReadLock(final long resource) throws Exception {
        this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) {
                state.doing("-R " + resource);
                state.client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{resource});
                state.done();
            }
        }, true);
    }

    public void releaseWriteLock(final long resource) throws Exception {
        this.perform(new AcquireLockCommand(){

            @Override
            protected void acquireLock(LockWorkerState state) {
                state.doing("-W " + resource);
                state.client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{resource});
                state.done();
            }
        }, true);
    }

    public boolean isLastGetLockDeadLock() {
        return ((LockWorkerState)this.state).deadlockOnLastWait;
    }

    private static abstract class AcquireLockCommand
    implements OtherThreadExecutor.WorkerCommand<LockWorkerState, Void> {
        private AcquireLockCommand() {
        }

        public Void doWork(LockWorkerState state) throws Exception {
            try {
                this.acquireLock(state);
                state.deadlockOnLastWait = false;
            }
            catch (DeadlockDetectedException e) {
                state.deadlockOnLastWait = true;
            }
            return null;
        }

        protected abstract void acquireLock(LockWorkerState var1) throws AcquireLockTimeoutException;
    }
}

