/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.AcquireAndReleaseLocksCompatibility;
import org.neo4j.kernel.impl.locking.AcquisitionTimeoutCompatibility;
import org.neo4j.kernel.impl.locking.ActiveLocksListingCompatibility;
import org.neo4j.kernel.impl.locking.CloseCompatibility;
import org.neo4j.kernel.impl.locking.DeadlockCompatibility;
import org.neo4j.kernel.impl.locking.LockReentrancyCompatibility;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.RWLockCompatibility;
import org.neo4j.kernel.impl.locking.StopCompatibility;
import org.neo4j.kernel.impl.locking.TracerCompatibility;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.test.runner.ParameterizedSuiteRunner;
import org.neo4j.time.Clocks;

@RunWith(value=ParameterizedSuiteRunner.class)
@Suite.SuiteClasses(value={AcquireAndReleaseLocksCompatibility.class, DeadlockCompatibility.class, LockReentrancyCompatibility.class, RWLockCompatibility.class, StopCompatibility.class, CloseCompatibility.class, AcquisitionTimeoutCompatibility.class, TracerCompatibility.class, ActiveLocksListingCompatibility.class})
public abstract class LockingCompatibilityTestSuite {
    protected abstract Locks createLockManager(Config var1, Clock var2);

    protected abstract boolean isAwaitingLockAcquisition(OtherThreadExecutor.WaitDetails var1);

    public static abstract class Compatibility {
        @Rule
        public OtherThreadRule<Void> threadA = new OtherThreadRule();
        @Rule
        public OtherThreadRule<Void> threadB = new OtherThreadRule();
        @Rule
        public OtherThreadRule<Void> threadC = new OtherThreadRule();
        @Rule
        public TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
        protected final LockingCompatibilityTestSuite suite;
        protected Locks locks;
        protected Locks.Client clientA;
        protected Locks.Client clientB;
        protected Locks.Client clientC;
        private final Map<Locks.Client, OtherThreadRule<Void>> clientToThreadMap = new HashMap<Locks.Client, OtherThreadRule<Void>>();

        public Compatibility(LockingCompatibilityTestSuite suite) {
            this.suite = suite;
        }

        @Before
        public void before() {
            this.locks = this.suite.createLockManager(Config.defaults(), Clocks.systemClock());
            this.clientA = this.locks.newClient();
            this.clientB = this.locks.newClient();
            this.clientC = this.locks.newClient();
            this.clientToThreadMap.put(this.clientA, this.threadA);
            this.clientToThreadMap.put(this.clientB, this.threadB);
            this.clientToThreadMap.put(this.clientC, this.threadC);
        }

        @After
        public void after() {
            this.clientA.close();
            this.clientB.close();
            this.clientC.close();
            this.locks.close();
            this.clientToThreadMap.clear();
        }

        protected LockCommand acquireExclusive(Locks.Client client, final LockTracer tracer, final ResourceType resourceType, final long key) {
            return new LockCommand(this.clientToThreadMap.get(client), client){

                @Override
                public void doWork(Locks.Client client) throws AcquireLockTimeoutException {
                    client.acquireExclusive(tracer, resourceType, new long[]{key});
                }
            };
        }

        protected LockCommand acquireShared(Locks.Client client, final LockTracer tracer, final ResourceType resourceType, final long key) {
            return new LockCommand(this.clientToThreadMap.get(client), client){

                @Override
                public void doWork(Locks.Client client) throws AcquireLockTimeoutException {
                    client.acquireShared(tracer, resourceType, new long[]{key});
                }
            };
        }

        protected LockCommand release(Locks.Client client, final ResourceType resourceType, final long key) {
            return new LockCommand(this.clientToThreadMap.get(client), client){

                @Override
                public void doWork(Locks.Client client) {
                    client.releaseExclusive(resourceType, new long[]{key});
                }
            };
        }

        protected void assertNotWaiting(Locks.Client client, Future<Object> lock) {
            try {
                lock.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Waiting for lock timed out!");
            }
        }

        protected void assertWaiting(Locks.Client client, Future<Object> lock) {
            try {
                lock.get(10L, TimeUnit.MILLISECONDS);
                TestCase.fail((String)"Should be waiting.");
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            MatcherAssert.assertThat(this.clientToThreadMap.get(client), (Matcher)OtherThreadRule.isWaiting());
        }

        public abstract class LockCommand
        implements OtherThreadExecutor.WorkerCommand<Void, Object> {
            private final OtherThreadRule<Void> thread;
            private final Locks.Client client;

            protected LockCommand(OtherThreadRule<Void> thread, Locks.Client client) {
                this.thread = thread;
                this.client = client;
            }

            public Future<Object> call() {
                return this.thread.execute((OtherThreadExecutor.WorkerCommand)this);
            }

            public Future<Object> callAndAssertWaiting() {
                Future<Object> otherThreadLock = this.call();
                MatcherAssert.assertThat(this.thread, (Matcher)OtherThreadRule.isWaiting());
                TestCase.assertFalse((String)"Should not have acquired lock.", (boolean)otherThreadLock.isDone());
                return otherThreadLock;
            }

            public Future<Object> callAndAssertNotWaiting() {
                Future<Object> run = this.call();
                Compatibility.this.assertNotWaiting(this.client, run);
                return run;
            }

            public Object doWork(Void state) throws Exception {
                this.doWork(this.client);
                return null;
            }

            abstract void doWork(Locks.Client var1) throws AcquireLockTimeoutException;

            public Locks.Client client() {
                return this.client;
            }
        }
    }
}

