/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageSwapperFactoryForTesting;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ConfiguringPageCacheFactoryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Before
    public void setUp() {
        PageSwapperFactoryForTesting.createdCounter.set(0);
        PageSwapperFactoryForTesting.configuredCounter.set(0);
        PageSwapperFactoryForTesting.cachePageSizeHint.set(0);
        PageSwapperFactoryForTesting.cachePageSizeHintIsStrict.set(false);
    }

    @Test
    public void shouldFitAsManyPagesAsItCan() throws Throwable {
        int pageSize = 8192;
        long maxPages = 60L;
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)Long.toString(491520L));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY);
        try (PageCache cache = factory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)CoreMatchers.equalTo((Object)8192));
            MatcherAssert.assertThat((Object)cache.maxCachedPages(), (Matcher)CoreMatchers.equalTo((Object)60L));
        }
    }

    @Test
    public void shouldWarnWhenCreatedWithConfiguredPageCache() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_page_size.name(), "4096", GraphDatabaseSettings.pagecache_swapper.name(), "pageSwapperForTesting"}));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(PageCache.class);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, log, EmptyVersionContextSupplier.EMPTY);
        try (PageCache pageCache = pageCacheFactory.getOrCreatePageCache();){
            logProvider.assertContainsLogCallContaining("The setting unsupported.dbms.memory.pagecache.pagesize does not have any effect. It is deprecated and will be removed in a future version.");
        }
    }

    @Test
    public void mustUseAndLogConfiguredPageSwapper() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m", GraphDatabaseSettings.pagecache_swapper.name(), "pageSwapperForTesting"}));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(PageCache.class);
        ConfiguringPageCacheFactory cacheFactory = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, log, EmptyVersionContextSupplier.EMPTY);
        PageCache pageCache = cacheFactory.getOrCreatePageCache();
        Throwable throwable = null;
        if (pageCache != null) {
            if (throwable != null) {
                try {
                    pageCache.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                pageCache.close();
            }
        }
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countCreatedPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countConfiguredPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
        logProvider.assertContainsMessageContaining("pageSwapperForTesting");
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowIfConfiguredPageSwapperCannotBeFound() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m", GraphDatabaseSettings.pagecache_swapper.name(), "non-existing"}));
        PageCache pageCache = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY).getOrCreatePageCache();
        Throwable throwable = null;
        if (pageCache != null) {
            if (throwable != null) {
                try {
                    pageCache.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                pageCache.close();
            }
        }
    }

    @Test
    public void mustIgnoreExplicitlySpecifiedCachePageSizeIfPageSwapperHintIsStrict() throws Exception {
        int cachePageSizeHint = 16384;
        PageSwapperFactoryForTesting.cachePageSizeHint.set(cachePageSizeHint);
        PageSwapperFactoryForTesting.cachePageSizeHintIsStrict.set(true);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_swapper, (String)"pageSwapperForTesting");
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory(this.fsRule.get(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY);
        try (PageCache cache = factory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)Matchers.is((Object)cachePageSizeHint));
        }
    }
}

