/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class ProceduresTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final Procedures procs = new Procedures();
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build();
    private final CallableProcedure procedure = this.procedure(this.signature);
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void shouldGetRegisteredProcedure() throws Throwable {
        this.procs.register(this.procedure);
        Assert.assertThat((Object)this.procs.procedure(this.signature.name()), (Matcher)CoreMatchers.equalTo((Object)this.signature));
    }

    @Test
    public void shouldGetAllRegisteredProcedures() throws Throwable {
        this.procs.register(this.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc1"}).out("age", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()));
        this.procs.register(this.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc2"}).out("age", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()));
        this.procs.register(this.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc3"}).out("age", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()));
        List signatures = Iterables.asList((Iterable)this.procs.getAllProcedures());
        Assert.assertThat((Object)signatures, (Matcher)Matchers.containsInAnyOrder((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc1"}).out("age", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc2"}).out("age", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc3"}).out("age", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).build()}));
    }

    @Test
    public void shouldCallRegisteredProcedure() throws Throwable {
        this.procs.register(this.procedure);
        RawIterator result = this.procs.callProcedure((Context)new BasicContext(), this.signature.name(), new Object[]{1337}, this.resourceTracker);
        Assert.assertThat((Object)Iterators.asList((RawIterator)result), (Matcher)Matchers.contains((Matcher)CoreMatchers.equalTo((Object)new Object[]{1337})));
    }

    @Test
    public void shouldNotAllowCallingNonExistingProcedure() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("There is no procedure with the name `org.myproc` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.");
        this.procs.callProcedure((Context)new BasicContext(), this.signature.name(), new Object[]{1337}, this.resourceTracker);
    }

    @Test
    public void shouldNotAllowRegisteringConflictingName() throws Throwable {
        this.procs.register(this.procedure);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to register procedure, because the name `org.myproc` is already in use.");
        this.procs.register(this.procedure);
    }

    @Test
    public void shouldNotAllowDuplicateFieldNamesInInput() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Procedure `asd(a :: ANY?, a :: ANY?) :: ()` cannot be registered, because it contains a duplicated input field, 'a'. You need to rename or remove one of the duplicate fields.");
        this.procs.register((CallableProcedure)this.procedureWithSignature(ProcedureSignature.procedureSignature((String[])new String[]{"asd"}).in("a", Neo4jTypes.NTAny).in("a", Neo4jTypes.NTAny).build()));
    }

    @Test
    public void shouldNotAllowDuplicateFieldNamesInOutput() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Procedure `asd() :: (a :: ANY?, a :: ANY?)` cannot be registered, because it contains a duplicated output field, 'a'. You need to rename or remove one of the duplicate fields.");
        this.procs.register((CallableProcedure)this.procedureWithSignature(ProcedureSignature.procedureSignature((String[])new String[]{"asd"}).out("a", Neo4jTypes.NTAny).out("a", Neo4jTypes.NTAny).build()));
    }

    @Test
    public void shouldSignalNonExistingProcedure() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("There is no procedure with the name `org.myproc` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.");
        this.procs.procedure(this.signature.name());
    }

    @Test
    public void shouldMakeContextAvailable() throws Throwable {
        final Key someKey = Key.key((String)"someKey", String.class);
        this.procs.register((CallableProcedure)new CallableProcedure.BasicProcedure(this.signature){

            public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
                return RawIterator.of((Object[])new Object[][]{{ctx.get(someKey)}});
            }
        });
        BasicContext ctx = new BasicContext();
        ctx.put(someKey, (Object)"hello, world");
        RawIterator result = this.procs.callProcedure((Context)ctx, this.signature.name(), new Object[0], this.resourceTracker);
        Assert.assertThat((Object)Iterators.asList((RawIterator)result), (Matcher)Matchers.contains((Matcher)CoreMatchers.equalTo((Object)new Object[]{"hello, world"})));
    }

    @Test
    public void shouldFailCompileProcedureWithReadConflict() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Conflicting procedure annotation, cannot use PerformsWrites and mode");
        this.procs.registerProcedure(ProcedureWithReadConflictAnnotation.class);
    }

    @Test
    public void shouldFailCompileProcedureWithWriteConflict() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Conflicting procedure annotation, cannot use PerformsWrites and mode");
        this.procs.registerProcedure(ProcedureWithWriteConflictAnnotation.class);
    }

    @Test
    public void shouldFailCompileProcedureWithSchemaConflict() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Conflicting procedure annotation, cannot use PerformsWrites and mode");
        this.procs.registerProcedure(ProcedureWithSchemaConflictAnnotation.class);
    }

    @Test
    public void shouldFailCompileProcedureWithDBMSConflict() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Conflicting procedure annotation, cannot use PerformsWrites and mode");
        this.procs.registerProcedure(ProcedureWithDBMSConflictAnnotation.class);
    }

    private CallableProcedure.BasicProcedure procedureWithSignature(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
                return null;
            }
        };
    }

    private CallableProcedure procedure(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) {
                return RawIterator.of((Object[])new Object[][]{input});
            }
        };
    }

    public static class ProcedureWithSchemaConflictAnnotation {
        @PerformsWrites
        @Procedure(mode=Mode.SCHEMA)
        public void shouldNotCompile() {
        }
    }

    public static class ProcedureWithDBMSConflictAnnotation {
        @PerformsWrites
        @Procedure(mode=Mode.DBMS)
        public void shouldNotCompile() {
        }
    }

    public static class ProcedureWithWriteConflictAnnotation {
        @PerformsWrites
        @Procedure(mode=Mode.WRITE)
        public void shouldCompileToo() {
        }
    }

    public static class ProcedureWithReadConflictAnnotation {
        @PerformsWrites
        @Procedure(mode=Mode.READ)
        public void shouldCompile() {
        }
    }
}

