/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.Procedure;

public class ReflectiveProcedureTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ReflectiveProcedureCompiler procedureCompiler;
    private ComponentRegistry components;
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Before
    public void setUp() throws Exception {
        this.components = new ComponentRegistry();
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, (Log)NullLog.getInstance(), ProcedureConfig.DEFAULT);
    }

    @Test
    public void shouldInjectLogging() throws KernelException {
        Log log = (Log)Mockito.spy(Log.class);
        this.components.register(Log.class, ctx -> log);
        CallableProcedure procedure = (CallableProcedure)this.procedureCompiler.compileProcedure(LoggingProcedure.class, Optional.empty(), true).get(0);
        procedure.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
        ((Log)Mockito.verify((Object)log)).debug("1");
        ((Log)Mockito.verify((Object)log)).info("2");
        ((Log)Mockito.verify((Object)log)).warn("3");
        ((Log)Mockito.verify((Object)log)).error("4");
    }

    @Test
    public void shouldCompileProcedure() throws Throwable {
        List<CallableProcedure> procedures = this.compile(SingleReadOnlyProcedure.class);
        TestCase.assertEquals((int)1, (int)procedures.size());
        Assert.assertThat((Object)procedures.get(0).signature(), (Matcher)Matchers.equalTo((Object)ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "listCoolPeople"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
    }

    @Test
    public void shouldRunSimpleReadOnlyProcedure() throws Throwable {
        CallableProcedure proc = this.compile(SingleReadOnlyProcedure.class).get(0);
        RawIterator out = proc.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
        Assert.assertThat((Object)Iterators.asList((RawIterator)out), (Matcher)Matchers.contains((Object[])new Object[][]{{"Bonnie"}, {"Clyde"}}));
    }

    @Test
    public void shouldIgnoreClassesWithNoProcedures() throws Throwable {
        List<CallableProcedure> procedures = this.compile(PrivateConstructorButNoProcedures.class);
        TestCase.assertEquals((int)0, (int)procedures.size());
    }

    @Test
    public void shouldRunClassWithMultipleProceduresDeclared() throws Throwable {
        List<CallableProcedure> compiled = this.compile(MultiProcedureProcedure.class);
        CallableProcedure bananaPeople = compiled.get(0);
        CallableProcedure coolPeople = compiled.get(1);
        RawIterator coolOut = coolPeople.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
        RawIterator bananaOut = bananaPeople.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
        Assert.assertThat((Object)Iterators.asList((RawIterator)coolOut), (Matcher)Matchers.contains((Object[])new Object[][]{{"Bonnie"}, {"Clyde"}}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)bananaOut), (Matcher)Matchers.contains((Object[])new Object[][]{{"Jake", 18L}, {"Pontus", 2L}}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnConstructorThatRequiresArgument() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `WierdConstructorProcedure`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(WierdConstructorProcedure.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNoPublicConstructor() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `PrivateConstructorProcedure`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(PrivateConstructorProcedure.class);
    }

    @Test
    public void shouldAllowVoidOutput() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithVoidOutput.class).get(0);
        TestCase.assertEquals((int)0, (int)proc.signature().outputSignature().size());
        Assert.assertFalse((boolean)proc.apply(null, new Object[0], this.resourceTracker).hasNext());
    }

    @Test
    public void shouldGiveHelpfulErrorOnProcedureReturningInvalidRecordType() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `String`, you could define a record class like:%npublic class Output '{'%n    public String out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", new Object[0]));
        this.compile(ProcedureWithInvalidRecordOutput.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnContextAnnotatedStaticField() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("The field `gdb` in the class named `ProcedureWithStaticContextAnnotatedField` is annotated as a @Context field,%nbut it is static. @Context fields must be public, non-final and non-static,%nbecause they are reset each time a procedure is invoked.", new Object[0]));
        this.compile(ProcedureWithStaticContextAnnotatedField.class).get(0);
    }

    @Test
    public void shouldAllowNonStaticOutput() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithNonStaticOutputRecord.class).get(0);
        TestCase.assertEquals((int)1, (int)proc.signature().outputSignature().size());
    }

    @Test
    public void shouldAllowOverridingProcedureName() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithOverriddenName.class).get(0);
        TestCase.assertEquals((String)"org.mystuff.thisisActuallyTheName", (String)proc.signature().name().toString());
    }

    @Test
    public void shouldAllowOverridingProcedureNameWithoutNamespace() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithSingleName.class).get(0);
        TestCase.assertEquals((String)"singleName", (String)proc.signature().name().toString());
    }

    @Test
    public void shouldGiveHelpfulErrorOnNullMessageException() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureThatThrowsNullMsgExceptionAtInvocation.class).get(0);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Failed to invoke procedure `org.neo4j.kernel.impl.proc.throwsAtInvocation`: Caused by: java.lang.IndexOutOfBoundsException");
        proc.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
    }

    @Test
    public void shouldCloseResourcesAndGiveHelpfulErrorOnMidStreamException() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureThatThrowsNullMsgExceptionMidStream.class).get(0);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Failed to invoke procedure `org.neo4j.kernel.impl.proc.throwsInStream`: Caused by: java.lang.IndexOutOfBoundsException");
        this.exception.expect((Matcher)new BaseMatcher<Exception>(){

            public void describeTo(Description description) {
                description.appendText("a suppressed exception with cause ExceptionDuringClose");
            }

            public boolean matches(Object item) {
                Exception e = (Exception)item;
                for (Throwable suppressed : e.getSuppressed()) {
                    if (!(suppressed instanceof ResourceCloseFailureException) || !(suppressed.getCause() instanceof ExceptionDuringClose)) continue;
                    return true;
                }
                return false;
            }
        });
        RawIterator stream = proc.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
        if (stream.hasNext()) {
            stream.next();
        }
    }

    @Test
    public void shouldSupportProcedureDeprecation() throws Throwable {
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, log, ProcedureConfig.DEFAULT);
        List procs = procedureCompiler.compileProcedure(ProcedureWithDeprecation.class, Optional.empty(), true);
        ((Log)Mockito.verify((Object)log)).warn("Use of @Procedure(deprecatedBy) without @Deprecated in badProc");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{log});
        block9: for (CallableProcedure proc : procs) {
            String name = proc.signature().name().name();
            proc.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
            switch (name) {
                case "newProc": {
                    Assert.assertFalse((String)"Should not be deprecated", (boolean)proc.signature().deprecated().isPresent());
                    continue block9;
                }
                case "oldProc": 
                case "badProc": {
                    Assert.assertTrue((String)"Should be deprecated", (boolean)proc.signature().deprecated().isPresent());
                    Assert.assertThat(proc.signature().deprecated().get(), (Matcher)CoreMatchers.equalTo((Object)"newProc"));
                    continue block9;
                }
            }
            Assert.fail((String)("Unexpected procedure: " + name));
        }
    }

    @Test
    public void shouldLoadWhiteListedProcedure() throws Throwable {
        ProcedureConfig config = new ProcedureConfig(Config.defaults((Setting)GraphDatabaseSettings.procedure_whitelist, (String)"org.neo4j.kernel.impl.proc.listCoolPeople"));
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, log, config);
        CallableProcedure proc = (CallableProcedure)procedureCompiler.compileProcedure(SingleReadOnlyProcedure.class, Optional.empty(), false).get(0);
        RawIterator result = proc.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
        TestCase.assertEquals((Object)((Object[])result.next())[0], (Object)"Bonnie");
    }

    @Test
    public void shouldNotLoadNoneWhiteListedProcedure() throws Throwable {
        ProcedureConfig config = new ProcedureConfig(Config.defaults((Setting)GraphDatabaseSettings.procedure_whitelist, (String)"org.neo4j.kernel.impl.proc.NOTlistCoolPeople"));
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, log, config);
        List proc = procedureCompiler.compileProcedure(SingleReadOnlyProcedure.class, Optional.empty(), false);
        ((Log)Mockito.verify((Object)log)).warn("The procedure 'org.neo4j.kernel.impl.proc.listCoolPeople' is not on the whitelist and won't be loaded.");
        Assert.assertThat((Object)proc.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldIgnoreWhiteListingIfFullAccess() throws Throwable {
        ProcedureConfig config = new ProcedureConfig(Config.defaults((Setting)GraphDatabaseSettings.procedure_whitelist, (String)"empty"));
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, log, config);
        CallableProcedure proc = (CallableProcedure)procedureCompiler.compileProcedure(SingleReadOnlyProcedure.class, Optional.empty(), true).get(0);
        RawIterator result = proc.apply((Context)new BasicContext(), new Object[0], this.resourceTracker);
        TestCase.assertEquals((Object)((Object[])result.next())[0], (Object)"Bonnie");
    }

    @Test
    public void shouldNotLoadAnyProcedureIfConfigIsEmpty() throws Throwable {
        ProcedureConfig config = new ProcedureConfig(Config.defaults((Setting)GraphDatabaseSettings.procedure_whitelist, (String)""));
        Log log = (Log)Mockito.mock(Log.class);
        ReflectiveProcedureCompiler procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components, this.components, log, config);
        List proc = procedureCompiler.compileProcedure(SingleReadOnlyProcedure.class, Optional.empty(), false);
        ((Log)Mockito.verify((Object)log)).warn("The procedure 'org.neo4j.kernel.impl.proc.listCoolPeople' is not on the whitelist and won't be loaded.");
        Assert.assertThat((Object)proc.isEmpty(), (Matcher)Is.is((Object)true));
    }

    private List<CallableProcedure> compile(Class<?> clazz) throws KernelException {
        return this.procedureCompiler.compileProcedure(clazz, Optional.empty(), true);
    }

    private static class ExceptionDuringClose
    extends RuntimeException {
        private ExceptionDuringClose() {
        }
    }

    public static class ProcedureWithDeprecation {
        @Procedure(value="newProc")
        public void newProc() {
        }

        @Deprecated
        @Procedure(value="oldProc", deprecatedBy="newProc")
        public void oldProc() {
        }

        @Procedure(value="badProc", deprecatedBy="newProc")
        public void badProc() {
        }
    }

    public static class ProcedureWithSingleName {
        @Procedure(value="singleName")
        public void blahDoesntMatterEither() {
        }
    }

    public static class ProcedureWithOverriddenName {
        @Procedure(value="org.mystuff.thisisActuallyTheName")
        public void somethingThatShouldntMatter() {
        }

        @Procedure(value="singleName")
        public void blahDoesntMatterEither() {
        }
    }

    public static class PrivateConstructorButNoProcedures {
        private PrivateConstructorButNoProcedures() {
        }

        public Stream<MyOutputRecord> thisIsNotAProcedure() {
            return null;
        }
    }

    public static class PrivateConstructorProcedure {
        private PrivateConstructorProcedure() {
        }

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }
    }

    public static class ProcedureThatThrowsNullMsgExceptionMidStream {
        @Procedure
        public Stream<MyOutputRecord> throwsInStream() {
            return (Stream)Stream.generate(() -> {
                throw new IndexOutOfBoundsException();
            }).onClose(() -> {
                throw new ExceptionDuringClose();
            });
        }
    }

    public static class ProcedureThatThrowsNullMsgExceptionAtInvocation {
        @Procedure
        public Stream<MyOutputRecord> throwsAtInvocation() {
            throw new IndexOutOfBoundsException();
        }
    }

    public static class ProcedureWithStaticContextAnnotatedField {
        @org.neo4j.procedure.Context
        public static GraphDatabaseService gdb;

        @Procedure
        public Stream<MyOutputRecord> test() {
            return null;
        }
    }

    public static class ProcedureWithInvalidRecordOutput {
        @Procedure
        public String test() {
            return "Testing";
        }
    }

    public static class WierdConstructorProcedure {
        public WierdConstructorProcedure(WierdConstructorProcedure wat) {
        }

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }
    }

    public static class MultiProcedureProcedure {
        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }

        @Procedure
        public Stream<SomeOtherOutputRecord> listBananaOwningPeople() {
            return Stream.of(new SomeOtherOutputRecord("Jake", 18L), new SomeOtherOutputRecord("Pontus", 2L));
        }
    }

    public static class ProcedureWithNonStaticOutputRecord {
        @Procedure
        public Stream<NonStatic> voidOutput() {
            return Stream.of(new NonStatic());
        }

        public class NonStatic {
            public String field = "hello, rodl!";
        }
    }

    public static class ProcedureWithVoidOutput {
        @Procedure
        public void voidOutput() {
        }
    }

    public static class SingleReadOnlyProcedure {
        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }
    }

    public static class LoggingProcedure {
        @org.neo4j.procedure.Context
        public Log log;

        @Procedure
        public Stream<MyOutputRecord> logAround() {
            this.log.debug("1");
            this.log.info("2");
            this.log.warn("3");
            this.log.error("4");
            return Stream.empty();
        }
    }

    public static class SomeOtherOutputRecord {
        public String name;
        public long bananas;

        public SomeOtherOutputRecord(String name, long bananas) {
            this.name = name;
            this.bananas = bananas;
        }
    }

    public static class MyOutputRecord {
        public String name;

        public MyOutputRecord(String name) {
            this.name = name;
        }
    }
}

