/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsDeepStubs;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.ExecutionStatisticsOperations;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.values.virtual.VirtualValues;

public class Neo4jTransactionalContextTest {
    private GraphDatabaseQueryService queryService;
    private Guard guard;
    private KernelStatement initialStatement;
    private ConfiguredPageCursorTracer tracer;
    private ThreadToStatementContextBridge txBridge;

    @Before
    public void setUp() {
        this.setUpMocks();
    }

    @Test
    public void checkKernelStatementOnCheck() throws Exception {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(null, null, this.guard, null, null, initialTransaction, (Statement)this.initialStatement, null);
        transactionalContext.check();
        ((Guard)Mockito.verify((Object)this.guard)).check(this.initialStatement);
    }

    @Test
    public void neverStopsExecutingQueryDuringCommitAndRestartTx() {
        KernelTransaction initialKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction.Type transactionType = KernelTransaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        Mockito.when((Object)initialTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)initialTransaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)initialTransaction.terminationReason()).thenReturn(Optional.empty());
        QueryRegistryOperations initialQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        PropertyContainerLocker locker = null;
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        KernelTransaction secondKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        InternalTransaction secondTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)secondTransaction.terminationReason()).thenReturn(Optional.empty());
        Statement secondStatement = (Statement)Mockito.mock(Statement.class);
        QueryRegistryOperations secondQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn((Object)VirtualValues.EMPTY_MAP);
        Mockito.when((Object)this.initialStatement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)this.queryService.beginTransaction(transactionType, securityContext)).thenReturn((Object)secondTransaction);
        Mockito.when((Object)txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{secondKTX});
        Mockito.when((Object)txBridge.get()).thenReturn((Object)secondStatement);
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(this.queryService, null, this.guard, txBridge, locker, initialTransaction, (Statement)this.initialStatement, executingQuery);
        context.commitAndRestartTx();
        Object[] mocks = new Object[]{txBridge, initialTransaction, initialQueryRegistry, initialKTX, secondQueryRegistry, secondKTX};
        InOrder order = Mockito.inOrder((Object[])mocks);
        ((InternalTransaction)order.verify((Object)initialTransaction)).transactionType();
        ((InternalTransaction)order.verify((Object)initialTransaction)).securityContext();
        ((InternalTransaction)order.verify((Object)initialTransaction)).terminationReason();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).get();
        ((QueryRegistryOperations)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(initialKTX);
        ((QueryRegistryOperations)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
        ((InternalTransaction)order.verify((Object)initialTransaction)).success();
        ((InternalTransaction)order.verify((Object)initialTransaction)).close();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(secondKTX);
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    @Test
    public void rollsBackNewlyCreatedTransactionIfTerminationDetectedOnCloseDuringPeriodicCommit() {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction.Type transactionType = KernelTransaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        Mockito.when((Object)initialTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)initialTransaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)initialTransaction.terminationReason()).thenReturn(Optional.empty());
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        KernelTransaction initialKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Statement initialStatement = (Statement)Mockito.mock(Statement.class);
        QueryRegistryOperations initialQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        ExecutionStatisticsOperations initialExecutionStatisticOperations = (ExecutionStatisticsOperations)Mockito.mock(ExecutionStatisticsOperations.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        PropertyContainerLocker locker = new PropertyContainerLocker();
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        KernelTransaction secondKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        InternalTransaction secondTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)secondTransaction.terminationReason()).thenReturn(Optional.empty());
        Statement secondStatement = (Statement)Mockito.mock(Statement.class);
        QueryRegistryOperations secondQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn((Object)VirtualValues.EMPTY_MAP);
        ((InternalTransaction)Mockito.doThrow(RuntimeException.class).when((Object)initialTransaction)).close();
        Mockito.when((Object)initialStatement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)initialStatement.executionStatisticsOperations()).thenReturn((Object)initialExecutionStatisticOperations);
        Mockito.when((Object)initialExecutionStatisticOperations.getPageCursorTracer()).thenReturn((Object)this.tracer);
        Mockito.when((Object)queryService.beginTransaction(transactionType, securityContext)).thenReturn((Object)secondTransaction);
        Mockito.when((Object)txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{secondKTX});
        Mockito.when((Object)txBridge.get()).thenReturn((Object)secondStatement);
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(queryService, null, this.guard, txBridge, locker, initialTransaction, initialStatement, executingQuery);
        try {
            context.commitAndRestartTx();
            throw new AssertionError((Object)"Expected RuntimeException to be thrown");
        }
        catch (RuntimeException e) {
            Object[] mocks = new Object[]{txBridge, initialTransaction, initialQueryRegistry, initialKTX, secondQueryRegistry, secondKTX, secondTransaction};
            InOrder order = Mockito.inOrder((Object[])mocks);
            ((InternalTransaction)order.verify((Object)initialTransaction)).transactionType();
            ((InternalTransaction)order.verify((Object)initialTransaction)).securityContext();
            ((InternalTransaction)order.verify((Object)initialTransaction)).terminationReason();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).get();
            ((QueryRegistryOperations)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(initialKTX);
            ((QueryRegistryOperations)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
            ((InternalTransaction)order.verify((Object)initialTransaction)).success();
            ((InternalTransaction)order.verify((Object)initialTransaction)).close();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(secondKTX);
            ((InternalTransaction)order.verify((Object)secondTransaction)).failure();
            ((InternalTransaction)order.verify((Object)secondTransaction)).close();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            Mockito.verifyNoMoreInteractions((Object[])mocks);
            return;
        }
    }

    @Test
    public void accumulateExecutionStatisticOverCommitAndRestart() {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)initialTransaction.terminationReason()).thenReturn(Optional.empty());
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(this.queryService, null, this.guard, this.txBridge, null, initialTransaction, (Statement)this.initialStatement, null);
        this.tracer.setFaults(2L);
        this.tracer.setHits(5L);
        transactionalContext.commitAndRestartTx();
        this.tracer.setFaults(2L);
        this.tracer.setHits(5L);
        transactionalContext.commitAndRestartTx();
        this.tracer.setFaults(2L);
        this.tracer.setHits(5L);
        StatisticProvider statisticProvider = transactionalContext.kernelStatisticProvider();
        Assert.assertEquals((String)"Expect to see accumulated number of page cache misses.", (long)6L, (long)statisticProvider.getPageCacheMisses());
        Assert.assertEquals((String)"Expected to see accumulated number of page cache hits.", (long)15L, (long)statisticProvider.getPageCacheHits());
    }

    @Test
    public void shouldBeOpenAfterCreation() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assert.assertTrue((boolean)context.isOpen());
    }

    @Test
    public void shouldBeTopLevelWithImplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assert.assertTrue((boolean)context.isTopLevelTx());
    }

    @Test
    public void shouldNotBeTopLevelWithExplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.explicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        Assert.assertFalse((boolean)context.isTopLevelTx());
    }

    @Test
    public void shouldNotCloseTransactionDuringTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void shouldBePossibleToCloseAfterTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.implicit);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
        context.close(false);
        ((InternalTransaction)Mockito.verify((Object)tx)).failure();
        ((InternalTransaction)Mockito.verify((Object)tx)).close();
    }

    @Test
    public void shouldBePossibleToTerminateWithoutActiveTransaction() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.close(true);
        ((InternalTransaction)Mockito.verify((Object)tx)).success();
        ((InternalTransaction)Mockito.verify((Object)tx)).close();
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).terminate();
    }

    @Test
    public void shouldThrowWhenRestartedAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable(terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        try {
            context.commitAndRestartTx();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void shouldThrowWhenGettingTxAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable(terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        try {
            context.getOrBeginNewIfClosed();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void shouldNotBePossibleToCloseMultipleTimes() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.close(false);
        context.close(true);
        context.close(false);
        ((InternalTransaction)Mockito.verify((Object)tx)).failure();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).success();
        ((InternalTransaction)Mockito.verify((Object)tx)).close();
    }

    private void setUpMocks() {
        this.queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        this.txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        this.guard = (Guard)Mockito.mock(Guard.class);
        this.initialStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        this.tracer = new ConfiguredPageCursorTracer();
        QueryRegistryOperations queryRegistryOperations = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        ExecutionStatisticsOperations executionStatisticsOperations = (ExecutionStatisticsOperations)Mockito.mock(ExecutionStatisticsOperations.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)internalTransaction.terminationReason()).thenReturn(Optional.empty());
        Mockito.when((Object)this.initialStatement.queryRegistration()).thenReturn((Object)queryRegistryOperations);
        Mockito.when((Object)this.initialStatement.executionStatisticsOperations()).thenReturn((Object)executionStatisticsOperations);
        Mockito.when((Object)executionStatisticsOperations.getPageCursorTracer()).thenReturn((Object)this.tracer);
        Mockito.when((Object)this.queryService.getDependencyResolver()).thenReturn((Object)resolver);
        Mockito.when((Object)resolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)this.txBridge);
        Mockito.when((Object)resolver.resolveDependency(Guard.class)).thenReturn((Object)this.guard);
        Mockito.when((Object)this.queryService.beginTransaction((KernelTransaction.Type)org.mockito.Matchers.any(), (SecurityContext)org.mockito.Matchers.any())).thenReturn((Object)internalTransaction);
        Mockito.when((Object)this.txBridge.get()).thenReturn((Object)this.initialStatement);
    }

    private Neo4jTransactionalContext newContext(InternalTransaction initialTx) {
        return new Neo4jTransactionalContext(this.queryService, null, this.guard, this.txBridge, new PropertyContainerLocker(), initialTx, (Statement)this.initialStatement, null);
    }

    private class ConfiguredPageCursorTracer
    extends DefaultPageCursorTracer {
        private long hits;
        private long faults;

        private ConfiguredPageCursorTracer() {
        }

        public long hits() {
            return super.hits() + this.hits;
        }

        public long faults() {
            return super.faults() + this.faults;
        }

        void setHits(long hits) {
            this.hits = hits;
        }

        void setFaults(long faults) {
            this.faults = faults;
        }
    }
}

