/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.ConfigurablePageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.recording.Event;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCursorTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdCapacityExceededException;
import org.neo4j.kernel.impl.store.id.validation.NegativeIdException;
import org.neo4j.kernel.impl.store.id.validation.ReservedIdException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.ConfigurablePageCacheRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class CommonAbstractStoreTest {
    private static final int PAGE_SIZE = 32;
    private static final int RECORD_SIZE = 10;
    private static final int HIGH_ID = 42;
    private final IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);
    private final IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
    private final PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
    private final PagedFile pageFile = (PagedFile)Mockito.mock(PagedFile.class);
    private final PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private final Config config = Config.defaults();
    private final File storeFile = new File("store");
    private final RecordFormat<TheRecord> recordFormat = (RecordFormat)Mockito.mock(RecordFormat.class);
    private final IdType idType = IdType.RELATIONSHIP;
    private static final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private static final TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)fileSystemRule.get());
    private static final ConfigurablePageCacheRule pageCacheRule = new ConfigurablePageCacheRule();
    @ClassRule
    public static final RuleChain ruleChain = RuleChain.outerRule((TestRule)fileSystemRule).around((TestRule)dir).around((TestRule)pageCacheRule);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUpMocks() throws IOException {
        Mockito.when((Object)this.idGeneratorFactory.open((File)Matchers.any(File.class), (IdType)Matchers.eq((Object)this.idType), (Supplier)Matchers.any(Supplier.class), (long)Matchers.anyInt())).thenReturn((Object)this.idGenerator);
        Mockito.when((Object)this.pageFile.pageSize()).thenReturn((Object)32);
        Mockito.when((Object)this.pageFile.io(Matchers.anyLong(), Matchers.anyInt())).thenReturn((Object)this.pageCursor);
        Mockito.when((Object)this.pageCache.map((File)Matchers.eq((Object)this.storeFile), Matchers.anyInt(), new OpenOption[0])).thenReturn((Object)this.pageFile);
    }

    @Test
    public void shouldCloseStoreFileFirstAndIdGeneratorAfter() throws Throwable {
        TheStore store = this.newStore();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.pageFile, this.idGenerator});
        store.close();
        ((PagedFile)inOrder.verify((Object)this.pageFile, Mockito.times((int)1))).close();
        ((IdGenerator)inOrder.verify((Object)this.idGenerator, Mockito.times((int)1))).close();
    }

    @Test
    public void recordCursorCallsNextOnThePageCursor() throws IOException {
        TheStore store = this.newStore();
        long recordId = 4L;
        long pageIdForRecord = store.pageIdForRecord(recordId);
        Mockito.when((Object)this.pageCursor.getCurrentPageId()).thenReturn((Object)pageIdForRecord);
        Mockito.when((Object)this.pageCursor.next((long)Matchers.anyInt())).thenReturn((Object)true);
        RecordCursor cursor = store.newRecordCursor(this.newRecord(-1L));
        cursor.acquire(recordId, RecordLoad.FORCE);
        cursor.next(recordId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.pageCursor});
        ((PageCursor)order.verify((Object)this.pageCursor)).next(pageIdForRecord);
        ((PageCursor)order.verify((Object)this.pageCursor)).shouldRetry();
    }

    @Test
    public void failStoreInitializationWhenHeaderRecordCantBeRead() throws IOException {
        File storeFile = dir.file("a");
        PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
        PagedFile pagedFile = (PagedFile)Mockito.mock(PagedFile.class);
        PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)pageCache.map((File)Matchers.eq((Object)storeFile), Matchers.anyInt(), new OpenOption[]{(OpenOption)Matchers.any(OpenOption.class)})).thenReturn((Object)pagedFile);
        Mockito.when((Object)pagedFile.io(0L, 1)).thenReturn((Object)pageCursor);
        Mockito.when((Object)pageCursor.next()).thenReturn((Object)false);
        RecordFormats recordFormats = Standard.LATEST_RECORD_FORMATS;
        this.expectedException.expect(StoreNotFoundException.class);
        this.expectedException.expectMessage("Fail to read header record of store file: " + storeFile.getAbsolutePath());
        try (DynamicArrayStore dynamicArrayStore = new DynamicArrayStore(storeFile, this.config, IdType.NODE_LABELS, this.idGeneratorFactory, pageCache, (LogProvider)NullLogProvider.getInstance(), ((Integer)Settings.INTEGER.apply(GraphDatabaseSettings.label_block_size.getDefaultValue())).intValue(), recordFormats.dynamic(), recordFormats.storeVersion(), new OpenOption[0]);){
            dynamicArrayStore.initialise(false);
        }
    }

    @Test
    public void recordCursorPinsEachPageItReads() throws Exception {
        File storeFile = dir.file("a");
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer pageCursorTracer = new RecordingPageCursorTracer(new Class[]{RecordingPageCursorTracer.Pin.class});
        PageCacheRule.PageCacheConfig pageCacheConfig = PageCacheRule.config().withTracer((PageCacheTracer)tracer).withCursorTracerSupplier((PageCursorTracerSupplier)CommonAbstractStoreTest.pageCursorTracerSupplier(pageCursorTracer));
        PageCache pageCache = pageCacheRule.getPageCache(fileSystemRule.get(), pageCacheConfig, Config.defaults());
        try (NodeStore store = new NodeStore(storeFile, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystemRule.get()), pageCache, (LogProvider)NullLogProvider.getInstance(), null, Standard.LATEST_RECORD_FORMATS, new OpenOption[0]);){
            store.initialise(true);
            Assert.assertNull((Object)tracer.tryObserve(Event.class));
            long nodeId1 = this.insertNodeRecordAndObservePinEvent(pageCursorTracer, store);
            long nodeId2 = this.insertNodeRecordAndObservePinEvent(pageCursorTracer, store);
            try (RecordCursor cursor = store.newRecordCursor(store.newRecord());){
                cursor.acquire(0L, RecordLoad.NORMAL);
                Assert.assertTrue((boolean)cursor.next(nodeId1));
                Assert.assertTrue((boolean)cursor.next(nodeId2));
            }
            Assert.assertNotNull((Object)pageCursorTracer.tryObserve(RecordingPageCursorTracer.Pin.class));
            Assert.assertNull((Object)pageCursorTracer.tryObserve(Event.class));
        }
    }

    @Test
    public void recordCursorGetAllForEmptyCursor() throws IOException {
        TheStore store = this.newStore();
        long recordId = 4L;
        long pageIdForRecord = store.pageIdForRecord(recordId);
        Mockito.when((Object)this.pageCursor.getCurrentPageId()).thenReturn((Object)pageIdForRecord);
        Mockito.when((Object)this.pageCursor.next((long)Matchers.anyInt())).thenReturn((Object)false);
        RecordCursor cursor = store.newRecordCursor(this.newRecord(-1L));
        cursor.acquire(recordId, RecordLoad.FORCE);
        Assert.assertThat((Object)cursor.getAll(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.empty()));
    }

    @Test
    public void recordCursorGetAll() {
        TheStore store = this.newStore();
        RecordCursor cursor = (RecordCursor)Mockito.spy((Object)store.newRecordCursor(store.newRecord()));
        ((RecordCursor)Mockito.doReturn((Object)true).doReturn((Object)true).doReturn((Object)true).doReturn((Object)false).when((Object)cursor)).next();
        ((RecordCursor)Mockito.doReturn((Object)((Object)this.newRecord(1L))).doReturn((Object)this.newRecord(5L)).doReturn((Object)this.newRecord(42L)).when((Object)cursor)).get();
        Assert.assertEquals(Arrays.asList(this.newRecord(1L), this.newRecord(5L), this.newRecord(42L)), (Object)cursor.getAll());
    }

    @Test
    public void throwsWhenRecordWithNegativeIdIsUpdated() {
        TheStore store = this.newStore();
        TheRecord record = this.newRecord(-1L);
        try {
            store.updateRecord(record);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(NegativeIdException.class));
        }
    }

    @Test
    public void throwsWhenRecordWithTooHighIdIsUpdated() {
        long maxFormatId = 42L;
        Mockito.when((Object)this.recordFormat.getMaxId()).thenReturn((Object)maxFormatId);
        TheStore store = this.newStore();
        TheRecord record = this.newRecord(maxFormatId + 1L);
        try {
            store.updateRecord(record);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(IdCapacityExceededException.class));
        }
    }

    @Test
    public void throwsWhenRecordWithReservedIdIsUpdated() {
        TheStore store = this.newStore();
        TheRecord record = this.newRecord(0xFFFFFFFFL);
        try {
            store.updateRecord(record);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(ReservedIdException.class));
        }
    }

    @Test
    public void shouldDeleteOnCloseIfOpenOptionsSaysSo() throws Exception {
        File file = dir.file("store").getAbsoluteFile();
        File idFile = new File(file.getParentFile(), StoreFileType.ID.augment(file.getName()));
        FileSystemAbstraction fs = fileSystemRule.get();
        PageCache pageCache = pageCacheRule.getPageCache(fs, Config.defaults());
        TheStore store = new TheStore(file, this.config, this.idType, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs), pageCache, (LogProvider)NullLogProvider.getInstance(), this.recordFormat, StandardOpenOption.DELETE_ON_CLOSE);
        store.initialise(true);
        store.makeStoreOk();
        Assert.assertTrue((boolean)fs.fileExists(file));
        Assert.assertTrue((boolean)fs.fileExists(idFile));
        store.close();
        Assert.assertFalse((boolean)fs.fileExists(file));
        Assert.assertFalse((boolean)fs.fileExists(idFile));
    }

    private TheStore newStore() {
        NullLogProvider log = NullLogProvider.getInstance();
        TheStore store = new TheStore(this.storeFile, this.config, this.idType, this.idGeneratorFactory, this.pageCache, (LogProvider)log, this.recordFormat, new OpenOption[0]);
        store.initialise(false);
        return store;
    }

    private TheRecord newRecord(long id) {
        return new TheRecord(id);
    }

    private long insertNodeRecordAndObservePinEvent(RecordingPageCursorTracer tracer, NodeStore store) {
        long nodeId = store.nextId();
        NodeRecord record = (NodeRecord)store.newRecord();
        record.setId(nodeId);
        record.initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 42L);
        store.prepareForCommit((AbstractBaseRecord)record);
        store.updateRecord(record);
        Assert.assertNotNull((Object)tracer.tryObserve(RecordingPageCursorTracer.Pin.class));
        Assert.assertNull((Object)tracer.tryObserve(Event.class));
        return nodeId;
    }

    private static ConfigurablePageCursorTracerSupplier pageCursorTracerSupplier(RecordingPageCursorTracer pageCursorTracer) {
        return new ConfigurablePageCursorTracerSupplier((PageCursorTracer)pageCursorTracer);
    }

    private static class TheRecord
    extends AbstractBaseRecord {
        TheRecord(long id) {
            super(id);
        }

        public TheRecord clone() {
            return new TheRecord(this.getId());
        }
    }

    private static class TheStore
    extends CommonAbstractStore<TheRecord, NoStoreHeader> {
        TheStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormat<TheRecord> recordFormat, OpenOption ... openOptions) {
            super(fileName, configuration, idType, idGeneratorFactory, pageCache, logProvider, "TheType", recordFormat, (StoreHeaderFormat)NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, "v1", openOptions);
        }

        protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        }

        protected int determineRecordSize() {
            return 10;
        }

        public long scanForHighId() {
            return 42L;
        }

        public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, TheRecord record) throws FAILURE {
        }
    }
}

