/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class FreeIdsAfterRecoveryTest {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);

    @Test
    public void shouldCompletelyRebuildIdGeneratorsAfterCrash() throws Exception {
        long highId;
        StoreFactory storeFactory = new StoreFactory(this.directory.directory(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fileSystemRule.get()), this.pageCacheRule.getPageCache(this.fileSystemRule.get()), this.fileSystemRule.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        try (NeoStores stores = storeFactory.openAllNeoStores(true);){
            NodeStore nodeStore = stores.getNodeStore();
            nodeStore.setHighId(20L);
            nodeStore.updateRecord(this.node(nodeStore.nextId()));
            highId = nodeStore.getHighId();
        }
        File nodeIdFile = new File(this.directory.directory(), StoreFile.NODE_STORE.fileName(StoreFileType.ID));
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fileSystemRule.get(), nodeIdFile, 10, 10000L, false, () -> highId);
        for (long id = 0L; id < 15L; ++id) {
            idGenerator.freeId(id);
        }
        try (NeoStores stores = storeFactory.openAllNeoStores(true);){
            NodeStore nodeStore = stores.getNodeStore();
            Assert.assertFalse((boolean)nodeStore.getStoreOk());
            nodeStore.deleteIdGenerator();
            nodeStore.makeStoreOk();
            Assert.assertEquals((long)highId, (long)nodeStore.nextId());
        }
    }

    private NodeRecord node(long nextId) {
        NodeRecord node = new NodeRecord(nextId);
        node.setInUse(true);
        return node;
    }
}

