/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;

public class LabelTokenStoreTest {
    private final File file = (File)Mockito.mock(File.class);
    private final IdGeneratorFactory generatorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
    private final PageCache cache = (PageCache)Mockito.mock(PageCache.class);
    private final LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
    private final DynamicStringStore dynamicStringStore = (DynamicStringStore)Mockito.mock(DynamicStringStore.class);
    private final PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
    private final Config config = Config.defaults();

    @Test
    public void forceGetRecordSkipInUsecheck() throws IOException {
        UnusedLabelTokenStore store = new UnusedLabelTokenStore();
        LabelTokenRecord record = (LabelTokenRecord)store.getRecord(7L, store.newRecord(), RecordLoad.FORCE);
        Assert.assertFalse((String)"Record should not be in use", (boolean)record.inUse());
    }

    @Test(expected=InvalidRecordException.class)
    public void getRecord() throws IOException {
        Mockito.when((Object)this.pageCursor.getByte()).thenReturn((Object)Record.NOT_IN_USE.byteValue());
        UnusedLabelTokenStore store = new UnusedLabelTokenStore();
        store.getRecord(7L, store.newRecord(), RecordLoad.NORMAL);
    }

    class UnusedLabelTokenStore
    extends LabelTokenStore {
        UnusedLabelTokenStore() throws IOException {
            super(LabelTokenStoreTest.this.file, LabelTokenStoreTest.this.config, LabelTokenStoreTest.this.generatorFactory, LabelTokenStoreTest.this.cache, LabelTokenStoreTest.this.logProvider, LabelTokenStoreTest.this.dynamicStringStore, RecordFormatSelector.defaultFormat(), new OpenOption[0]);
            this.storeFile = (PagedFile)Mockito.mock(PagedFile.class);
            Mockito.when((Object)this.storeFile.io(((Long)Matchers.any(Long.class)).longValue(), ((Integer)Matchers.any(Integer.class)).intValue())).thenReturn((Object)LabelTokenStoreTest.this.pageCursor);
            Mockito.when((Object)this.storeFile.pageSize()).thenReturn((Object)1);
            Mockito.when((Object)LabelTokenStoreTest.this.pageCursor.next()).thenReturn((Object)true);
        }
    }
}

