/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.DelegatingPagedFile;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.DelegatingPageCursor;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.NullLogger;
import org.neo4j.test.Race;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class MetaDataStoreTest {
    private static final File STORE_DIR = new File("store");
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withInconsistentReads(false));
    private EphemeralFileSystemAbstraction fs;
    private PageCache pageCache;
    private boolean fakePageCursorOverflow;
    private PageCache pageCacheWithFakeOverflow;

    @Before
    public void setUp() {
        this.fs = (EphemeralFileSystemAbstraction)this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
        this.fakePageCursorOverflow = false;
        this.pageCacheWithFakeOverflow = new DelegatingPageCache(this.pageCache){

            public PagedFile map(File file, int pageSize, OpenOption ... openOptions) throws IOException {
                return new DelegatingPagedFile(super.map(file, pageSize, openOptions)){

                    public PageCursor io(long pageId, int pf_flags) throws IOException {
                        return new DelegatingPageCursor(super.io(pageId, pf_flags)){

                            public boolean checkAndClearBoundsFlag() {
                                return MetaDataStoreTest.this.fakePageCursorOverflow | super.checkAndClearBoundsFlag();
                            }
                        };
                    }
                };
            }
        };
    }

    private MetaDataStore newMetaDataStore() throws IOException {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(STORE_DIR, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs), this.pageCacheWithFakeOverflow, (FileSystemAbstraction)this.fs, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY);
        return storeFactory.openNeoStores(true, new StoreType[]{StoreType.META_DATA}).getMetaDataStore();
    }

    @Test
    public void getCreationTimeShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getCreationTime();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getCurrentLogVersionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getCurrentLogVersion();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getGraphNextPropShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getGraphNextProp();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastClosedTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastClosedTransactionId();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastClosedTransactionShouldFailWhenStoreIsClosed() throws Exception {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastClosedTransaction();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastCommittedTransactionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastCommittedTransaction();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastCommittedTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastCommittedTransactionId();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLatestConstraintIntroducingTxShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLatestConstraintIntroducingTx();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getRandomNumberShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getRandomNumber();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getStoreVersionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getStoreVersion();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getUpgradeTimeShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getUpgradeTime();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getUpgradeTransactionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getUpgradeTransaction();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void nextCommittingTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.nextCommittingTransactionId();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void setLastCommittedAndClosedTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.setLastCommittedAndClosedTransactionId(1L, 2L, 0L, 3L, 4L);
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void transactionCommittedShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.transactionCommitted(1L, 1L, 0L);
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void testRecordTransactionClosed() throws Exception {
        MetaDataStore metaDataStore = this.newMetaDataStore();
        long[] originalClosedTransaction = metaDataStore.getLastClosedTransaction();
        long transactionId = originalClosedTransaction[0] + 1L;
        long version = 1L;
        long byteOffset = 777L;
        metaDataStore.transactionClosed(transactionId, version, byteOffset);
        long[] closedTransactionFlags = metaDataStore.getLastClosedTransaction();
        Assert.assertEquals((long)version, (long)closedTransactionFlags[1]);
        Assert.assertEquals((long)byteOffset, (long)closedTransactionFlags[2]);
        metaDataStore.close();
        metaDataStore = this.newMetaDataStore();
        long[] lastClosedTransactionFlags = metaDataStore.getLastClosedTransaction();
        Assert.assertEquals((long)version, (long)lastClosedTransactionFlags[1]);
        Assert.assertEquals((long)byteOffset, (long)lastClosedTransactionFlags[2]);
        metaDataStore.close();
    }

    @Test
    public void setUpgradeTransactionMustBeAtomic() throws Throwable {
        try (MetaDataStore store = this.newMetaDataStore();){
            PagedFile pf = store.storeFile;
            store.setUpgradeTransaction(0L, 0L, 0L);
            AtomicLong writeCount = new AtomicLong();
            AtomicLong fileReadCount = new AtomicLong();
            AtomicLong apiReadCount = new AtomicLong();
            int upperLimit = 10000;
            int lowerLimit = 100;
            long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
            Race race = new Race();
            race.withEndCondition(new BooleanSupplier[]{() -> writeCount.get() >= (long)upperLimit && fileReadCount.get() >= (long)upperLimit && apiReadCount.get() >= (long)upperLimit});
            race.withEndCondition(new BooleanSupplier[]{() -> writeCount.get() >= (long)lowerLimit && fileReadCount.get() >= (long)lowerLimit && apiReadCount.get() >= (long)lowerLimit && System.currentTimeMillis() >= endTime});
            race.addContestants(3, () -> {
                long count = writeCount.incrementAndGet();
                store.setUpgradeTransaction(count, count, count);
            });
            race.addContestants(3, Race.throwing(() -> {
                try (PageCursor cursor = pf.io(0L, 1);){
                    long checksum;
                    long id;
                    Assert.assertTrue((boolean)cursor.next());
                    do {
                        id = store.getRecordValue(cursor, MetaDataStore.Position.UPGRADE_TRANSACTION_ID);
                        checksum = store.getRecordValue(cursor, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM);
                    } while (cursor.shouldRetry());
                    MetaDataStoreTest.assertIdEqualsChecksum(id, checksum, "file");
                    fileReadCount.incrementAndGet();
                }
            }));
            race.addContestants(3, () -> {
                TransactionId transaction = store.getUpgradeTransaction();
                MetaDataStoreTest.assertIdEqualsChecksum(transaction.transactionId(), transaction.checksum(), "API");
                apiReadCount.incrementAndGet();
            });
            race.go();
        }
    }

    private static void assertIdEqualsChecksum(long id, long checksum, String source) {
        if (id != checksum) {
            throw new AssertionError((Object)("id (" + id + ") and checksum (" + checksum + ") from " + source + " should be identical"));
        }
    }

    @Test
    public void incrementAndGetVersionMustBeAtomic() throws Throwable {
        try (MetaDataStore store = this.newMetaDataStore();){
            long initialVersion = store.incrementAndGetVersion();
            int threads = Runtime.getRuntime().availableProcessors();
            int iterations = 500;
            Race race = new Race();
            race.addContestants(threads, () -> {
                for (int i = 0; i < iterations; ++i) {
                    store.incrementAndGetVersion();
                }
            });
            race.go();
            Assert.assertThat((Object)store.incrementAndGetVersion(), (Matcher)Matchers.is((Object)(initialVersion + (long)(threads * iterations) + 1L)));
        }
    }

    @Test
    public void transactionCommittedMustBeAtomic() throws Throwable {
        try (MetaDataStore store = this.newMetaDataStore();){
            PagedFile pf = store.storeFile;
            store.transactionCommitted(2L, 2L, 2L);
            AtomicLong writeCount = new AtomicLong();
            AtomicLong fileReadCount = new AtomicLong();
            AtomicLong apiReadCount = new AtomicLong();
            int upperLimit = 10000;
            int lowerLimit = 100;
            long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
            Race race = new Race();
            race.withEndCondition(new BooleanSupplier[]{() -> writeCount.get() >= (long)upperLimit && fileReadCount.get() >= (long)upperLimit && apiReadCount.get() >= (long)upperLimit});
            race.withEndCondition(new BooleanSupplier[]{() -> writeCount.get() >= (long)lowerLimit && fileReadCount.get() >= (long)lowerLimit && apiReadCount.get() >= (long)lowerLimit && System.currentTimeMillis() >= endTime});
            race.addContestants(3, () -> {
                long count = writeCount.incrementAndGet();
                store.transactionCommitted(count, count, count);
            });
            race.addContestants(3, Race.throwing(() -> {
                try (PageCursor cursor = pf.io(0L, 1);){
                    long checksum;
                    long id;
                    Assert.assertTrue((boolean)cursor.next());
                    do {
                        id = store.getRecordValue(cursor, MetaDataStore.Position.LAST_TRANSACTION_ID);
                        checksum = store.getRecordValue(cursor, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
                    } while (cursor.shouldRetry());
                    MetaDataStoreTest.assertIdEqualsChecksum(id, checksum, "file");
                    fileReadCount.incrementAndGet();
                }
            }));
            race.addContestants(3, () -> {
                TransactionId transaction = store.getLastCommittedTransaction();
                MetaDataStoreTest.assertIdEqualsChecksum(transaction.transactionId(), transaction.checksum(), "API");
                apiReadCount.incrementAndGet();
            });
            race.go();
        }
    }

    @Test
    public void transactionClosedMustBeAtomic() throws Throwable {
        try (MetaDataStore store = this.newMetaDataStore();){
            PagedFile pf = store.storeFile;
            int initialValue = 2;
            store.transactionClosed((long)initialValue, (long)initialValue, (long)initialValue);
            AtomicLong writeCount = new AtomicLong();
            AtomicLong fileReadCount = new AtomicLong();
            AtomicLong apiReadCount = new AtomicLong();
            int upperLimit = 10000;
            int lowerLimit = 100;
            long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
            Race race = new Race();
            race.withEndCondition(new BooleanSupplier[]{() -> writeCount.get() >= (long)upperLimit && fileReadCount.get() >= (long)upperLimit && apiReadCount.get() >= (long)upperLimit});
            race.withEndCondition(new BooleanSupplier[]{() -> writeCount.get() >= (long)lowerLimit && fileReadCount.get() >= (long)lowerLimit && apiReadCount.get() >= (long)lowerLimit && System.currentTimeMillis() >= endTime});
            race.addContestants(3, () -> {
                long count = writeCount.incrementAndGet();
                store.transactionCommitted(count, count, count);
            });
            race.addContestants(3, Race.throwing(() -> {
                try (PageCursor cursor = pf.io(0L, 1);){
                    long byteOffset;
                    long logVersion;
                    Assert.assertTrue((boolean)cursor.next());
                    do {
                        logVersion = store.getRecordValue(cursor, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
                        byteOffset = store.getRecordValue(cursor, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
                    } while (cursor.shouldRetry());
                    MetaDataStoreTest.assertLogVersionEqualsByteOffset(logVersion, byteOffset, "file");
                    fileReadCount.incrementAndGet();
                }
            }));
            race.addContestants(3, () -> {
                long[] transaction = store.getLastClosedTransaction();
                MetaDataStoreTest.assertLogVersionEqualsByteOffset(transaction[0], transaction[1], "API");
                apiReadCount.incrementAndGet();
            });
            race.go();
        }
    }

    private static void assertLogVersionEqualsByteOffset(long logVersion, long byteOffset, String source) {
        if (logVersion != byteOffset) {
            throw new AssertionError((Object)("logVersion (" + logVersion + ") and byteOffset (" + byteOffset + ") from " + source + " should be identical"));
        }
    }

    @Test
    public void mustSupportScanningAllRecords() throws Exception {
        File file = this.createMetaDataFile();
        MetaDataStore.Position[] positions = MetaDataStore.Position.values();
        long storeVersion = MetaDataStore.versionStringToLong((String)Standard.LATEST_RECORD_FORMATS.storeVersion());
        this.writeCorrectMetaDataRecord(file, positions, storeVersion);
        ArrayList actualValues = new ArrayList();
        try (MetaDataStore store = this.newMetaDataStore();){
            store.scanAllRecords(record -> {
                actualValues.add(record.getValue());
                return false;
            });
        }
        List expectedValues = Arrays.stream(positions).map(p -> {
            if (p == MetaDataStore.Position.STORE_VERSION) {
                return storeVersion;
            }
            return (long)p.ordinal() + 1L;
        }).collect(Collectors.toList());
        Assert.assertThat(actualValues, (Matcher)Matchers.is(expectedValues));
    }

    private File createMetaDataFile() throws IOException {
        File file = new File(STORE_DIR, "neostore");
        this.fs.mkdir(STORE_DIR);
        this.fs.create(file).close();
        return file;
    }

    @Test
    public void mustSupportScanningAllRecordsWithRecordCursor() throws Exception {
        File file = this.createMetaDataFile();
        MetaDataStore.Position[] positions = MetaDataStore.Position.values();
        long storeVersion = MetaDataStore.versionStringToLong((String)Standard.LATEST_RECORD_FORMATS.storeVersion());
        this.writeCorrectMetaDataRecord(file, positions, storeVersion);
        ArrayList<Long> actualValues = new ArrayList<Long>();
        try (MetaDataStore store = this.newMetaDataStore();){
            MetaDataRecord record = store.newRecord();
            try (RecordCursor cursor = store.newRecordCursor((AbstractBaseRecord)record);){
                cursor.acquire(0L, RecordLoad.NORMAL);
                long highId = store.getHighId();
                for (long id = 0L; id < highId; ++id) {
                    if (!cursor.next(id)) continue;
                    actualValues.add(record.getValue());
                }
            }
        }
        List expectedValues = Arrays.stream(positions).map(p -> {
            if (p == MetaDataStore.Position.STORE_VERSION) {
                return storeVersion;
            }
            return (long)p.ordinal() + 1L;
        }).collect(Collectors.toList());
        Assert.assertThat(actualValues, (Matcher)Matchers.is(expectedValues));
    }

    private void writeCorrectMetaDataRecord(File file, MetaDataStore.Position[] positions, long storeVersion) throws IOException {
        for (MetaDataStore.Position position : positions) {
            if (position == MetaDataStore.Position.STORE_VERSION) {
                MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)position, (long)storeVersion);
                continue;
            }
            MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)position, (long)(position.ordinal() + 1));
        }
    }

    @Test(expected=UnderlyingStorageException.class)
    public void staticSetRecordMustThrowOnPageOverflow() throws Exception {
        this.fakePageCursorOverflow = true;
        MetaDataStore.setRecord((PageCache)this.pageCacheWithFakeOverflow, (File)this.createMetaDataFile(), (MetaDataStore.Position)MetaDataStore.Position.FIRST_GRAPH_PROPERTY, (long)4242L);
    }

    @Test(expected=UnderlyingStorageException.class)
    public void staticGetRecordMustThrowOnPageOverflow() throws Exception {
        File metaDataFile = this.createMetaDataFile();
        MetaDataStore.setRecord((PageCache)this.pageCacheWithFakeOverflow, (File)metaDataFile, (MetaDataStore.Position)MetaDataStore.Position.FIRST_GRAPH_PROPERTY, (long)4242L);
        this.fakePageCursorOverflow = true;
        MetaDataStore.getRecord((PageCache)this.pageCacheWithFakeOverflow, (File)metaDataFile, (MetaDataStore.Position)MetaDataStore.Position.FIRST_GRAPH_PROPERTY);
    }

    @Test(expected=UnderlyingStorageException.class)
    public void incrementVersionMustThrowOnPageOverflow() throws Exception {
        try (MetaDataStore store = this.newMetaDataStore();){
            this.fakePageCursorOverflow = true;
            store.incrementAndGetVersion();
        }
    }

    @Test
    public void lastTxCommitTimestampShouldBeBaseInNewStore() throws Exception {
        try (MetaDataStore metaDataStore = this.newMetaDataStore();){
            long timestamp = metaDataStore.getLastCommittedTransaction().commitTimestamp();
            Assert.assertThat((Object)timestamp, (Matcher)Matchers.equalTo((Object)0L));
        }
    }

    @Test(expected=UnderlyingStorageException.class)
    public void readAllFieldsMustThrowOnPageOverflow() throws Exception {
        try (MetaDataStore store = this.newMetaDataStore();){
            store.setUpgradeTime(Long.MIN_VALUE);
            this.fakePageCursorOverflow = true;
            store.getUpgradeTime();
        }
    }

    @Test(expected=UnderlyingStorageException.class)
    public void setRecordMustThrowOnPageOverflow() throws Exception {
        try (MetaDataStore store = this.newMetaDataStore();){
            this.fakePageCursorOverflow = true;
            store.setUpgradeTransaction(13L, 42L, 42L);
        }
    }

    @Test
    public void logRecordsMustIgnorePageOverflow() throws Exception {
        try (MetaDataStore store = this.newMetaDataStore();){
            this.fakePageCursorOverflow = true;
            store.logRecords((Logger)NullLogger.getInstance());
        }
    }
}

