/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class RelationshipChainPointerChasingTest {
    private static final int THRESHOLD = 10;
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule().withSetting(GraphDatabaseSettings.dense_node_threshold, String.valueOf(10));

    @Test
    public void shouldChaseTheLivingRelationships() throws Exception {
        Relationship[] relationships;
        Node node;
        int numberOfRelationships = 5;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            for (int i = 0; i < numberOfRelationships; ++i) {
                node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            relationships = (Relationship[])Iterables.asArray(Relationship.class, (Iterable)node.getRelationships());
            tx.success();
        }
        tx = this.db.beginTx();
        var5_8 = null;
        try {
            Iterator<Relationship> iterator = node.getRelationships().iterator();
            this.deleteRelationshipsInSeparateThread(relationships[1], relationships[2]);
            this.assertNext(relationships[0], iterator);
            this.assertNext(relationships[3], iterator);
            this.assertNext(relationships[4], iterator);
            Assert.assertFalse((boolean)iterator.hasNext());
            tx.success();
        }
        catch (Throwable throwable) {
            var5_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldChaseTheLivingRelationshipGroups() throws Exception {
        Relationship relationshipInTheEnd;
        Relationship relationshipInTheMiddle;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            for (int i = 0; i < 10; ++i) {
                node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            relationshipInTheMiddle = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST2);
            relationshipInTheEnd = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            tx.success();
        }
        tx = this.db.beginTx();
        var5_2 = null;
        try {
            int i;
            Iterator<Relationship> relationships = node.getRelationships().iterator();
            for (i = 0; i < 5; ++i) {
                Assert.assertTrue((boolean)((Relationship)relationships.next()).isType((RelationshipType)MyRelTypes.TEST));
            }
            this.deleteRelationshipsInSeparateThread(relationshipInTheMiddle);
            for (i = 0; i < 5; ++i) {
                Assert.assertTrue((boolean)((Relationship)relationships.next()).isType((RelationshipType)MyRelTypes.TEST));
            }
            this.assertNext(relationshipInTheEnd, relationships);
            Assert.assertFalse((boolean)relationships.hasNext());
            tx.success();
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertNext(Relationship expected, Iterator<Relationship> iterator) {
        Assert.assertTrue((String)"Expected there to be more relationships", (boolean)iterator.hasNext());
        Assert.assertEquals((String)"Unexpected next relationship", (Object)expected, (Object)iterator.next());
    }

    private void deleteRelationshipsInSeparateThread(Relationship ... relationships) throws InterruptedException {
        this.executeTransactionInSeparateThread(() -> {
            for (Relationship relationship : relationships) {
                relationship.delete();
            }
        });
    }

    private void executeTransactionInSeparateThread(final Runnable actionInsideTransaction) throws InterruptedException {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try (Transaction tx = RelationshipChainPointerChasingTest.this.db.beginTx();){
                    actionInsideTransaction.run();
                    tx.success();
                }
            }
        };
        thread.start();
        thread.join();
    }
}

