/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.mockito.matcher.KernelExceptionUserMessageMatcher;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class SchemaStorageTest {
    private static final String LABEL1 = "Label1";
    private static final String LABEL2 = "Label2";
    private static final String TYPE1 = "Type1";
    private static final String PROP1 = "prop1";
    private static final String PROP2 = "prop2";
    @ClassRule
    public static final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static SchemaStorage storage;

    @BeforeClass
    public static void initStorage() throws Exception {
        try (Transaction transaction = db.beginTx();
             Statement statement = SchemaStorageTest.getStatement();){
            TokenWriteOperations tokenWriteOperations = statement.tokenWriteOperations();
            tokenWriteOperations.propertyKeyGetOrCreateForName(PROP1);
            tokenWriteOperations.propertyKeyGetOrCreateForName(PROP2);
            tokenWriteOperations.labelGetOrCreateForName(LABEL1);
            tokenWriteOperations.labelGetOrCreateForName(LABEL2);
            tokenWriteOperations.relationshipTypeGetOrCreateForName(TYPE1);
            transaction.success();
        }
        SchemaStore schemaStore = SchemaStorageTest.resolveDependency(RecordStorageEngine.class).testAccessNeoStores().getSchemaStore();
        storage = new SchemaStorage((RecordStore)schemaStore);
    }

    @Before
    public void clearSchema() {
        GraphDatabaseServiceCleaner.cleanupSchema((GraphDatabaseService)db);
    }

    @Test
    public void shouldReturnIndexRuleForLabelAndProperty() {
        SchemaStorageTest.createSchema(SchemaStorageTest.index(LABEL1, PROP1), SchemaStorageTest.index(LABEL1, PROP2), SchemaStorageTest.index(LABEL2, PROP1));
        IndexRule rule = storage.indexGetForSchema(this.indexDescriptor(LABEL1, PROP2));
        Assert.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP2, IndexDescriptor.Type.GENERAL);
    }

    @Test
    public void shouldReturnIndexRuleForLabelAndPropertyComposite() throws Exception {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String f = "f";
        SchemaStorageTest.createSchema(db -> db.schema().indexFor(Label.label((String)LABEL1)).on(a).on(b).on(c).on(d).on(e).on(f).create());
        IndexRule rule = storage.indexGetForSchema(IndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(a), this.propId(b), this.propId(c), this.propId(d), this.propId(e), this.propId(f)}));
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptor.Supplier)rule, (int)SchemaStorageTest.labelId(LABEL1)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(a)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(b)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(c)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(d)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(e)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(f)));
        Assert.assertEquals((Object)IndexDescriptor.Type.GENERAL, (Object)rule.getIndexDescriptor().type());
    }

    @Test
    public void shouldReturnIndexRuleForLabelAndVeryManyPropertiesComposite() throws Exception {
        String[] props = "abcdefghijklmnopqrstuvwxyzABCDEFGHJILKMNOPQRSTUVWXYZ".split("\\B");
        SchemaStorageTest.createSchema(db -> {
            IndexCreator indexCreator = db.schema().indexFor(Label.label((String)LABEL1));
            for (String prop : props) {
                indexCreator = indexCreator.on(prop);
            }
            indexCreator.create();
        });
        IndexRule rule = storage.indexGetForSchema(IndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])Arrays.stream(props).mapToInt(this::propId).toArray()));
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptor.Supplier)rule, (int)SchemaStorageTest.labelId(LABEL1)));
        for (String prop : props) {
            Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(prop)));
        }
        Assert.assertEquals((Object)IndexDescriptor.Type.GENERAL, (Object)rule.getIndexDescriptor().type());
    }

    @Test
    public void shouldReturnNullIfIndexRuleForLabelAndPropertyDoesNotExist() {
        SchemaStorageTest.createSchema(SchemaStorageTest.index(LABEL1, PROP1));
        IndexRule rule = storage.indexGetForSchema(this.indexDescriptor(LABEL1, PROP2));
        Assert.assertNull((Object)rule);
    }

    @Test
    public void shouldListIndexRulesForLabelPropertyAndKind() {
        SchemaStorageTest.createSchema(SchemaStorageTest.uniquenessConstraint(LABEL1, PROP1), SchemaStorageTest.index(LABEL1, PROP2));
        IndexRule rule = storage.indexGetForSchema(this.uniqueIndexDescriptor(LABEL1, PROP1));
        Assert.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, IndexDescriptor.Type.UNIQUE);
    }

    @Test
    public void shouldListAllIndexRules() {
        SchemaStorageTest.createSchema(SchemaStorageTest.index(LABEL1, PROP1), SchemaStorageTest.index(LABEL1, PROP2), SchemaStorageTest.uniquenessConstraint(LABEL2, PROP1));
        Set listedRules = Iterators.asSet((Iterator)storage.indexesGetAll());
        HashSet<IndexRule> expectedRules = new HashSet<IndexRule>();
        expectedRules.add(this.makeIndexRule(0L, LABEL1, PROP1));
        expectedRules.add(this.makeIndexRule(1L, LABEL1, PROP2));
        expectedRules.add(this.makeIndexRuleForConstraint(2L, LABEL2, PROP1, 0L));
        Assert.assertEquals(expectedRules, (Object)listedRules);
    }

    @Test
    public void shouldReturnCorrectUniquenessRuleForLabelAndProperty() throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        SchemaStorageTest.createSchema(SchemaStorageTest.uniquenessConstraint(LABEL1, PROP1), SchemaStorageTest.uniquenessConstraint(LABEL2, PROP1));
        ConstraintRule rule = storage.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
        Assert.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, ConstraintDescriptor.Type.UNIQUE);
    }

    @Test
    public void shouldThrowExceptionOnNodeRuleNotFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(SchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "No node property existence constraint was found for :Label1(prop1)."));
        storage.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
    }

    @Test
    public void shouldThrowExceptionOnNodeDuplicateRuleFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        SchemaStorage schemaStorageSpy = (SchemaStorage)Mockito.spy((Object)storage);
        Mockito.when((Object)schemaStorageSpy.loadAllSchemaRules((Predicate)Matchers.any(), (Class)Matchers.any(), Matchers.anyBoolean())).thenReturn((Object)Iterators.iterator((Object[])new SchemaRule[]{this.getUniquePropertyConstraintRule(1L, LABEL1, PROP1), this.getUniquePropertyConstraintRule(2L, LABEL1, PROP1)}));
        this.expectedException.expect(DuplicateSchemaRuleException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Multiple uniqueness constraints found for :Label1(prop1)."));
        schemaStorageSpy.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
    }

    @Test
    public void shouldThrowExceptionOnRelationshipRuleNotFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(SchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "No relationship property existence constraint was found for -[:Type1(prop1)]-."));
        storage.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)SchemaStorageTest.typeId(TYPE1), (int[])new int[]{this.propId(PROP1)}));
    }

    @Test
    public void shouldThrowExceptionOnRelationshipDuplicateRuleFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        SchemaStorage schemaStorageSpy = (SchemaStorage)Mockito.spy((Object)storage);
        Mockito.when((Object)schemaStorageSpy.loadAllSchemaRules((Predicate)Matchers.any(), (Class)Matchers.any(), Matchers.anyBoolean())).thenReturn((Object)Iterators.iterator((Object[])new SchemaRule[]{this.getRelationshipPropertyExistenceConstraintRule(1L, TYPE1, PROP1), this.getRelationshipPropertyExistenceConstraintRule(2L, TYPE1, PROP1)}));
        this.expectedException.expect(DuplicateSchemaRuleException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Multiple relationship property existence constraints found for -[:Type1(prop1)]-."));
        schemaStorageSpy.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)SchemaStorageTest.typeId(TYPE1), (int[])new int[]{this.propId(PROP1)}));
    }

    private TokenNameLookup getDefaultTokenNameLookup() {
        TokenNameLookup tokenNameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        Mockito.when((Object)tokenNameLookup.labelGetName(SchemaStorageTest.labelId(LABEL1))).thenReturn((Object)LABEL1);
        Mockito.when((Object)tokenNameLookup.propertyKeyGetName(this.propId(PROP1))).thenReturn((Object)PROP1);
        Mockito.when((Object)tokenNameLookup.relationshipTypeGetName(SchemaStorageTest.typeId(TYPE1))).thenReturn((Object)TYPE1);
        return tokenNameLookup;
    }

    private void assertRule(IndexRule rule, String label, String propertyKey, IndexDescriptor.Type type) {
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptor.Supplier)rule, (int)SchemaStorageTest.labelId(label)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(propertyKey)));
        Assert.assertEquals((Object)type, (Object)rule.getIndexDescriptor().type());
    }

    private void assertRule(ConstraintRule rule, String label, String propertyKey, ConstraintDescriptor.Type type) {
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptor.Supplier)rule, (int)SchemaStorageTest.labelId(label)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptor.Supplier)rule, (int)this.propId(propertyKey)));
        Assert.assertEquals((Object)type, (Object)rule.getConstraintDescriptor().type());
    }

    private IndexDescriptor indexDescriptor(String label, String property) {
        return IndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private IndexDescriptor uniqueIndexDescriptor(String label, String property) {
        return IndexDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private IndexRule makeIndexRule(long ruleId, String label, String propertyKey) {
        return IndexRule.indexRule((long)ruleId, (IndexDescriptor)IndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(propertyKey)}), (SchemaIndexProvider.Descriptor)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR);
    }

    private IndexRule makeIndexRuleForConstraint(long ruleId, String label, String propertyKey, long constraintId) {
        return IndexRule.constraintIndexRule((long)ruleId, (IndexDescriptor)IndexDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(propertyKey)}), (SchemaIndexProvider.Descriptor)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR, (Long)constraintId);
    }

    private ConstraintRule getUniquePropertyConstraintRule(long id, String label, String property) {
        return ConstraintRule.constraintRule((long)id, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(property)}), (long)0L);
    }

    private ConstraintRule getRelationshipPropertyExistenceConstraintRule(long id, String type, String property) {
        return ConstraintRule.constraintRule((long)id, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)SchemaStorageTest.typeId(type), (int[])new int[]{this.propId(property)}));
    }

    /*
     * Exception decompiling
     */
    private static int labelId(String labelName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int propId(String propName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static int typeId(String typeName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Statement getStatement() {
        return SchemaStorageTest.resolveDependency(ThreadToStatementContextBridge.class).get();
    }

    private static <T> T resolveDependency(Class<T> clazz) {
        return (T)db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(clazz);
    }

    private static Consumer<GraphDatabaseService> index(String label, String prop) {
        return db -> db.schema().indexFor(Label.label((String)label)).on(prop).create();
    }

    private static Consumer<GraphDatabaseService> uniquenessConstraint(String label, String prop) {
        return db -> db.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(prop).create();
    }

    @SafeVarargs
    private static void createSchema(Consumer<GraphDatabaseService> ... creators) {
        try (Transaction tx = db.beginTx();){
            for (Consumer<GraphDatabaseService> rule : creators) {
                rule.accept((GraphDatabaseService)db);
            }
            tx.success();
        }
        SchemaStorageTest.awaitIndexes();
    }

    private static void awaitIndexes() {
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
    }
}

