/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.values.storable.Values;

public class TestShortArray {
    private static final int DEFAULT_PAYLOAD_SIZE = PropertyType.getPayloadSize();

    @Test
    public void canEncodeSomeSampleArraysWithDefaultPayloadSize() throws Exception {
        this.assertCanEncodeAndDecodeToSameValue(new boolean[]{true, false, true, true, true, true, true, true, true, true, false, true});
        this.assertCanEncodeAndDecodeToSameValue(new byte[]{-1, -10, 43, 127, 0, 4, 2, 3, 56, 47, 67, 43});
        this.assertCanEncodeAndDecodeToSameValue(new short[]{1, 2, 3, 45, 5, 6, 7});
        this.assertCanEncodeAndDecodeToSameValue(new int[]{1, 2, 3, 4, 5, 6, 7});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L});
        this.assertCanEncodeAndDecodeToSameValue(new float[]{0.34f, 0.21f});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE});
        this.assertCanEncodeAndDecodeToSameValue(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L});
    }

    @Test
    public void testCannotEncodeMarginal() throws Exception {
        this.assertCanNotEncode(new long[]{32768L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
    }

    @Test
    public void canEncodeBiggerArraysWithBiggerPayloadSize() throws Exception {
        int[] intArray = this.intArray(10, 2600);
        this.assertCanEncodeAndDecodeToSameValue(intArray, 32);
    }

    private void assertCanNotEncode(Object intArray) {
        this.assertCanNotEncode(intArray, DEFAULT_PAYLOAD_SIZE);
    }

    private void assertCanNotEncode(Object intArray, int payloadSize) {
        Assert.assertFalse((boolean)ShortArray.encode((int)0, (Object)intArray, (PropertyBlock)new PropertyBlock(), (int)payloadSize));
    }

    private int[] intArray(int count, int stride) {
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = i * stride;
        }
        return result;
    }

    private void assertCanEncodeAndDecodeToSameValue(Object value) {
        this.assertCanEncodeAndDecodeToSameValue(value, PropertyType.getPayloadSize());
    }

    private void assertCanEncodeAndDecodeToSameValue(Object value, int payloadSize) {
        PropertyBlock target = new PropertyBlock();
        boolean encoded = ShortArray.encode((int)0, (Object)value, (PropertyBlock)target, (int)payloadSize);
        Assert.assertTrue((boolean)encoded);
        Assert.assertEquals((Object)Values.of((Object)value), (Object)ShortArray.decode((PropertyBlock)target));
    }
}

