/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StandaloneDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.format.RecordGenerators;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.test.Randoms;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LimitedRecordGenerators
implements RecordGenerators {
    static final long NULL = -1L;
    private final Randoms random;
    private final int entityBits;
    private final int propertyBits;
    private final int nodeLabelBits;
    private final int tokenBits;
    private final long nullValue;
    private final float fractionNullValues;

    public LimitedRecordGenerators(Randoms random, int entityBits, int propertyBits, int nodeLabelBits, int tokenBits, long nullValue) {
        this(random, entityBits, propertyBits, nodeLabelBits, tokenBits, nullValue, 0.2f);
    }

    public LimitedRecordGenerators(Randoms random, int entityBits, int propertyBits, int nodeLabelBits, int tokenBits, long nullValue, float fractionNullValues) {
        this.random = random;
        this.entityBits = entityBits;
        this.propertyBits = propertyBits;
        this.nodeLabelBits = nodeLabelBits;
        this.tokenBits = tokenBits;
        this.nullValue = nullValue;
        this.fractionNullValues = fractionNullValues;
    }

    @Override
    public RecordGenerators.Generator<RelationshipTypeTokenRecord> relationshipTypeToken() {
        return (recordSize, format, recordId) -> new RelationshipTypeTokenRecord(Math.toIntExact(recordId)).initialize(this.random.nextBoolean(), this.randomInt(this.tokenBits));
    }

    @Override
    public RecordGenerators.Generator<RelationshipGroupRecord> relationshipGroup() {
        return (recordSize, format, recordId) -> new RelationshipGroupRecord(recordId).initialize(this.random.nextBoolean(), this.randomInt(this.tokenBits), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.entityBits));
    }

    @Override
    public RecordGenerators.Generator<RelationshipRecord> relationship() {
        return (recordSize, format, recordId) -> new RelationshipRecord(recordId).initialize(this.random.nextBoolean(), this.randomLongOrOccasionallyNull(this.propertyBits), this.random.nextLong((long)this.entityBits), this.random.nextLong((long)this.entityBits), this.randomInt(this.tokenBits), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.entityBits), this.random.nextBoolean(), this.random.nextBoolean());
    }

    @Override
    public RecordGenerators.Generator<PropertyKeyTokenRecord> propertyKeyToken() {
        return (recordSize, format, recordId) -> new PropertyKeyTokenRecord(Math.toIntExact(recordId)).initialize(this.random.nextBoolean(), this.random.nextInt(this.tokenBits), Math.abs(this.random.nextInt()));
    }

    @Override
    public RecordGenerators.Generator<PropertyRecord> property() {
        return (recordSize, format, recordId) -> {
            PropertyRecord record = new PropertyRecord(recordId);
            int maxProperties = this.random.intBetween(1, 4);
            StandaloneDynamicRecordAllocator stringAllocator = new StandaloneDynamicRecordAllocator();
            StandaloneDynamicRecordAllocator arrayAllocator = new StandaloneDynamicRecordAllocator();
            record.setInUse(true);
            int blocksOccupied = 0;
            int i = 0;
            while (i < maxProperties && blocksOccupied < 4) {
                PropertyBlock block = new PropertyBlock();
                PropertyStore.encodeValue((PropertyBlock)block, (int)this.random.nextInt(this.tokenBits), (Value)Values.of((Object)this.random.propertyValue()), (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator);
                int tentativeBlocksWithThisOne = blocksOccupied + block.getValueBlocks().length;
                if (tentativeBlocksWithThisOne > 4) continue;
                record.addPropertyBlock(block);
                blocksOccupied = tentativeBlocksWithThisOne;
            }
            record.setPrevProp(this.randomLongOrOccasionallyNull(this.propertyBits));
            record.setNextProp(this.randomLongOrOccasionallyNull(this.propertyBits));
            return record;
        };
    }

    @Override
    public RecordGenerators.Generator<NodeRecord> node() {
        return (recordSize, format, recordId) -> new NodeRecord(recordId).initialize(this.random.nextBoolean(), this.randomLongOrOccasionallyNull(this.propertyBits), this.random.nextBoolean(), this.randomLongOrOccasionallyNull(this.entityBits), this.randomLongOrOccasionallyNull(this.nodeLabelBits, 0L));
    }

    @Override
    public RecordGenerators.Generator<LabelTokenRecord> labelToken() {
        return (recordSize, format, recordId) -> new LabelTokenRecord(Math.toIntExact(recordId)).initialize(this.random.nextBoolean(), this.random.nextInt(this.tokenBits));
    }

    @Override
    public RecordGenerators.Generator<DynamicRecord> dynamic() {
        return (recordSize, format, recordId) -> {
            int dataSize = recordSize - format.getRecordHeaderSize();
            int length = this.random.nextBoolean() ? dataSize : this.random.nextInt(dataSize);
            long next = length == dataSize ? this.randomLong(this.propertyBits) : this.nullValue;
            DynamicRecord record = new DynamicRecord(Long.max(1L, recordId)).initialize(this.random.nextBoolean(), this.random.nextBoolean(), next, this.random.nextInt(PropertyType.values().length), length);
            byte[] data = new byte[record.getLength()];
            this.random.nextBytes(data);
            record.setData(data);
            return record;
        };
    }

    private int randomInt(int maxBits) {
        int bits = this.random.nextInt(maxBits + 1);
        int max = 1 << bits;
        return this.random.nextInt(max);
    }

    private long randomLong(int maxBits) {
        int bits = this.random.nextInt(maxBits + 1);
        long max = 1L << bits;
        return this.random.nextLong(max);
    }

    private long randomLongOrOccasionallyNull(int maxBits) {
        return this.randomLongOrOccasionallyNull(maxBits, -1L);
    }

    private long randomLongOrOccasionallyNull(int maxBits, long nullValue) {
        return this.random.nextFloat() < this.fractionNullValues ? nullValue : this.randomLong(maxBits);
    }
}

