/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdRangeIterator;

public class IdRangeIteratorTest {
    @Test
    public void shouldReturnValueRepresentingNullIfWeExhaustIdRange() throws Exception {
        int rangeLength = 1024;
        IdRangeIterator iterator = new IdRange(new long[0], 0L, rangeLength).iterator();
        for (int i = 0; i < rangeLength; ++i) {
            iterator.nextId();
        }
        Assert.assertEquals((long)-1L, (long)iterator.nextId());
    }

    @Test
    public void shouldNotHaveAnyGaps() throws Exception {
        int rangeLength = 1024;
        IdRangeIterator iterator = new IdRange(new long[0], 0L, rangeLength).iterator();
        HashSet<Long> seenIds = new HashSet<Long>();
        for (int i = 0; i < rangeLength; ++i) {
            seenIds.add(iterator.nextId());
            if (i <= 0) continue;
            Assert.assertTrue((String)("Missing id " + (i - 1)), (boolean)seenIds.contains((long)i - 1L));
        }
    }

    @Test
    public void shouldUseDefragIdsFirst() throws Exception {
        int rangeLength = 1024;
        IdRangeIterator iterator = new IdRange(new long[]{7L, 8L, 9L}, 1024L, rangeLength).iterator();
        Assert.assertEquals((long)7L, (long)iterator.nextId());
        Assert.assertEquals((long)8L, (long)iterator.nextId());
        Assert.assertEquals((long)9L, (long)iterator.nextId());
        Assert.assertEquals((long)1024L, (long)iterator.nextId());
    }

    @Test
    public void shouldGetNextIdBatchFromOnlyDefragIds() throws Exception {
        IdRangeIterator iterator = new IdRange(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, 7L, 0).iterator();
        IdRangeIterator subRange = iterator.nextIdBatch(5).iterator();
        Assert.assertEquals((long)6L, (long)iterator.nextId());
        for (long i = 0L; i < 5L; ++i) {
            Assert.assertEquals((long)(1L + i), (long)subRange.nextId());
        }
        Assert.assertEquals((long)-1L, (long)subRange.nextId());
    }

    @Test
    public void shouldGetNextIdBatchFromOnlyDefragIdsWhenSomeDefragIdsHaveAlreadyBeenReturned() throws Exception {
        IdRangeIterator iterator = new IdRange(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, 7L, 0).iterator();
        iterator.nextId();
        iterator.nextId();
        IdRangeIterator subRange = iterator.nextIdBatch(3).iterator();
        Assert.assertEquals((long)6L, (long)iterator.nextId());
        for (long i = 0L; i < 3L; ++i) {
            Assert.assertEquals((long)(3L + i), (long)subRange.nextId());
        }
        Assert.assertEquals((long)-1L, (long)subRange.nextId());
    }

    @Test
    public void shouldGetNextIdBatchFromSomeDefragAndSomeRangeIds() throws Exception {
        IdRangeIterator iterator = new IdRange(new long[]{1L, 2L, 3L}, 10L, 5).iterator();
        iterator.nextId();
        IdRangeIterator subRange = iterator.nextIdBatch(5).iterator();
        Assert.assertEquals((long)13L, (long)iterator.nextId());
        Assert.assertEquals((long)2L, (long)subRange.nextId());
        Assert.assertEquals((long)3L, (long)subRange.nextId());
        Assert.assertEquals((long)10L, (long)subRange.nextId());
        Assert.assertEquals((long)11L, (long)subRange.nextId());
        Assert.assertEquals((long)12L, (long)subRange.nextId());
        Assert.assertEquals((long)-1L, (long)subRange.nextId());
    }

    @Test
    public void shouldGetNextIdBatchFromSomeRangeIds() throws Exception {
        IdRangeIterator iterator = new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 0L, 20).iterator();
        iterator.nextId();
        IdRangeIterator subRange = iterator.nextIdBatch(5).iterator();
        Assert.assertEquals((long)6L, (long)iterator.nextId());
        Assert.assertEquals((long)1L, (long)subRange.nextId());
        Assert.assertEquals((long)2L, (long)subRange.nextId());
        Assert.assertEquals((long)3L, (long)subRange.nextId());
        Assert.assertEquals((long)4L, (long)subRange.nextId());
        Assert.assertEquals((long)5L, (long)subRange.nextId());
        Assert.assertEquals((long)-1L, (long)subRange.nextId());
        subRange = iterator.nextIdBatch(2).iterator();
        Assert.assertEquals((long)9L, (long)iterator.nextId());
        Assert.assertEquals((long)7L, (long)subRange.nextId());
        Assert.assertEquals((long)8L, (long)subRange.nextId());
        Assert.assertEquals((long)-1L, (long)subRange.nextId());
    }

    @Test
    public void shouldGetNextIdBatchFromSomeRangeIdsWhenThereAreUsedDefragIds() throws Exception {
        IdRangeIterator iterator = new IdRange(new long[]{0L, 1L, 2L}, 3L, 10).iterator();
        iterator.nextId();
        iterator.nextId();
        iterator.nextId();
        IdRangeIterator subRange = iterator.nextIdBatch(3).iterator();
        Assert.assertEquals((long)6L, (long)iterator.nextId());
        Assert.assertEquals((long)3L, (long)subRange.nextId());
        Assert.assertEquals((long)4L, (long)subRange.nextId());
        Assert.assertEquals((long)5L, (long)subRange.nextId());
        Assert.assertEquals((long)-1L, (long)subRange.nextId());
        subRange = iterator.nextIdBatch(3).iterator();
        Assert.assertEquals((long)10L, (long)iterator.nextId());
        Assert.assertEquals((long)7L, (long)subRange.nextId());
        Assert.assertEquals((long)8L, (long)subRange.nextId());
        Assert.assertEquals((long)9L, (long)subRange.nextId());
        Assert.assertEquals((long)-1L, (long)subRange.nextId());
    }
}

