/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.concurrent.Runnables;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.store.kvstore.ConcurrentMapState;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;
import org.neo4j.kernel.impl.store.kvstore.ValueSink;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public class ConcurrentMapStateTest {
    private final ReadableState<String> store = (ReadableState)Mockito.mock(ReadableState.class);
    private final File file = (File)Mockito.mock(File.class);
    private final Lock lock = (Lock)Mockito.mock(Lock.class);

    @Before
    public void setUp() throws Exception {
        KeyFormat keyFormat = (KeyFormat)Mockito.mock(KeyFormat.class);
        Mockito.when((Object)keyFormat.valueSize()).thenReturn((Object)8);
        Mockito.when((Object)this.store.keyFormat()).thenReturn((Object)keyFormat);
    }

    @Test
    public void shouldCreateAnUpdaterForTheNextUnseenVersionUpdate() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState<String> state = this.createMapState();
        long updateVersion = 43L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)updateVersion, (long)state.version());
    }

    @Test
    public void shouldCreateAnUpdaterForAnUnseenVersionUpdateWithAGap() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState<String> state = this.createMapState();
        long updateVersion = 45L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        updater.close();
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)updateVersion, (long)state.version());
    }

    @Test
    public void shouldCreateAnUpdaterForMultipleVersionUpdatesInOrder() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState<String> state = this.createMapState();
        long updateVersion = 43L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 44L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 45L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)updateVersion, (long)state.version());
    }

    @Test
    public void shouldCreateAnUpdaterForMultipleVersionUpdatesNotInOrder() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState<String> state = this.createMapState();
        long updateVersion = 45L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 43L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 44L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)45L, (long)state.version());
    }

    @Test
    public void shouldUseEmptyUpdaterOnVersionLowerOrEqualToTheInitialVersion() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState<String> state = this.createMapState();
        EntryUpdater updater = state.updater(initialVersion, this.lock);
        Assert.assertEquals((String)"Empty updater should be used for version less or equal to initial", (Object)EntryUpdater.noUpdates(), (Object)updater);
    }

    @Test
    public void markDirtyVersionLookupOnKeyUpdate() throws IOException {
        long updaterVersionTxId = 25L;
        long lastClosedTxId = 20L;
        TransactionVersionContextSupplier versionContextSupplier = new TransactionVersionContextSupplier();
        versionContextSupplier.init(() -> lastClosedTxId);
        ConcurrentMapState<String> mapState = this.createMapState((VersionContextSupplier)versionContextSupplier);
        VersionContext versionContext = versionContextSupplier.getVersionContext();
        try (EntryUpdater updater = mapState.updater(updaterVersionTxId, this.lock);){
            updater.apply((Object)"a", (ValueUpdate)new SimpleValueUpdate(1L));
            updater.apply((Object)"b", (ValueUpdate)new SimpleValueUpdate(2L));
        }
        Assert.assertEquals((long)updaterVersionTxId, (long)mapState.version());
        versionContext.initRead();
        mapState.lookup((Object)"a", (ValueSink)new EmptyValueSink());
        Assert.assertTrue((boolean)versionContext.isDirty());
    }

    @Test
    public void markDirtyVersionLookupOnKeyReset() throws IOException {
        long updaterVersionTxId = 25L;
        long lastClosedTxId = 20L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)updaterVersionTxId);
        TransactionVersionContextSupplier versionContextSupplier = new TransactionVersionContextSupplier();
        versionContextSupplier.init(() -> lastClosedTxId);
        VersionContext versionContext = versionContextSupplier.getVersionContext();
        ConcurrentMapState<String> mapState = this.createMapState((VersionContextSupplier)versionContextSupplier);
        versionContext.initRead();
        mapState.resettingUpdater(this.lock, Runnables.EMPTY_RUNNABLE).apply((Object)"a", (ValueUpdate)new SimpleValueUpdate(1L));
        mapState.lookup((Object)"a", (ValueSink)new EmptyValueSink());
        Assert.assertTrue((boolean)versionContext.isDirty());
    }

    @Test
    public void doNotMarkVersionAsDirtyOnAnotherKeyUpdate() throws IOException {
        long updaterVersionTxId = 25L;
        long lastClosedTxId = 20L;
        TransactionVersionContextSupplier versionContextSupplier = new TransactionVersionContextSupplier();
        versionContextSupplier.init(() -> lastClosedTxId);
        ConcurrentMapState<String> mapState = this.createMapState((VersionContextSupplier)versionContextSupplier);
        VersionContext versionContext = versionContextSupplier.getVersionContext();
        try (EntryUpdater updater = mapState.updater(updaterVersionTxId, this.lock);){
            updater.apply((Object)"b", (ValueUpdate)new SimpleValueUpdate(2L));
        }
        Assert.assertEquals((long)updaterVersionTxId, (long)mapState.version());
        versionContext.initRead();
        mapState.lookup((Object)"a", (ValueSink)new EmptyValueSink());
        Assert.assertFalse((boolean)versionContext.isDirty());
    }

    private ConcurrentMapState<String> createMapState() {
        return this.createMapState(EmptyVersionContextSupplier.EMPTY);
    }

    private ConcurrentMapState<String> createMapState(VersionContextSupplier versionContextSupplier) {
        return new ConcurrentMapState(this.store, this.file, versionContextSupplier);
    }

    private static class EmptyValueSink
    extends ValueSink {
        private EmptyValueSink() {
        }

        protected void value(ReadableBuffer value) {
        }
    }

    private static class SimpleValueUpdate
    implements ValueUpdate {
        private final long value;

        SimpleValueUpdate(long value) {
            this.value = value;
        }

        public void update(WritableBuffer target) {
            target.putLong(0, this.value);
        }
    }
}

