/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.legacystore.v23.Legacy23Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v30.Legacy30Store;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailScanner;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.string.UTF8;
import org.neo4j.test.Unzip;

public class MigrationTestUtils {
    private MigrationTestUtils() {
    }

    public static int[] makeLongArray() {
        int[] longArray = new int[100];
        for (int i = 0; i < 100; ++i) {
            longArray[i] = i;
        }
        return longArray;
    }

    public static String makeLongString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("characters");
        }
        return builder.toString();
    }

    static void changeVersionNumber(FileSystemAbstraction fileSystem, File storeFile, String versionString) throws IOException {
        byte[] versionBytes = UTF8.encode((String)versionString);
        try (StoreChannel fileChannel = fileSystem.open(storeFile, "rw");){
            fileChannel.position(fileSystem.getFileSize(storeFile) - (long)versionBytes.length);
            fileChannel.write(ByteBuffer.wrap(versionBytes));
        }
    }

    public static void prepareSampleLegacyDatabase(String version, EphemeralFileSystemAbstraction workingFs, File workingDirectory, File realDirForPreparingDatabase) throws IOException {
        try (DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();){
            File resourceDirectory = MigrationTestUtils.findFormatStoreDirectoryForVersion(version, realDirForPreparingDatabase);
            workingFs.copyRecursivelyFromOtherFs(resourceDirectory, (FileSystemAbstraction)fileSystemAbstraction, workingDirectory);
        }
    }

    public static void prepareSampleLegacyDatabase(String version, FileSystemAbstraction workingFs, File workingDirectory, File prepareDirectory) throws IOException {
        if (!prepareDirectory.exists()) {
            throw new IllegalArgumentException("bad prepare directory");
        }
        File resourceDirectory = MigrationTestUtils.findFormatStoreDirectoryForVersion(version, prepareDirectory);
        workingFs.deleteRecursively(workingDirectory);
        workingFs.mkdirs(workingDirectory);
        workingFs.copyRecursively(resourceDirectory, workingDirectory);
    }

    static File findFormatStoreDirectoryForVersion(String version, File targetDir) throws IOException {
        if (StandardV2_3.STORE_VERSION.equals(version)) {
            return MigrationTestUtils.find23FormatStoreDirectory(targetDir);
        }
        if (StandardV3_0.STORE_VERSION.equals(version)) {
            return MigrationTestUtils.find30FormatStoreDirectory(targetDir);
        }
        throw new IllegalArgumentException("Unknown version");
    }

    private static File find30FormatStoreDirectory(File targetDir) throws IOException {
        return Unzip.unzip(Legacy30Store.class, "upgradeTest30Db.zip", targetDir);
    }

    public static File find23FormatStoreDirectory(File targetDir) throws IOException {
        return Unzip.unzip(Legacy23Store.class, "upgradeTest23Db.zip", targetDir);
    }

    public static boolean checkNeoStoreHasDefaultFormatVersion(StoreVersionCheck check, File workingDirectory) {
        File neostoreFile = new File(workingDirectory, "neostore");
        return check.hasVersion((File)neostoreFile, (String)RecordFormatSelector.defaultFormat().storeVersion()).outcome.isSuccessful();
    }

    public static void verifyFilesHaveSameContent(FileSystemAbstraction fileSystem, File original, File other) throws IOException {
        File[] files;
        int bufferBatchSize = 32768;
        block18: for (File originalFile : files = fileSystem.listFiles(original)) {
            File otherFile = new File(other, originalFile.getName());
            if (fileSystem.isDirectory(originalFile)) continue;
            try (StoreChannel originalChannel = fileSystem.open(originalFile, "r");
                 StoreChannel otherChannel = fileSystem.open(otherFile, "r");){
                ByteBuffer buffer = ByteBuffer.allocate(32768);
                while (true) {
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)originalChannel, (ByteBuffer)buffer, (int)32768)) {
                        continue block18;
                    }
                    byte[] originalBytes = new byte[buffer.limit()];
                    buffer.get(originalBytes);
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)otherChannel, (ByteBuffer)buffer, (int)32768)) {
                        Assert.fail((String)"Files have different sizes");
                    }
                    byte[] otherBytes = new byte[buffer.limit()];
                    buffer.get(otherBytes);
                    Assert.assertArrayEquals((String)("Different content in " + originalFile), (byte[])originalBytes, (byte[])otherBytes);
                }
            }
        }
    }

    public static void removeCheckPointFromTxLog(FileSystemAbstraction fileSystem, File workingDirectory) throws IOException {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(workingDirectory, fileSystem);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, fileSystem, (LogEntryReader)logEntryReader);
        LogTailScanner.LogTailInformation logTailInformation = tailScanner.getTailInformation();
        if (logTailInformation.commitsAfterLastCheckPoint) {
            return;
        }
        Assert.assertNotNull((Object)logTailInformation.lastCheckPoint);
        LogPosition logPosition = logTailInformation.lastCheckPoint.getLogPosition();
        File logFile = logFiles.getLogFileForVersion(logPosition.getLogVersion());
        fileSystem.truncate(logFile, logPosition.getByteOffset());
    }
}

