/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Commands {
    private Commands() {
    }

    public static Command.NodeCommand createNode(long id, long ... dynamicLabelRecordIds) {
        NodeRecord record = new NodeRecord(id);
        record.setInUse(true);
        record.setCreated();
        if (dynamicLabelRecordIds.length > 0) {
            List<DynamicRecord> dynamicRecords = Commands.dynamicRecords(dynamicLabelRecordIds);
            record.setLabelField(DynamicNodeLabels.dynamicPointer(dynamicRecords), dynamicRecords);
        }
        return new Command.NodeCommand(new NodeRecord(id), record);
    }

    private static List<DynamicRecord> dynamicRecords(long ... dynamicLabelRecordIds) {
        ArrayList<DynamicRecord> dynamicRecords = new ArrayList<DynamicRecord>();
        for (long did : dynamicLabelRecordIds) {
            DynamicRecord dynamicRecord = new DynamicRecord(did);
            dynamicRecord.setInUse(true);
            dynamicRecords.add(dynamicRecord);
        }
        return dynamicRecords;
    }

    public static Command.RelationshipCommand createRelationship(long id, long startNode, long endNode, int type) {
        RelationshipRecord before = new RelationshipRecord(id);
        before.setInUse(false);
        RelationshipRecord after = new RelationshipRecord(id, startNode, endNode, type);
        after.setInUse(true);
        after.setCreated();
        return new Command.RelationshipCommand(before, after);
    }

    public static Command.LabelTokenCommand createLabelToken(int id, int nameId) {
        LabelTokenRecord before = new LabelTokenRecord(id);
        LabelTokenRecord after = new LabelTokenRecord(id);
        Commands.populateTokenRecord((TokenRecord)after, nameId);
        return new Command.LabelTokenCommand(before, after);
    }

    private static void populateTokenRecord(TokenRecord record, int nameId) {
        record.setInUse(true);
        record.setNameId(nameId);
        record.setCreated();
        DynamicRecord dynamicRecord = new DynamicRecord((long)nameId);
        dynamicRecord.setInUse(true);
        dynamicRecord.setData(new byte[10]);
        dynamicRecord.setCreated();
        record.addNameRecord(dynamicRecord);
    }

    public static Command.PropertyKeyTokenCommand createPropertyKeyToken(int id, int nameId) {
        PropertyKeyTokenRecord before = new PropertyKeyTokenRecord(id);
        PropertyKeyTokenRecord after = new PropertyKeyTokenRecord(id);
        Commands.populateTokenRecord((TokenRecord)after, nameId);
        return new Command.PropertyKeyTokenCommand(before, after);
    }

    public static Command.RelationshipTypeTokenCommand createRelationshipTypeToken(int id, int nameId) {
        RelationshipTypeTokenRecord before = new RelationshipTypeTokenRecord(id);
        RelationshipTypeTokenRecord after = new RelationshipTypeTokenRecord(id);
        Commands.populateTokenRecord((TokenRecord)after, nameId);
        return new Command.RelationshipTypeTokenCommand(before, after);
    }

    public static Command.RelationshipGroupCommand createRelationshipGroup(long id, int type) {
        RelationshipGroupRecord before = new RelationshipGroupRecord(id);
        RelationshipGroupRecord after = new RelationshipGroupRecord(id, type);
        after.setInUse(true);
        after.setCreated();
        return new Command.RelationshipGroupCommand(before, after);
    }

    public static Command.SchemaRuleCommand createIndexRule(SchemaIndexProvider.Descriptor provider, long id, LabelSchemaDescriptor descriptor) {
        IndexRule rule = IndexRule.indexRule((long)id, (IndexDescriptor)IndexDescriptorFactory.forSchema((LabelSchemaDescriptor)descriptor), (SchemaIndexProvider.Descriptor)provider);
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(true);
        record.setCreated();
        record.setData(rule.serialize());
        return new Command.SchemaRuleCommand(Collections.emptyList(), Collections.singletonList(record), (SchemaRule)rule);
    }

    public static Command.PropertyCommand createProperty(long id, PropertyType type, int key, long ... valueRecordIds) {
        PropertyRecord record = new PropertyRecord(id);
        record.setInUse(true);
        record.setCreated();
        PropertyBlock block = new PropertyBlock();
        if (valueRecordIds.length == 0) {
            PropertyStore.encodeValue((PropertyBlock)block, (int)key, (Value)Values.of((Object)123), null, null);
        } else {
            PropertyStore.setSingleBlockValue((PropertyBlock)block, (int)key, (PropertyType)type, (long)valueRecordIds[0]);
            block.setValueRecords(Commands.dynamicRecords(valueRecordIds));
        }
        record.addPropertyBlock(block);
        return new Command.PropertyCommand(new PropertyRecord(id), record);
    }

    public static TransactionRepresentation transactionRepresentation(Command ... commands) {
        return Commands.transactionRepresentation(Arrays.asList(commands));
    }

    public static TransactionRepresentation transactionRepresentation(Collection<StorageCommand> commands) {
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return tx;
    }
}

