/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.test.rule.CleanupRule;

public class BatchingTransactionAppenderTest {
    @Rule
    public final LifeRule life = new LifeRule(true);
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    private final InMemoryVersionableReadableClosablePositionAwareChannel channel = new InMemoryVersionableReadableClosablePositionAwareChannel();
    private final LogAppendEvent logAppendEvent = LogAppendEvent.NULL;
    private final DatabaseHealth databaseHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
    private final LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
    private final TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final TransactionMetadataCache positionCache = new TransactionMetadataCache(10);

    @Test
    public void shouldAppendSingleTransaction() throws Exception {
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)this.channel);
        long txId = 15L;
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        TransactionRepresentation transaction = this.transaction(this.singleCreateNodeCommand(0L), new byte[]{1, 2, 5}, 2, 1, 12345L, 4545L, 12355L);
        appender.append(new TransactionToApply(transaction), this.logAppendEvent);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try (PhysicalTransactionCursor reader = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)this.channel, (LogEntryReader)logEntryReader);){
            reader.next();
            TransactionRepresentation tx = reader.get().getTransactionRepresentation();
            Assert.assertArrayEquals((byte[])transaction.additionalHeader(), (byte[])tx.additionalHeader());
            Assert.assertEquals((long)transaction.getMasterId(), (long)tx.getMasterId());
            Assert.assertEquals((long)transaction.getAuthorId(), (long)tx.getAuthorId());
            Assert.assertEquals((long)transaction.getTimeStarted(), (long)tx.getTimeStarted());
            Assert.assertEquals((long)transaction.getTimeCommitted(), (long)tx.getTimeCommitted());
            Assert.assertEquals((long)transaction.getLatestCommittedTxWhenStarted(), (long)tx.getLatestCommittedTxWhenStarted());
        }
    }

    @Test
    public void shouldAppendBatchOfTransactions() throws Exception {
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)this.channel);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)2L, (Object[])new Long[]{3L, 4L});
        TransactionToApply batch = this.batchOf(this.transaction(this.singleCreateNodeCommand(0L), new byte[0], 0, 0, 0L, 1L, 0L), this.transaction(this.singleCreateNodeCommand(1L), new byte[0], 0, 0, 0L, 1L, 0L), this.transaction(this.singleCreateNodeCommand(2L), new byte[0], 0, 0, 0L, 1L, 0L));
        appender.append(batch, this.logAppendEvent);
        TransactionToApply tx = batch;
        Assert.assertEquals((long)2L, (long)tx.transactionId());
        tx = tx.next();
        Assert.assertEquals((long)3L, (long)tx.transactionId());
        tx = tx.next();
        Assert.assertEquals((long)4L, (long)tx.transactionId());
        Assert.assertNull((Object)tx.next());
    }

    @Test
    public void shouldAppendCommittedTransactions() throws Exception {
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)this.channel);
        long nextTxId = 15L;
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)nextTxId);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        int authorId = 1;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = nextTxId - 5L;
        long timeCommitted = 12355L;
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand(0L));
        transactionRepresentation.setHeader(additionalHeader, 2, authorId, 12345L, latestCommittedTxWhenStarted, timeCommitted, -1);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, latestCommittedTxWhenStarted, null, LogPosition.UNSPECIFIED);
        OnePhaseCommit commit = new OnePhaseCommit(nextTxId, 0L);
        CommittedTransactionRepresentation transaction = new CommittedTransactionRepresentation(start, (TransactionRepresentation)transactionRepresentation, (LogEntryCommit)commit);
        appender.append(new TransactionToApply((TransactionRepresentation)transactionRepresentation, transaction.getCommitEntry().getTxId()), this.logAppendEvent);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try (PhysicalTransactionCursor reader = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)this.channel, (LogEntryReader)logEntryReader);){
            reader.next();
            TransactionRepresentation result = reader.get().getTransactionRepresentation();
            Assert.assertArrayEquals((byte[])additionalHeader, (byte[])result.additionalHeader());
            Assert.assertEquals((long)2L, (long)result.getMasterId());
            Assert.assertEquals((long)authorId, (long)result.getAuthorId());
            Assert.assertEquals((long)12345L, (long)result.getTimeStarted());
            Assert.assertEquals((long)timeCommitted, (long)result.getTimeCommitted());
            Assert.assertEquals((long)latestCommittedTxWhenStarted, (long)result.getLatestCommittedTxWhenStarted());
        }
    }

    @Test
    public void shouldNotAppendCommittedTransactionsWhenTooFarAhead() throws Exception {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        int authorId = 1;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand(0L));
        transactionRepresentation.setHeader(additionalHeader, 2, authorId, 12345L, latestCommittedTxWhenStarted, timeCommitted, -1);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)latestCommittedTxWhenStarted);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, latestCommittedTxWhenStarted, null, LogPosition.UNSPECIFIED);
        OnePhaseCommit commit = new OnePhaseCommit(latestCommittedTxWhenStarted + 2L, 0L);
        CommittedTransactionRepresentation transaction = new CommittedTransactionRepresentation(start, (TransactionRepresentation)transactionRepresentation, (LogEntryCommit)commit);
        try {
            appender.append(new TransactionToApply(transaction.getTransactionRepresentation(), transaction.getCommitEntry().getTxId()), this.logAppendEvent);
            Assert.fail((String)"should have thrown");
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"to be applied, but appending it ended up generating an"));
        }
    }

    @Test
    public void shouldNotCallTransactionClosedOnFailedAppendedTransaction() throws Exception {
        long txId = 3L;
        String failureMessage = "Forces a failure";
        FlushablePositionAwareChannel channel = (FlushablePositionAwareChannel)Mockito.spy((Object)new InMemoryClosableChannel());
        IOException failure = new IOException(failureMessage);
        Mockito.when((Object)channel.putInt(Matchers.anyInt())).thenThrow(new Throwable[]{failure});
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        Mockito.reset((Object[])new DatabaseHealth[]{this.databaseHealth});
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        try {
            appender.append(new TransactionToApply(transaction), this.logAppendEvent);
            Assert.fail((String)"Expected append to fail. Something is wrong with the test itself");
        }
        catch (IOException e) {
            Assert.assertSame((Object)failure, (Object)e);
            ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.times((int)1))).nextCommittingTransactionId();
            ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.times((int)0))).transactionClosed(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.anyLong());
            ((DatabaseHealth)Mockito.verify((Object)this.databaseHealth)).panic((Throwable)failure);
        }
    }

    @Test
    public void shouldNotCallTransactionClosedOnFailedForceLogToDisk() throws Exception {
        long txId = 3L;
        String failureMessage = "Forces a failure";
        FlushablePositionAwareChannel channel = (FlushablePositionAwareChannel)Mockito.spy((Object)new InMemoryClosableChannel());
        IOException failure = new IOException(failureMessage);
        Flushable flushable = (Flushable)Mockito.mock(Flushable.class);
        ((FlushablePositionAwareChannel)Mockito.doAnswer(invocation -> {
            invocation.callRealMethod();
            return flushable;
        }).when((Object)channel)).prepareForFlush();
        ((Flushable)Mockito.doThrow((Throwable)failure).when((Object)flushable)).flush();
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)logFile.getWriter()).thenReturn((Object)channel);
        TransactionMetadataCache metadataCache = new TransactionMetadataCache(10);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        Mockito.reset((Object[])new DatabaseHealth[]{this.databaseHealth});
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(logFile, LogRotation.NO_ROTATION, metadataCache, transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        try {
            appender.append(new TransactionToApply(transaction), this.logAppendEvent);
            Assert.fail((String)"Expected append to fail. Something is wrong with the test itself");
        }
        catch (IOException e) {
            Assert.assertSame((Object)failure, (Object)e);
            ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.times((int)1))).nextCommittingTransactionId();
            ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.times((int)0))).transactionClosed(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.anyLong());
            ((DatabaseHealth)Mockito.verify((Object)this.databaseHealth)).panic((Throwable)failure);
        }
    }

    @Test
    public void shouldBeAbleToWriteACheckPoint() throws Throwable {
        FlushablePositionAwareChannel channel = (FlushablePositionAwareChannel)Mockito.mock(FlushablePositionAwareChannel.class, (Answer)Mockito.RETURNS_MOCKS);
        Flushable flushable = (Flushable)Mockito.mock(Flushable.class);
        Mockito.when((Object)channel.prepareForFlush()).thenReturn((Object)flushable);
        Mockito.when((Object)channel.putLong(Matchers.anyLong())).thenReturn((Object)channel);
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        BatchingTransactionAppender appender = (BatchingTransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        appender.checkPoint(new LogPosition(1L, 2L), LogCheckPointEvent.NULL);
        ((FlushablePositionAwareChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).putLong(1L);
        ((FlushablePositionAwareChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).putLong(2L);
        ((FlushablePositionAwareChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).prepareForFlush();
        ((Flushable)Mockito.verify((Object)flushable, (VerificationMode)Mockito.times((int)1))).flush();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.databaseHealth});
    }

    @Test
    public void shouldKernelPanicIfNotAbleToWriteACheckPoint() throws Throwable {
        IOException ioex = new IOException("boom!");
        FlushablePositionAwareChannel channel = (FlushablePositionAwareChannel)Mockito.mock(FlushablePositionAwareChannel.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)channel.put(Matchers.anyByte())).thenReturn((Object)channel);
        Mockito.when((Object)channel.putLong(Matchers.anyLong())).thenThrow(new Throwable[]{ioex});
        Mockito.when((Object)channel.put(Matchers.anyByte())).thenThrow(new Throwable[]{ioex});
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        BatchingTransactionAppender appender = (BatchingTransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        try {
            appender.checkPoint(new LogPosition(0L, 0L), LogCheckPointEvent.NULL);
            Assert.fail((String)"should have thrown ");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)ioex, (Object)ex);
        }
        ((DatabaseHealth)Mockito.verify((Object)this.databaseHealth, (VerificationMode)Mockito.times((int)1))).panic((Throwable)ioex);
    }

    @Test
    public void shouldKernelPanicIfTransactionIdsMismatch() throws Throwable {
        BatchingTransactionAppender appender = (BatchingTransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.databaseHealth));
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)42L);
        TransactionToApply batch = new TransactionToApply((TransactionRepresentation)Mockito.mock(TransactionRepresentation.class), 43L);
        try {
            appender.append(batch, LogAppendEvent.NULL);
            Assert.fail((String)"should have thrown ");
        }
        catch (IllegalStateException ex) {
            ((DatabaseHealth)Mockito.verify((Object)this.databaseHealth, (VerificationMode)Mockito.times((int)1))).panic((Throwable)ex);
        }
    }

    private TransactionRepresentation transaction(Collection<StorageCommand> commands, byte[] additionalHeader, int masterId, int authorId, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted) {
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(additionalHeader, masterId, authorId, timeStarted, latestCommittedTxWhenStarted, timeCommitted, -1);
        return tx;
    }

    private Collection<StorageCommand> singleCreateNodeCommand(long id) {
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        NodeRecord before = new NodeRecord(id);
        NodeRecord after = new NodeRecord(id);
        after.setInUse(true);
        commands.add((StorageCommand)new Command.NodeCommand(before, after));
        return commands;
    }

    private TransactionToApply batchOf(TransactionRepresentation ... transactions) {
        TransactionToApply first = null;
        TransactionToApply last = null;
        for (TransactionRepresentation transaction : transactions) {
            TransactionToApply tx = new TransactionToApply(transaction);
            if (first == null) {
                first = last = tx;
                continue;
            }
            last.next(tx);
            last = tx;
        }
        return first;
    }
}

