/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogTailScanner;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class LogTailScannerTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final File directory = new File("/somewhere");
    private final LogEntryReader<ReadableClosablePositionAwareChannel> reader = new VersionAwareLogEntryReader();
    private LogTailScanner tailScanner;
    private PhysicalLogFiles logFiles;
    private final int startLogVersion;
    private final int endLogVersion;
    private final LogEntryVersion latestLogEntryVersion = LogEntryVersion.CURRENT;

    public LogTailScannerTest(Integer startLogVersion, Integer endLogVersion) {
        this.startLogVersion = startLogVersion;
        this.endLogVersion = endLogVersion;
    }

    @Parameterized.Parameters(name="{0},{1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({1, 2}, {42, 43});
    }

    @Before
    public void setUp() {
        ((EphemeralFileSystemAbstraction)this.fsRule.get()).mkdirs(this.directory);
        this.logFiles = new PhysicalLogFiles(this.directory, this.fsRule.get());
        this.tailScanner = new LogTailScanner(this.logFiles, this.fsRule.get(), this.reader);
    }

    @Test
    public void noLogFilesFound() throws Throwable {
        this.setupLogFiles(new LogCreator[0]);
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, -1L, logTailInformation);
    }

    @Test
    public void oneLogFileNoCheckPoints() throws Throwable {
        this.setupLogFiles(this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void oneLogFileNoCheckPointsOneStart() throws Throwable {
        long txId = 10L;
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPoints() throws Throwable {
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStart() throws Throwable {
        long txId = 21L;
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, txId, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStartWithoutCommit() throws Throwable {
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesNoCheckPointsTwoCommits() throws Throwable {
        long txId = 21L;
        this.setupLogFiles(this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId), LogTailScannerTest.start(), LogTailScannerTest.commit(txId + 1L)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(false, true, txId, this.startLogVersion, logTailInformation);
    }

    @Test
    public void twoLogFilesCheckPointTargetsPrevious() throws Exception {
        long txId = 6L;
        PositionEntry position = LogTailScannerTest.position();
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId - 1L), position), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)), this.logFile(LogTailScannerTest.checkPoint(position)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointOnly() throws Throwable {
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartBefore() throws Throwable {
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void bigFileLatestCheckpointFindsStartAfter() throws Throwable {
        long firstTxAfterCheckpoint = 0x80000003L;
        FirstTxIdConfigurableTailScanner tailScanner = new FirstTxIdConfigurableTailScanner(firstTxAfterCheckpoint, this.logFiles, this.fsRule.get(), this.reader);
        LogEntryStart startEntry = new LogEntryStart(1, 2, 3L, 4L, new byte[]{5, 6}, new LogPosition((long)this.endLogVersion, 0x80000010L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 16L));
        LogTailScanner.LogTailInformation logTailInformation = tailScanner.latestCheckPoint(this.endLogVersion, this.endLogVersion, startEntry, this.endLogVersion, checkPoint, this.latestLogEntryVersion);
        this.assertLatestCheckPoint(true, true, firstTxAfterCheckpoint, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartAfter() throws Throwable {
        long txId = 35L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.commit(txId), LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartWithoutCommitAfter() throws Throwable {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartInBetween() throws Throwable {
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartAfterBoth() throws Throwable {
        long txId = 11L;
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint(), LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileContainingAStart() throws Throwable {
        long txId = 11L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(LogTailScannerTest.checkPoint()), this.logFile(start, LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.startLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileIsEmpty() throws Throwable {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.checkPoint()), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.startLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStart() throws Throwable {
        long txId = 123L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start, LogTailScannerTest.commit(txId)), this.logFile(LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.endLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStartWithoutCommit() throws Throwable {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(this.logFile(start), this.logFile(LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToALaterPositionThanStart() throws Throwable {
        PositionEntry position = LogTailScannerTest.position();
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(3L), position), this.logFile(LogTailScannerTest.checkPoint(position)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, false, LogTailScanner.LogTailInformation.NO_TRANSACTION_ID, this.endLogVersion, logTailInformation);
    }

    @Test
    public void latestLogEmptyStartEntryBeforeAndAfterCheckPointInTheLastButOneLog() throws Throwable {
        long txId = 432L;
        this.setupLogFiles(this.logFile(LogTailScannerTest.start(), LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.commit(txId)), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        this.assertLatestCheckPoint(true, true, txId, this.startLogVersion, logTailInformation);
    }

    private void setupLogFiles(LogCreator ... logFiles) throws IOException {
        HashMap<Entry, LogPosition> positions = new HashMap<Entry, LogPosition>();
        long version = this.endLogVersion - logFiles.length;
        for (LogCreator logFile : logFiles) {
            logFile.create(++version, positions);
        }
    }

    private LogCreator logFile(Entry ... entries) {
        return (logVersion, positions) -> {
            try {
                AtomicLong lastTxId = new AtomicLong();
                Supplier<Long> lastTxIdSupplier = lastTxId::get;
                DeadSimpleLogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(logVersion);
                LifeSupport life = new LifeSupport();
                life.start();
                PhysicalLogFile logFile = (PhysicalLogFile)life.add((Lifecycle)new PhysicalLogFile(this.fsRule.get(), this.logFiles, ByteUnit.mebiBytes((long)1L), lastTxIdSupplier, (LogVersionRepository)logVersionRepository, PhysicalLogFile.NO_MONITOR, new LogHeaderCache(10)));
                try {
                    FlushablePositionAwareChannel writeChannel = logFile.getWriter();
                    LogPositionMarker positionMarker = new LogPositionMarker();
                    LogEntryWriter writer = new LogEntryWriter((FlushableChannel)writeChannel);
                    for (Entry entry : entries) {
                        LogPosition currentPosition = writeChannel.getCurrentPosition(positionMarker).newPosition();
                        positions.put(entry, currentPosition);
                        if (entry instanceof StartEntry) {
                            writer.writeStartEntry(0, 0, 0L, 0L, new byte[0]);
                            continue;
                        }
                        if (entry instanceof CommitEntry) {
                            CommitEntry commitEntry = (CommitEntry)entry;
                            writer.writeCommitEntry(commitEntry.txId, 0L);
                            lastTxId.set(commitEntry.txId);
                            continue;
                        }
                        if (entry instanceof CheckPointEntry) {
                            LogPosition logPosition;
                            CheckPointEntry checkPointEntry = (CheckPointEntry)entry;
                            Entry target = checkPointEntry.withPositionOfEntry;
                            LogPosition logPosition2 = logPosition = target != null ? (LogPosition)positions.get(target) : currentPosition;
                            assert (logPosition != null) : "No registered log position for " + target;
                            writer.writeCheckPointEntry(logPosition);
                            continue;
                        }
                        if (entry instanceof PositionEntry) continue;
                        throw new IllegalArgumentException("Unknown entry " + entry);
                    }
                }
                finally {
                    life.shutdown();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static StartEntry start() {
        return new StartEntry();
    }

    private static CommitEntry commit(long txId) {
        return new CommitEntry(txId);
    }

    private static CheckPointEntry checkPoint() {
        return LogTailScannerTest.checkPoint(null);
    }

    private static CheckPointEntry checkPoint(Entry forEntry) {
        return new CheckPointEntry(forEntry);
    }

    private static PositionEntry position() {
        return new PositionEntry();
    }

    private void assertLatestCheckPoint(boolean hasCheckPointEntry, boolean commitsAfterLastCheckPoint, long firstTxIdAfterLastCheckPoint, long logVersion, LogTailScanner.LogTailInformation logTailInformation) {
        Assert.assertEquals((Object)hasCheckPointEntry, (Object)(logTailInformation.lastCheckPoint != null ? 1 : 0));
        Assert.assertEquals((Object)commitsAfterLastCheckPoint, (Object)logTailInformation.commitsAfterLastCheckPoint);
        if (commitsAfterLastCheckPoint) {
            Assert.assertEquals((long)firstTxIdAfterLastCheckPoint, (long)logTailInformation.firstTxIdAfterLastCheckPoint);
        }
        Assert.assertEquals((long)logVersion, (long)logTailInformation.oldestLogVersionFound);
    }

    private static class FirstTxIdConfigurableTailScanner
    extends LogTailScanner {
        private final long txId;

        FirstTxIdConfigurableTailScanner(long txId, PhysicalLogFiles logFiles, FileSystemAbstraction fileSystem, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader) {
            super(logFiles, fileSystem, logEntryReader);
            this.txId = txId;
        }

        public LogTailScanner.LogTailInformation latestCheckPoint(long fromVersionBackwards, long version, LogEntryStart latestStartEntry, long oldestVersionFound, CheckPoint latestCheckPoint, LogEntryVersion latestLogEntryVersion) throws IOException {
            return super.latestCheckPoint(fromVersionBackwards, version, latestStartEntry, oldestVersionFound, latestCheckPoint, latestLogEntryVersion);
        }

        protected long extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) throws IOException {
            return this.txId;
        }
    }

    private static class PositionEntry
    implements Entry {
        private PositionEntry() {
        }
    }

    private static class CheckPointEntry
    implements Entry {
        final Entry withPositionOfEntry;

        CheckPointEntry(Entry withPositionOfEntry) {
            this.withPositionOfEntry = withPositionOfEntry;
        }
    }

    private static class CommitEntry
    implements Entry {
        final long txId;

        CommitEntry(long txId) {
            this.txId = txId;
        }
    }

    private static class StartEntry
    implements Entry {
        private StartEntry() {
        }
    }

    static interface Entry {
    }

    static interface LogCreator {
        public void create(long var1, Map<Entry, LogPosition> var3) throws IOException;
    }
}

