/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.transaction.log.LogTailScanner;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class LogVersionUpgradeCheckerTest {
    private LogTailScanner tailScanner = (LogTailScanner)Mockito.mock(LogTailScanner.class);
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Test
    public void noThrowWhenLatestVersionAndUpgradeIsNotAllowed() throws Throwable {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.CURRENT));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (String)"false"));
    }

    @Test
    public void throwWhenVersionIsOlderAndUpgradeIsNotAllowed() throws Throwable {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.V2_3));
        this.expect.expect(UpgradeNotAllowedByConfigurationException.class);
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (String)"false"));
    }

    @Test
    public void stillAcceptLatestVersionWhenUpgradeIsAllowed() throws Throwable {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.CURRENT));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (String)"true"));
    }

    @Test
    public void acceptOlderLogsWhenUpgradeIsAllowed() throws Throwable {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.V2_3));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (String)"true"));
    }

    private static class OnlyVersionTailInformation
    extends LogTailScanner.LogTailInformation {
        OnlyVersionTailInformation(LogEntryVersion logEntryVersion) {
            super(null, false, 0L, 0L, 0L, logEntryVersion);
        }
    }
}

