/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReversedMultiFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;

public class ReversedMultiFileTransactionCursorTest {
    @Test
    public void shouldReadSingleVersionReversed() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.log(5), 0L, LogPosition.start((long)0L));
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 5L, 0L);
    }

    @Test
    public void shouldReadMultipleVersionsReversed() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.log(5, 3, 8), 2L, LogPosition.start((long)0L));
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 16L, 0L);
    }

    @Test
    public void shouldRespectStartLogPosition() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.log(5, 6, 8), 2L, new LogPosition(1L, 19L));
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 19L, 8L);
    }

    @Test
    public void shouldHandleEmptyLogsMidStream() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.log(5, 0, 2, 0, 3), 4L, LogPosition.start((long)0L));
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 10L, 0L);
    }

    @Test
    public void shouldHandleEmptySingleLogVersion() throws Exception {
        ReversedMultiFileTransactionCursor cursor = new ReversedMultiFileTransactionCursor(this.log(0), 0L, LogPosition.start((long)0L));
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        this.assertTransactionRange(reversed, 0L, 0L);
    }

    private void assertTransactionRange(CommittedTransactionRepresentation[] reversed, long highTxId, long lowTxId) {
        long expectedTxId = highTxId;
        for (CommittedTransactionRepresentation transaction : reversed) {
            Assert.assertEquals((long)(--expectedTxId), (long)transaction.getCommitEntry().getTxId());
        }
        Assert.assertEquals((long)lowTxId, (long)expectedTxId);
    }

    private ThrowingFunction<LogPosition, TransactionCursor, IOException> log(int ... transactionCounts) throws IOException {
        long baseOffset = LogPosition.start((long)0L).getByteOffset();
        ThrowingFunction result = (ThrowingFunction)Mockito.mock(ThrowingFunction.class);
        AtomicLong txId = new AtomicLong(0L);
        CommittedTransactionRepresentation[][] logs = new CommittedTransactionRepresentation[transactionCounts.length][];
        for (int logVersion = 0; logVersion < transactionCounts.length; ++logVersion) {
            logs[logVersion] = this.transactions(transactionCounts[logVersion], txId);
        }
        Mockito.when((Object)result.apply(Matchers.any(LogPosition.class))).thenAnswer(invocation -> {
            LogPosition position = (LogPosition)invocation.getArgumentAt(0, LogPosition.class);
            if (position == null) {
                return null;
            }
            CommittedTransactionRepresentation[] transactions = logs[Math.toIntExact(position.getLogVersion())];
            Object[] subset = Arrays.copyOfRange(transactions, Math.toIntExact(position.getByteOffset() - baseOffset), transactions.length);
            ArrayUtil.reverse((Object[])subset);
            return GivenTransactionCursor.given((CommittedTransactionRepresentation[])subset);
        });
        return result;
    }

    private CommittedTransactionRepresentation[] transactions(int count, AtomicLong txId) {
        CommittedTransactionRepresentation[] result = new CommittedTransactionRepresentation[count];
        for (int i = 0; i < count; ++i) {
            CommittedTransactionRepresentation transaction = result[i] = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
            LogEntryCommit commitEntry = (LogEntryCommit)Mockito.mock(LogEntryCommit.class);
            Mockito.when((Object)commitEntry.getTxId()).thenReturn((Object)txId.getAndIncrement());
            Mockito.when((Object)transaction.getCommitEntry()).thenReturn((Object)commitEntry);
        }
        return result;
    }
}

