/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ReversedSingleFileTransactionCursorTest {
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private final LifeRule life = new LifeRule(true);
    private final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.life);
    private long txId = 1L;
    private PhysicalLogFile logFile;

    @Before
    public void setUp() {
        DeadSimpleLogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(0L);
        this.logFile = (PhysicalLogFile)this.life.add((Lifecycle)new PhysicalLogFile((FileSystemAbstraction)this.fs, new PhysicalLogFiles(this.directory.absolutePath(), (FileSystemAbstraction)this.fs), ByteUnit.mebiBytes((long)1L), () -> this.txId, (LogVersionRepository)logVersionRepository, PhysicalLogFile.NO_MONITOR, new LogHeaderCache(10)));
    }

    @Test
    public void shouldHandleVerySmallTransactions() throws Exception {
        this.writeTransactions(10, 1, 1);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    public void shouldHandleManyVerySmallTransactions() throws Exception {
        this.writeTransactions(20000, 1, 1);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    public void shouldHandleLargeTransactions() throws Exception {
        this.writeTransactions(10, 1000, 1000);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    public void shouldHandleEmptyLog() throws Exception {
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        Assert.assertEquals((long)0L, (long)readTransactions.length);
    }

    @Test
    public void shouldDetectAndPreventChannelReadingMultipleLogVersions() throws Exception {
        this.writeTransactions(1, 1, 1);
        this.logFile.rotate();
        this.writeTransactions(1, 1, 1);
        try (ReadAheadLogChannel channel = (ReadAheadLogChannel)this.logFile.getReader(LogPosition.start((long)0L));){
            new ReversedSingleFileTransactionCursor(channel, (LogEntryReader)new VersionAwareLogEntryReader());
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple log versions"));
        }
    }

    private CommittedTransactionRepresentation[] readAllFromReversedCursor() throws IOException {
        try (ReversedSingleFileTransactionCursor cursor = this.txCursor();){
            CommittedTransactionRepresentation[] committedTransactionRepresentationArray = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
            return committedTransactionRepresentationArray;
        }
    }

    private void assertTransactionRange(CommittedTransactionRepresentation[] readTransactions, long highTxId, long lowTxId) {
        long expectedTxId = highTxId;
        for (int i = 0; i < readTransactions.length; ++i) {
            CommittedTransactionRepresentation tx = readTransactions[i];
            Assert.assertEquals((long)expectedTxId, (long)tx.getCommitEntry().getTxId());
            --expectedTxId;
        }
        Assert.assertEquals((long)expectedTxId, (long)lowTxId);
    }

    private ReversedSingleFileTransactionCursor txCursor() throws IOException {
        return new ReversedSingleFileTransactionCursor((ReadAheadLogChannel)this.logFile.getReader(LogPosition.start((long)0L), LogVersionBridge.NO_MORE_CHANNELS), (LogEntryReader)new VersionAwareLogEntryReader());
    }

    private void writeTransactions(int transactionCount, int minTransactionSize, int maxTransactionSize) throws IOException {
        FlushablePositionAwareChannel channel = this.logFile.getWriter();
        TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((FlushableChannel)channel));
        for (int i = 0; i < transactionCount; ++i) {
            writer.append(this.tx(this.random.intBetween(minTransactionSize, maxTransactionSize)), ++this.txId);
        }
        channel.prepareForFlush().flush();
    }

    private TransactionRepresentation tx(int size) {
        ArrayList<Command.NodeCommand> commands = new ArrayList<Command.NodeCommand>();
        for (int i = 0; i < size; ++i) {
            commands.add(new Command.NodeCommand(new NodeRecord((long)i), new NodeRecord((long)i).initialize(true, (long)i, false, (long)i, Record.NO_LABELS_FIELD.longValue())));
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return tx;
    }
}

