/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class LogEntryVersionTest {
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Test
    public void shouldBeAbleToSelectAnyVersion() throws Exception {
        for (LogEntryVersion version : LogEntryVersion.values()) {
            byte code = version.byteCode();
            LogEntryVersion selectedVersion = LogEntryVersion.byVersion((byte)code);
            Assert.assertEquals((Object)version, (Object)selectedVersion);
        }
    }

    @Test
    public void shouldWarnAboutOldLogVersion() throws Exception {
        this.expect.expect(IllegalArgumentException.class);
        LogEntryVersion.byVersion((byte)-4);
    }

    @Test
    public void shouldWarnAboutNewerLogVersion() throws Exception {
        this.expect.expect(IllegalArgumentException.class);
        LogEntryVersion.byVersion((byte)-42);
    }

    @Test
    public void moreRecent() throws Exception {
        Assert.assertTrue((boolean)LogEntryVersion.moreRecentVersionExists((LogEntryVersion)LogEntryVersion.V2_3));
        Assert.assertTrue((boolean)LogEntryVersion.moreRecentVersionExists((LogEntryVersion)LogEntryVersion.V3_0));
        Assert.assertTrue((boolean)LogEntryVersion.moreRecentVersionExists((LogEntryVersion)LogEntryVersion.V2_3_5));
        Assert.assertTrue((boolean)LogEntryVersion.moreRecentVersionExists((LogEntryVersion)LogEntryVersion.V3_0_2));
        Assert.assertFalse((boolean)LogEntryVersion.moreRecentVersionExists((LogEntryVersion)LogEntryVersion.V3_0_10));
    }
}

