/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LogHeaderReaderTest {
    private final long expectedLogVersion = 6L;
    private final long expectedTxId = 42L;
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void shouldReadALogHeaderFromAByteChannel() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.read(buffer)).thenAnswer(invocation -> {
            buffer.putLong(LogHeaderWriter.encodeLogVersion((long)6L));
            buffer.putLong(42L);
            return 16;
        });
        LogHeader result = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true, null);
        Assert.assertEquals((Object)new LogHeader(6, 6L, 42L), (Object)result);
    }

    @Test
    public void shouldFailWhenUnableToReadALogHeaderFromAChannel() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.read(buffer)).thenReturn((Object)1);
        try {
            LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true, null);
            Assert.fail((String)"should have thrown");
        }
        catch (IncompleteLogHeaderException incompleteLogHeaderException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReadALogHeaderFromAFile() throws IOException {
        File file = File.createTempFile("ReadLogHeader", this.getClass().getSimpleName());
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(LogHeaderWriter.encodeLogVersion((long)6L));
        buffer.putLong(42L);
        try (OutputStream stream = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).openAsOutputStream(file, false);){
            stream.write(buffer.array());
        }
        LogHeader result = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystemRule.get(), (File)file);
        Assert.assertEquals((Object)new LogHeader(6, 6L, 42L), (Object)result);
    }

    @Test
    public void shouldFailWhenUnableToReadALogHeaderFromAFile() throws IOException {
        File file = File.createTempFile("ReadLogHeaderFail", this.getClass().getSimpleName());
        try {
            LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystemRule.get(), (File)file);
            Assert.fail((String)"should have thrown");
        }
        catch (IncompleteLogHeaderException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains(file.getName()));
        }
    }

    @Test
    public void shouldReadALongString() throws IOException {
        int stringSize = 32769;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringSize; ++i) {
            sb.append("x");
        }
        String lengthyString = sb.toString();
        InMemoryClosableChannel channel = new InMemoryClosableChannel(stringSize + 3);
        IoPrimitiveUtils.write3bLengthAndString((WritableChannel)channel, (String)lengthyString);
        String stringFromChannel = IoPrimitiveUtils.read3bLengthAndString((ReadableChannel)channel);
        Assert.assertEquals((Object)lengthyString, (Object)stringFromChannel);
    }
}

