/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.util.stream.LongStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class LogPruningTest {
    private FileSystemAbstraction fs;
    private PhysicalLogFiles logFiles;
    private LogProvider logProvider;

    @Before
    public void setUp() {
        this.fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.logFiles = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
        ((PhysicalLogFiles)Mockito.doAnswer(inv -> new File(String.valueOf(inv.getArguments()[0]))).when((Object)this.logFiles)).getLogFileForVersion(Matchers.anyLong());
        this.logProvider = NullLogProvider.getInstance();
    }

    @Test
    public void mustDeleteLogFilesThatCanBePruned() throws Exception {
        LogPruneStrategy strategy = upTo -> LongStream.range(3L, upTo);
        LogPruningImpl pruning = new LogPruningImpl(this.fs, strategy, this.logFiles, this.logProvider);
        pruning.pruneLogs(5L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.fs});
        ((FileSystemAbstraction)order.verify((Object)this.fs)).deleteFile(new File("3"));
        ((FileSystemAbstraction)order.verify((Object)this.fs)).deleteFile(new File("4"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fs});
    }

    @Test
    public void mustHaveLogFilesToPruneIfStrategyFindsFiles() throws Exception {
        LogPruneStrategy strategy = upTo -> LongStream.range(3L, upTo);
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)4L);
        LogPruningImpl pruning = new LogPruningImpl(this.fs, strategy, this.logFiles, this.logProvider);
        Assert.assertTrue((boolean)pruning.mightHaveLogsToPrune());
    }

    @Test
    public void mustNotHaveLogsFilesToPruneIfStrategyFindsNoFiles() throws Exception {
        LogPruneStrategy strategy = x -> LongStream.empty();
        LogPruningImpl pruning = new LogPruningImpl(this.fs, strategy, this.logFiles, this.logProvider);
        Assert.assertFalse((boolean)pruning.mightHaveLogsToPrune());
    }
}

