/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandlerContract;
import org.neo4j.kernel.impl.transaction.command.NeoStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ApplyRecoveredTransactionsTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private NeoStores neoStores;

    @Test
    public void shouldSetCorrectHighIdWhenApplyingExternalTransactions() throws Exception {
        long nodeId = this.neoStores.getNodeStore().nextId();
        long relationshipId = this.neoStores.getRelationshipStore().nextId();
        int type = 1;
        this.applyExternalTransaction(1L, new Command[]{new Command.NodeCommand(new NodeRecord(nodeId), this.inUse(this.created(new NodeRecord(nodeId)))), new Command.RelationshipCommand(null, this.inUse(this.created(this.with(new RelationshipRecord(relationshipId), nodeId, nodeId, type))))});
        this.applyExternalTransaction(2L, new Command[]{new Command.NodeCommand(this.inUse(this.created(new NodeRecord(nodeId))), new NodeRecord(nodeId)), new Command.RelationshipCommand(null, new RelationshipRecord(relationshipId))});
        Assert.assertEquals((long)(nodeId + 1L), (long)this.neoStores.getNodeStore().getHighId());
        Assert.assertEquals((long)(relationshipId + 1L), (long)this.neoStores.getRelationshipStore().getHighId());
    }

    private RelationshipRecord with(RelationshipRecord relationship, long startNode, long endNode, int type) {
        relationship.setFirstNode(startNode);
        relationship.setSecondNode(endNode);
        relationship.setType(type);
        return relationship;
    }

    private void applyExternalTransaction(long transactionId, Command ... commands) throws Exception {
        LockService lockService = (LockService)Mockito.mock(LockService.class);
        Mockito.when((Object)lockService.acquireNodeLock(Matchers.anyLong(), (LockService.LockType)Matchers.any(LockService.LockType.class))).thenReturn((Object)LockService.NO_LOCK);
        Mockito.when((Object)lockService.acquireRelationshipLock(Matchers.anyLong(), (LockService.LockType)Matchers.any(LockService.LockType.class))).thenReturn((Object)LockService.NO_LOCK);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(this.neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), lockService);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Arrays.asList(commands));
        CommandHandlerContract.apply((BatchTransactionApplier)applier, arg_0 -> ApplyRecoveredTransactionsTest.lambda$applyExternalTransaction$0((TransactionRepresentation)tx, arg_0), new TransactionToApply((TransactionRepresentation)tx, transactionId));
    }

    @Before
    public void before() {
        FileSystemAbstraction fs = this.fsr.get();
        File storeDir = new File("dir");
        StoreFactory storeFactory = new StoreFactory(storeDir, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs), this.pageCacheRule.getPageCache(fs), fs, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.neoStores = storeFactory.openAllNeoStores(true);
    }

    @After
    public void after() {
        this.neoStores.close();
    }

    private <RECORD extends AbstractBaseRecord> RECORD inUse(RECORD record) {
        record.setInUse(true);
        return record;
    }

    private <RECORD extends AbstractBaseRecord> RECORD created(RECORD record) {
        record.setCreated();
        return record;
    }

    private static /* synthetic */ boolean lambda$applyExternalTransaction$0(TransactionRepresentation tx, TransactionApplier txApplier) throws Exception {
        tx.accept((Visitor)txApplier);
        return false;
    }
}

