/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;

public class DefaultSchemaIndexProviderMapTest {
    @Test
    public void shouldNotSupportMultipleProvidersWithSameDescriptor() throws Exception {
        SchemaIndexProvider.Descriptor descriptor = new SchemaIndexProvider.Descriptor("provider", "1.2");
        SchemaIndexProvider provider1 = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider1.getProviderDescriptor()).thenReturn((Object)descriptor);
        SchemaIndexProvider provider2 = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider2.getProviderDescriptor()).thenReturn((Object)descriptor);
        try {
            new DefaultSchemaIndexProviderMap(provider1, Arrays.asList(provider2));
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnLookupOnUnknownProvider() throws Exception {
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)new SchemaIndexProvider.Descriptor("provider", "1.2"));
        DefaultSchemaIndexProviderMap map = new DefaultSchemaIndexProviderMap(provider);
        try {
            new DefaultSchemaIndexProviderMap(provider).apply(new SchemaIndexProvider.Descriptor("provider2", "1.2"));
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

