/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ExplicitIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.storemigration.LogFiles;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class NeoStoreFileListingTest {
    @Rule
    public EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();
    private NeoStoreDataSource neoStoreDataSource;
    private static final String[] STANDARD_STORE_DIR_FILES = new String[]{"index", "lock", "debug.log", "neostore", "neostore.id", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.labelscanstore.db", "neostore.labeltokenstore.db", "neostore.labeltokenstore.db.id", "neostore.labeltokenstore.db.names", "neostore.labeltokenstore.db.names.id", "neostore.nodestore.db", "neostore.nodestore.db.id", "neostore.nodestore.db.labels", "neostore.nodestore.db.labels.id", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.arrays.id", "neostore.propertystore.db.id", "neostore.propertystore.db.index", "neostore.propertystore.db.index.id", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.index.keys.id", "neostore.propertystore.db.strings", "neostore.propertystore.db.strings.id", "neostore.relationshipgroupstore.db", "neostore.relationshipgroupstore.db.id", "neostore.relationshipstore.db", "neostore.relationshipstore.db.id", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.id", "neostore.relationshiptypestore.db.names", "neostore.relationshiptypestore.db.names.id", "neostore.schemastore.db", "neostore.schemastore.db.id", "neostore.transaction.db.active", "neostore.transaction.db.0", "neostore.transaction.db.1", "neostore.transaction.db.2", "store_lock"};
    private static final String[] STANDARD_STORE_DIR_DIRECTORIES = new String[]{"schema", "index", "branched"};
    private static final Function<StoreFileMetadata, Optional<StoreType>> toStoreType = fileMetaData -> StoreType.typeOf((String)fileMetaData.file().getName());

    @Before
    public void setUp() throws IOException {
        this.createIndexDbFile();
        this.neoStoreDataSource = (NeoStoreDataSource)this.db.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
    }

    private void createIndexDbFile() throws IOException {
        File storeDir = this.db.getStoreDir();
        File indexFile = new File(storeDir, "index.db");
        if (!indexFile.exists()) {
            Assert.assertTrue((boolean)indexFile.createNewFile());
        }
    }

    @Test
    public void shouldCloseIndexAndLabelScanSnapshots() throws Exception {
        LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        ExplicitIndexProviderLookup explicitIndexes = (ExplicitIndexProviderLookup)Mockito.mock(ExplicitIndexProviderLookup.class);
        Mockito.when((Object)explicitIndexes.all()).thenReturn(Collections.emptyList());
        File storeDir = (File)Mockito.mock(File.class);
        this.filesInStoreDirAre(storeDir, STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        NeoStoreFileListing fileListing = new NeoStoreFileListing(storeDir, labelScanStore, indexingService, explicitIndexes, storageEngine);
        ResourceIterator<File> scanSnapshot = this.scanStoreFilesAre(labelScanStore, new String[]{"blah/scan.store", "scan.more"});
        ResourceIterator<File> indexSnapshot = this.indexFilesAre(indexingService, new String[]{"schema/index/my.index"});
        ResourceIterator result = fileListing.listStoreFiles(false);
        result.close();
        ((ResourceIterator)Mockito.verify(scanSnapshot)).close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    @Test
    public void shouldListMetaDataStoreLast() throws Exception {
        Assert.assertTrue((boolean)this.neoStoreDataSource.listStoreFiles(false).stream().reduce((a, b) -> b).map(toStoreType).filter(Optional::isPresent).map(Optional::get).filter(arg_0 -> StoreType.META_DATA.equals(arg_0)).isPresent());
    }

    @Test
    public void shouldListMetaDataStoreLastWithTxLogs() throws Exception {
        Assert.assertTrue((boolean)this.neoStoreDataSource.listStoreFiles(true).stream().reduce((a, b) -> b).map(toStoreType).filter(Optional::isPresent).map(Optional::get).filter(arg_0 -> StoreType.META_DATA.equals(arg_0)).isPresent());
    }

    @Test
    public void shouldListTxLogFiles() throws Exception {
        Assert.assertTrue((boolean)this.neoStoreDataSource.listStoreFiles(true).stream().map(metaData -> metaData.file().getName()).anyMatch(fileName -> LogFiles.FILENAME_FILTER.accept(null, (String)fileName)));
    }

    @Test
    public void shouldNotListTxLogFiles() throws Exception {
        Assert.assertTrue((boolean)this.neoStoreDataSource.listStoreFiles(false).stream().map(metaData -> metaData.file().getName()).noneMatch(fileName -> LogFiles.FILENAME_FILTER.accept(null, (String)fileName)));
    }

    @Test
    public void shouldListNeostoreFiles() throws Exception {
        StoreType[] values = StoreType.values();
        ResourceIterator storeFiles = this.neoStoreDataSource.listStoreFiles(false);
        List listedStoreFiles = storeFiles.stream().map(toStoreType).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Assert.assertEquals(Arrays.asList(values), listedStoreFiles);
    }

    private void filesInStoreDirAre(File storeDir, String[] filenames, String[] dirs) {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(filenames, files, false);
        this.mockFiles(dirs, files, true);
        Mockito.when((Object)storeDir.listFiles()).thenReturn((Object)files.toArray(new File[files.size()]));
    }

    private ResourceIterator<File> scanStoreFilesAre(LabelScanStore labelScanStore, String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)labelScanStore.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private ResourceIterator<File> indexFilesAre(IndexingService indexingService, String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)indexingService.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void mockFiles(String[] filenames, ArrayList<File> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            files.add(file);
        }
    }
}

