/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class NodeStoreScanTest {
    private final LockService locks = (LockService)Mockito.mock(LockService.class, (Answer)Mockito.RETURNS_MOCKS);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);

    @Test
    public void shouldGiveBackCompletionPercentage() throws Throwable {
        int total = 10;
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)10L);
        NodeRecord inUseRecord = new NodeRecord(42L);
        inUseRecord.setInUse(true);
        Mockito.when((Object)this.nodeStore.getRecord(Matchers.anyLong(), (AbstractBaseRecord)Matchers.any(NodeRecord.class), (RecordLoad)Matchers.any(RecordLoad.class))).thenReturn((Object)inUseRecord, (Object[])new NodeRecord[]{inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord});
        final PercentageSupplier percentageSupplier = new PercentageSupplier();
        NodeStoreScan<RuntimeException> scan = new NodeStoreScan<RuntimeException>(this.nodeStore, this.locks, 10L){
            private int read;

            public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
            }

            public void process(NodeRecord node) {
                ++this.read;
                float expected = (float)this.read / 10.0f;
                float actual = percentageSupplier.get().floatValue();
                Assert.assertEquals((String)String.format("%f==%f", Float.valueOf(expected), Float.valueOf(actual)), (double)expected, (double)actual, (double)0.0);
            }
        };
        percentageSupplier.setStoreScan((StoreScan<?>)scan);
        scan.run();
    }

    private static class PercentageSupplier
    implements Supplier<Float> {
        private StoreScan<?> storeScan;

        private PercentageSupplier() {
        }

        @Override
        public Float get() {
            Assert.assertNotNull(this.storeScan);
            PopulationProgress progress = this.storeScan.getProgress();
            return Float.valueOf((float)progress.getCompleted() / (float)progress.getTotal());
        }

        public void setStoreScan(StoreScan<?> storeScan) {
            this.storeScan = storeScan;
        }
    }
}

