/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.ReflectionUtil;

public class Neo4jJobSchedulerTest {
    private final AtomicInteger invocations = new AtomicInteger();
    private final LifeSupport life = new LifeSupport();
    private final Neo4jJobScheduler scheduler = (Neo4jJobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler());
    private final Runnable countInvocationsJob = () -> {
        try {
            this.invocations.incrementAndGet();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw Exceptions.launderedException((Throwable)e);
        }
    };

    @After
    public void stopScheduler() throws Throwable {
        this.life.shutdown();
    }

    @Test(timeout=10000L)
    public void shouldRunRecurringJob() throws Throwable {
        long period = 100L;
        int count = 5;
        this.life.start();
        this.scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitInvocationCount(count);
        this.scheduler.shutdown();
        int actualInvocations = this.invocations.get();
        Thread.sleep(period * 2L);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)actualInvocations));
    }

    @Test
    public void shouldCancelRecurringJob() throws Exception {
        long period = 2L;
        this.life.start();
        JobScheduler.JobHandle jobHandle = this.scheduler.scheduleRecurring(JobScheduler.Groups.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        jobHandle.cancel(false);
        try {
            jobHandle.waitTermination();
            Assert.fail((String)"Task should be terminated");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        int recorded = this.invocations.get();
        Thread.sleep(period * 100L);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(recorded))).and(Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(recorded + 1))));
    }

    @Test
    public void shouldRunWithDelay() throws Throwable {
        this.life.start();
        AtomicLong runTime = new AtomicLong();
        CountDownLatch latch = new CountDownLatch(1);
        long time = System.nanoTime();
        this.scheduler.schedule(new JobScheduler.Group("group"), () -> {
            runTime.set(System.nanoTime());
            latch.countDown();
        }, 100L, TimeUnit.MILLISECONDS);
        latch.await();
        Assert.assertTrue((time + TimeUnit.MILLISECONDS.toNanos(100L) <= runTime.get() ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotSwallowExceptions() throws Exception {
        Neo4jJobScheduler neo4jJobScheduler = new Neo4jJobScheduler();
        neo4jJobScheduler.init();
        ExecutorService es = (ExecutorService)Mockito.mock(ExecutorService.class);
        ((ExecutorService)Mockito.doThrow((Throwable)new RuntimeException("ES")).when((Object)es)).shutdown();
        ReflectionUtil.replaceValueInPrivateField(neo4jJobScheduler, "globalPool", ExecutorService.class, es);
        ScheduledThreadPoolExecutor stpe = (ScheduledThreadPoolExecutor)Mockito.mock(ScheduledThreadPoolExecutor.class);
        ((ScheduledThreadPoolExecutor)Mockito.doThrow((Throwable)new RuntimeException("STPE")).when((Object)stpe)).shutdown();
        ReflectionUtil.replaceValueInPrivateField(neo4jJobScheduler, "scheduledExecutor", ScheduledThreadPoolExecutor.class, stpe);
        try {
            neo4jJobScheduler.shutdown();
        }
        catch (RuntimeException t) {
            Assert.assertEquals((Object)"Unable to shut down job scheduler properly.", (Object)t.getMessage());
            Throwable inner = t.getCause();
            Assert.assertEquals((Object)"ES", (Object)inner.getMessage());
            Assert.assertEquals((long)1L, (long)inner.getSuppressed().length);
            Assert.assertEquals((Object)"STPE", (Object)inner.getSuppressed()[0].getMessage());
        }
    }

    @Test
    public void shouldNotifyCancelListeners() throws Exception {
        Neo4jJobScheduler neo4jJobScheduler = new Neo4jJobScheduler();
        neo4jJobScheduler.init();
        AtomicBoolean halted = new AtomicBoolean();
        Runnable job = () -> {
            while (!halted.get()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            }
        };
        JobScheduler.JobHandle handle = neo4jJobScheduler.schedule(JobScheduler.Groups.indexPopulation, job);
        handle.registerCancelListener(mayBeInterrupted -> halted.set(true));
        handle.cancel(false);
        Assert.assertTrue((boolean)halted.get());
        neo4jJobScheduler.shutdown();
    }

    private void awaitFirstInvocation() throws InterruptedException {
        this.awaitInvocationCount(1);
    }

    private void awaitInvocationCount(int count) throws InterruptedException {
        while (this.invocations.get() < count) {
            Thread.sleep(10L);
        }
    }
}

