/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureCollector;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureLookup;

public class DbStructureCollectorTest {
    @Test
    public void collectsDbStructure() {
        DbStructureCollector collector = new DbStructureCollector();
        collector.visitLabel(1, "Person");
        collector.visitLabel(2, "City");
        collector.visitPropertyKey(1, "name");
        collector.visitPropertyKey(2, "income");
        collector.visitRelationshipType(1, "LIVES_IN");
        collector.visitRelationshipType(2, "FRIEND");
        collector.visitIndex(IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1}), ":Person(name)", 1.0, 1L);
        collector.visitUniqueConstraint(ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{1}), ":City(name)");
        collector.visitNodeKeyConstraint(ConstraintDescriptorFactory.nodeKeyForLabel((int)2, (int[])new int[]{1}), ":City(name)");
        collector.visitIndex(IndexDescriptorFactory.forLabel((int)2, (int[])new int[]{2}), ":City(income)", 0.2, 1L);
        collector.visitAllNodesCount(50L);
        collector.visitNodeCount(1, "Person", 20L);
        collector.visitNodeCount(2, "City", 30L);
        collector.visitRelCount(1, 2, -1, "(:Person)-[:FRIEND]->()", 500L);
        DbStructureLookup lookup = collector.lookup();
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"Person"), Pair.of((Object)2, (Object)"City")), (Object)Iterators.asList((Iterator)lookup.labels()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"name"), Pair.of((Object)2, (Object)"income")), (Object)Iterators.asList((Iterator)lookup.properties()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"LIVES_IN"), Pair.of((Object)2, (Object)"FRIEND")), (Object)Iterators.asList((Iterator)lookup.relationshipTypes()));
        Assert.assertEquals(Arrays.asList("Person"), (Object)Iterators.asList((Iterator)Iterators.map(Pair::first, (Iterator)lookup.knownUniqueIndices())));
        Assert.assertArrayEquals((Object[])new String[]{"name"}, (Object[])((Object[])((Pair)lookup.knownUniqueIndices().next()).other()));
        Assert.assertEquals(Arrays.asList("City"), (Object)Iterators.asList((Iterator)Iterators.map(Pair::first, (Iterator)lookup.knownNodeKeyConstraints())));
        Assert.assertArrayEquals((Object[])new String[]{"name"}, (Object[])((Object[])((Pair)lookup.knownNodeKeyConstraints().next()).other()));
        Assert.assertEquals(Arrays.asList("City"), (Object)Iterators.asList((Iterator)Iterators.map(Pair::first, (Iterator)lookup.knownUniqueConstraints())));
        Assert.assertArrayEquals((Object[])new String[]{"name"}, (Object[])((Object[])((Pair)lookup.knownUniqueConstraints().next()).other()));
        Assert.assertEquals(Arrays.asList("City"), (Object)Iterators.asList((Iterator)Iterators.map(Pair::first, (Iterator)lookup.knownIndices())));
        Assert.assertArrayEquals((Object[])new String[]{"income"}, (Object[])((Object[])((Pair)lookup.knownIndices().next()).other()));
        Assert.assertEquals((long)50L, (long)lookup.nodesAllCardinality());
        Assert.assertEquals((long)20L, (long)lookup.nodesWithLabelCardinality(1));
        Assert.assertEquals((long)30L, (long)lookup.nodesWithLabelCardinality(2));
        Assert.assertEquals((long)500L, (long)lookup.cardinalityByLabelsAndRelationshipType(1, 2, -1));
        Assert.assertEquals((double)1.0, (double)lookup.indexSelectivity(1, new int[]{1}), (double)0.01);
        Assert.assertEquals((double)0.2, (double)lookup.indexSelectivity(2, new int[]{2}), (double)0.01);
    }

    @Test
    public void collectsCompositeDbStructure() {
        DbStructureCollector collector = new DbStructureCollector();
        collector.visitLabel(1, "Person");
        collector.visitLabel(2, "City");
        collector.visitPropertyKey(1, "name");
        collector.visitPropertyKey(2, "income");
        collector.visitPropertyKey(3, "lastName");
        collector.visitPropertyKey(4, "tax");
        collector.visitPropertyKey(5, "area");
        collector.visitRelationshipType(1, "LIVES_IN");
        collector.visitRelationshipType(2, "FRIEND");
        collector.visitIndex(IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1, 3}), ":Person(name, lastName)", 1.0, 1L);
        collector.visitUniqueConstraint(ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{1, 5}), ":City(name, area)");
        collector.visitIndex(IndexDescriptorFactory.forLabel((int)2, (int[])new int[]{2, 4}), ":City(income, tax)", 0.2, 1L);
        collector.visitAllNodesCount(50L);
        collector.visitNodeCount(1, "Person", 20L);
        collector.visitNodeCount(2, "City", 30L);
        collector.visitRelCount(1, 2, -1, "(:Person)-[:FRIEND]->()", 500L);
        DbStructureLookup lookup = collector.lookup();
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"Person"), Pair.of((Object)2, (Object)"City")), (Object)Iterators.asList((Iterator)lookup.labels()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"name"), Pair.of((Object)2, (Object)"income"), Pair.of((Object)3, (Object)"lastName"), Pair.of((Object)4, (Object)"tax"), Pair.of((Object)5, (Object)"area")), (Object)Iterators.asList((Iterator)lookup.properties()));
        Assert.assertEquals(Arrays.asList(Pair.of((Object)1, (Object)"LIVES_IN"), Pair.of((Object)2, (Object)"FRIEND")), (Object)Iterators.asList((Iterator)lookup.relationshipTypes()));
        Assert.assertEquals(Arrays.asList("Person"), (Object)Iterators.asList((Iterator)Iterators.map(Pair::first, (Iterator)lookup.knownUniqueIndices())));
        Assert.assertArrayEquals((Object[])new String[]{"name", "lastName"}, (Object[])((Object[])((Pair)lookup.knownUniqueIndices().next()).other()));
        Assert.assertEquals(Arrays.asList("City"), (Object)Iterators.asList((Iterator)Iterators.map(Pair::first, (Iterator)lookup.knownUniqueConstraints())));
        Assert.assertArrayEquals((Object[])new String[]{"name", "area"}, (Object[])((Object[])((Pair)lookup.knownUniqueConstraints().next()).other()));
        Assert.assertEquals(Arrays.asList("City"), (Object)Iterators.asList((Iterator)Iterators.map(Pair::first, (Iterator)lookup.knownIndices())));
        Assert.assertArrayEquals((Object[])new String[]{"income", "tax"}, (Object[])((Object[])((Pair)lookup.knownIndices().next()).other()));
        Assert.assertEquals((long)50L, (long)lookup.nodesAllCardinality());
        Assert.assertEquals((long)20L, (long)lookup.nodesWithLabelCardinality(1));
        Assert.assertEquals((long)30L, (long)lookup.nodesWithLabelCardinality(2));
        Assert.assertEquals((long)500L, (long)lookup.cardinalityByLabelsAndRelationshipType(1, 2, -1));
        Assert.assertEquals((double)1.0, (double)lookup.indexSelectivity(1, new int[]{1, 3}), (double)0.01);
        Assert.assertEquals((double)0.2, (double)lookup.indexSelectivity(2, new int[]{2, 4}), (double)0.01);
    }
}

