/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.kernel.impl.api.DefaultTransactionTracer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DefaultCheckPointerTracer;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class TracersTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final SystemNanoClock clock = Clocks.nanoClock();
    private final Monitors monitors = new Monitors();
    private Log log;

    @Before
    public void setUp() {
        this.log = this.logProvider.getLog(this.getClass());
        System.setProperty("org.neo4j.helpers.Service.printServiceLoaderStackTraces", "true");
    }

    @Test
    public void mustProduceNullImplementationsWhenRequested() throws Exception {
        Tracers tracers = this.createTracers("null");
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.is((Object)PageCacheTracer.NULL));
        Assert.assertThat((Object)tracers.pageCursorTracerSupplier, (Matcher)Matchers.is((Object)PageCursorTracerSupplier.NULL));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.is((Object)TransactionTracer.NULL));
        this.assertNoWarning();
    }

    @Test
    public void mustProduceNullImplementationsWhenRequestedIgnoringCase() throws Exception {
        Tracers tracers = this.createTracers("NuLl");
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.is((Object)PageCacheTracer.NULL));
        Assert.assertThat((Object)tracers.pageCursorTracerSupplier, (Matcher)Matchers.is((Object)PageCursorTracerSupplier.NULL));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.is((Object)TransactionTracer.NULL));
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationForNullConfiguration() throws Exception {
        Tracers tracers = this.createTracers(null);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequested() throws Exception {
        Tracers tracers = this.createTracers("default");
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequestedIgnoringCase() throws Exception {
        Tracers tracers = this.createTracers("DeFaUlT");
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequestingUnknownImplementation() throws Exception {
        Tracers tracers = this.createTracers("there's nothing like this");
        this.assertDefaultImplementation(tracers);
        this.assertWarning("there's nothing like this");
    }

    private Tracers createTracers(String s) {
        return new Tracers(s, this.log, this.monitors, this.jobScheduler, this.clock);
    }

    private void assertDefaultImplementation(Tracers tracers) {
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.instanceOf(DefaultPageCacheTracer.class));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.instanceOf(DefaultTransactionTracer.class));
        Assert.assertThat((Object)tracers.checkPointTracer, (Matcher)Matchers.instanceOf(DefaultCheckPointerTracer.class));
        Assert.assertThat((Object)tracers.pageCursorTracerSupplier, (Matcher)Matchers.instanceOf(DefaultPageCursorTracerSupplier.class));
    }

    private void assertNoWarning() {
        this.logProvider.assertNoLoggingOccurred();
    }

    private void assertWarning(String implementationName) {
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).warn("Using default tracer implementations instead of '%s'", new Object[]{implementationName})});
    }
}

