/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.test.InputStreamAwaiter;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class InputStreamAwaiterTest {
    @Test
    public void shouldWaitForALineWithoutBlocking() throws Exception {
        FakeClock clock = this.getFakeClock();
        InputStream inputStream = (InputStream)Mockito.spy((Object)new MockInputStream(new Ticker(clock, 5L, TimeUnit.MILLISECONDS), InputStreamAwaiterTest.lines("important message")));
        InputStreamAwaiter awaiter = new InputStreamAwaiter((Clock)clock, inputStream);
        awaiter.awaitLine("important message", 5L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldTimeoutWhenDifferentContentProvided() throws Exception {
        FakeClock clock = this.getFakeClock();
        InputStream inputStream = (InputStream)Mockito.spy((Object)new MockInputStream(new Ticker(clock, 1L, TimeUnit.SECONDS), InputStreamAwaiterTest.lines("different content"), InputStreamAwaiterTest.lines("different message")));
        InputStreamAwaiter awaiter = new InputStreamAwaiter((Clock)clock, inputStream);
        try {
            awaiter.awaitLine("important message", 5L, TimeUnit.SECONDS);
            Assert.fail((String)"should have thrown exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void shouldTimeoutWhenNoContentProvided() throws Exception {
        FakeClock clock = this.getFakeClock();
        InputStream inputStream = (InputStream)Mockito.spy((Object)new MockInputStream(new Ticker(clock, 1L, TimeUnit.SECONDS), new String[0]));
        InputStreamAwaiter awaiter = new InputStreamAwaiter((Clock)clock, inputStream);
        try {
            awaiter.awaitLine("important message", 5L, TimeUnit.SECONDS);
            Assert.fail((String)"should have thrown exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private static String lines(String ... lines) {
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append(line).append(System.lineSeparator());
        }
        return result.toString();
    }

    private FakeClock getFakeClock() {
        return Clocks.fakeClock();
    }

    private static class MockInputStream
    extends InputStream {
        private final Ticker ticker;
        private final byte[][] chunks;
        private int chunk;

        MockInputStream(Ticker ticker, String ... chunks) {
            this.ticker = ticker;
            this.chunks = new byte[chunks.length][];
            for (int i = 0; i < chunks.length; ++i) {
                this.chunks[i] = chunks[i].getBytes();
            }
        }

        @Override
        public int available() throws IOException {
            this.ticker.tick();
            if (this.chunk >= this.chunks.length) {
                return 0;
            }
            return this.chunks[this.chunk].length;
        }

        @Override
        public int read(byte[] target) throws IOException {
            if (this.chunk >= this.chunks.length) {
                return 0;
            }
            byte[] source = this.chunks[this.chunk++];
            System.arraycopy(source, 0, target, 0, source.length);
            return source.length;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class Ticker {
        private FakeClock clock;
        private long duration;
        private TimeUnit timeUnit;

        Ticker(FakeClock clock, long duration, TimeUnit timeUnit) {
            this.clock = clock;
            this.duration = duration;
            this.timeUnit = timeUnit;
        }

        void tick() {
            this.clock.forward(this.duration, this.timeUnit);
        }
    }
}

