/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T getPrivateField(Object target, String fieldName, Class<T> fieldType) throws Exception {
        Class<?> type = target.getClass();
        Field field = ReflectionUtil.getField(fieldName, type);
        if (!fieldType.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Field type does not match " + field.getType() + " is no subclass of " + fieldType);
        }
        field.setAccessible(true);
        return fieldType.cast(field.get(target));
    }

    public static String verifyMethodExists(Class<?> owner, String methodName) {
        for (Method method : owner.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return methodName;
        }
        throw new IllegalArgumentException("Method '" + methodName + "' does not exist in class " + owner);
    }

    public static <T> void replaceValueInPrivateField(Object target, String fieldName, Class<T> fieldType, T value) throws Exception {
        Class<?> type = target.getClass();
        Field field = ReflectionUtil.getField(fieldName, type);
        if (!fieldType.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Field type does not match " + field.getType() + " is no subclass of " + fieldType);
        }
        field.setAccessible(true);
        field.set(target, value);
    }

    private static Field getField(String fieldName, Class<? extends Object> type) throws NoSuchFieldException {
        if (type == null) {
            throw new NoSuchFieldException(fieldName);
        }
        try {
            Field field = type.getDeclaredField(fieldName);
            if (field != null) {
                return field;
            }
        }
        catch (NoSuchFieldError | NoSuchFieldException throwable) {
            // empty catch block
        }
        return ReflectionUtil.getField(fieldName, type.getSuperclass());
    }
}

