/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class StreamConsumer
implements Runnable {
    public static StreamExceptionHandler PRINT_FAILURES = failure -> failure.printStackTrace();
    public static StreamExceptionHandler IGNORE_FAILURES = failure -> {};
    private final BufferedReader in;
    private final Writer out;
    private final boolean quiet;
    private final String prefix;
    private final StreamExceptionHandler failureHandler;
    private final Exception stackTraceOfOrigin;

    public StreamConsumer(InputStream in, OutputStream out, boolean quiet) {
        this(in, out, quiet, "", quiet ? IGNORE_FAILURES : PRINT_FAILURES);
    }

    public StreamConsumer(InputStream in, OutputStream out, boolean quiet, String prefix, StreamExceptionHandler failureHandler) {
        this.quiet = quiet;
        this.prefix = prefix;
        this.failureHandler = failureHandler;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new OutputStreamWriter(out);
        this.stackTraceOfOrigin = new Exception("Stack trace of thread that created this StreamConsumer");
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.in.readLine()) != null) {
                if (this.quiet) continue;
                this.out.write(this.prefix + line + "\n");
                this.out.flush();
            }
        }
        catch (IOException exc) {
            exc.addSuppressed(this.stackTraceOfOrigin);
            this.failureHandler.handle(exc);
        }
    }

    public static interface StreamExceptionHandler {
        public void handle(IOException var1);
    }
}

