/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.io.proc.ProcessUtil;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.subprocess.ConnectionDisruptedException;

public abstract class SubProcess<T, P>
implements Serializable {
    private static final long serialVersionUID = -6084373832996850958L;
    private static final boolean INHERIT_OUTPUT_DEFAULT_VALUE = true;
    private Class<T> t;
    private transient boolean inheritOutput = true;
    private final transient Predicate<String> classPathFilter;
    private volatile transient boolean alive;
    private static final Field PID;
    private int lastPid;
    private static PipeThread piper;
    private static Set<Handler> live;

    public SubProcess(Predicate<String> classPathFilter, boolean inheritOutput) {
        Class<NoInterface> t;
        this.inheritOutput = inheritOutput;
        if (this.getClass().getSuperclass() != SubProcess.class) {
            throw new ClassCastException(SubProcess.class.getName() + " may only be extended one level ");
        }
        Class<?> me = this.getClass();
        while (me.getSuperclass() != SubProcess.class) {
            me = me.getSuperclass();
        }
        Type type = ((ParameterizedType)me.getGenericSuperclass()).getActualTypeArguments()[0];
        if (type instanceof Class) {
            t = (Class<NoInterface>)((Object)type);
        } else if (type instanceof ParameterizedType) {
            t = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new ClassCastException("Illegal type parameter " + type);
        }
        if (t == Object.class) {
            t = NoInterface.class;
        }
        if (!t.isInterface()) {
            throw new ClassCastException(t + " is not an interface");
        }
        if (!t.isAssignableFrom(this.getClass()) && t != NoInterface.class) {
            throw new ClassCastException(this.getClass().getName() + " must implement declared interface " + t);
        }
        this.t = t;
        this.classPathFilter = classPathFilter;
    }

    public SubProcess() {
        this(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T start(P parameter) {
        Dispatcher dispatcher;
        String pid;
        Process process;
        DispatcherTrapImpl callback;
        try {
            callback = new DispatcherTrapImpl(this, parameter);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to create local RMI endpoint.", e);
        }
        try {
            String java = ProcessUtil.getJavaExecutable().toString();
            process = SubProcess.start(this.inheritOutput, java, "-ea", "-Xmx1G", "-Djava.awt.headless=true", "-cp", this.classPath(), SubProcess.class.getName(), SubProcess.serialize(callback));
            pid = this.getPid(process);
            if (!this.inheritOutput) {
                SubProcess.pipe("[" + this.toString() + ":" + pid + "] ", process.getErrorStream(), this.errorStreamTarget());
                SubProcess.pipe("[" + this.toString() + ":" + pid + "] ", process.getInputStream(), this.inputStreamTarget());
            }
            dispatcher = callback.get(process);
        }
        finally {
            try {
                UnicastRemoteObject.unexportObject(callback, true);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (dispatcher == null) {
            throw new IllegalStateException("failed to start sub process");
        }
        Handler handler = new Handler(this.t, dispatcher, process, "<" + this.toString() + ":" + pid + ">");
        return this.t.cast(Proxy.newProxyInstance(this.t.getClassLoader(), new Class[]{this.t}, SubProcess.live(handler)));
    }

    protected PrintStream errorStreamTarget() {
        return System.err;
    }

    protected PrintStream inputStreamTarget() {
        return System.out;
    }

    private String classPath() {
        if (this.classPathFilter == null) {
            return ProcessUtil.getClassPath();
        }
        Stream stream = ProcessUtil.getClassPathList().stream();
        return stream.filter(this.classPathFilter).collect(Collectors.joining(File.pathSeparator));
    }

    private static Process start(boolean inheritOutput, String ... args) {
        ProcessBuilder builder = new ProcessBuilder(args);
        if (inheritOutput) {
            builder.redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        try {
            return builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start sub process", e);
        }
    }

    protected abstract void startup(P var1) throws Throwable;

    public final void shutdown() {
        this.shutdown(true);
    }

    protected void shutdown(boolean normal) {
        System.exit(0);
    }

    public static void stop(Object subprocess) {
        ((Handler)Proxy.getInvocationHandler(subprocess)).stop(null, 0L);
    }

    public static void stop(Object subprocess, long timeout, TimeUnit unit) {
        ((Handler)Proxy.getInvocationHandler(subprocess)).stop(unit, timeout);
    }

    public static void kill(Object subprocess) {
        ((Handler)Proxy.getInvocationHandler(subprocess)).kill(true);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static void main(String[] args) throws Throwable {
        if (args.length != 1) {
            throw new IllegalArgumentException("Needs to be started from " + SubProcess.class.getName());
        }
        DispatcherTrap trap = SubProcess.deserialize(args[0]);
        SubProcess<?, Object> subProcess = trap.getSubProcess();
        super.doStart(trap.trap(new DispatcherImpl(subProcess)));
    }

    private void doStart(P parameter) throws Throwable {
        this.alive = true;
        this.startup(parameter);
        this.liveLoop();
    }

    private void doStop(boolean normal) {
        this.alive = false;
        this.shutdown(normal);
    }

    private void liveLoop() throws Exception {
        while (this.alive) {
            for (int i = System.in.available(); i >= 0; --i) {
                if (System.in.read() == -1) {
                    this.doStop(false);
                }
                Thread.sleep(1L);
            }
        }
    }

    private String getPid(Process process) {
        if (PID != null) {
            try {
                return PID.get(process).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.toString(this.lastPid++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(String prefix, InputStream source, PrintStream target) {
        Class<PipeThread> clazz = PipeThread.class;
        synchronized (PipeThread.class) {
            if (piper == null) {
                piper = new PipeThread();
                piper.start();
            }
            SubProcess.piper.tasks.add(new PipeTask(prefix, source, target));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static String serialize(DispatcherTrapImpl obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(RemoteObject.toStub(obj));
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Broken implementation!", e);
        }
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    private static DispatcherTrap deserialize(String data) throws Exception {
        return (DispatcherTrap)new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(data))).readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InvocationHandler live(Handler handler) {
        try {
            Class<Handler> clazz = Handler.class;
            synchronized (Handler.class) {
                if (live == null) {
                    live = new HashSet<Handler>();
                    final HashSet<Handler> handlers = live;
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            SubProcess.killAll(handlers);
                        }
                    });
                }
                live.add(handler);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (UnsupportedOperationException e) {
            handler.kill(false);
            throw new IllegalStateException("JVM is shutting down!");
        }
        {
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dead(Handler handler) {
        Class<Handler> clazz = Handler.class;
        synchronized (Handler.class) {
            try {
                if (live != null) {
                    live.remove(handler);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void killAll(Set<Handler> handlers) {
        Class<Handler> clazz = Handler.class;
        synchronized (Handler.class) {
            if (!handlers.isEmpty()) {
                for (Handler handler : handlers) {
                    try {
                        handler.process.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        handler.kill(false);
                    }
                }
            }
            live = Collections.emptySet();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        Field pid;
        try {
            pid = Class.forName("java.lang.UNIXProcess").getDeclaredField("pid");
            pid.setAccessible(true);
        }
        catch (Throwable ex) {
            pid = null;
        }
        PID = pid;
    }

    private static class DispatcherImpl
    extends UnicastRemoteObject
    implements Dispatcher {
        private final transient SubProcess<?, ?> subprocess;

        protected DispatcherImpl(SubProcess<?, ?> subprocess) throws RemoteException {
            this.subprocess = subprocess;
        }

        @Override
        public Object dispatch(String name, String[] types, Object[] args) throws Throwable {
            Class[] params = new Class[types.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = Class.forName(types[i]);
            }
            try {
                return ((SubProcess)this.subprocess).t.getMethod(name, params).invoke(this.subprocess, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        @Override
        public void stop() throws RemoteException {
            ((SubProcess)this.subprocess).doStop(true);
        }
    }

    private static class Handler
    implements InvocationHandler {
        private final Dispatcher dispatcher;
        private final Process process;
        private final Class<?> type;
        private final String repr;

        Handler(Class<?> type, Dispatcher dispatcher, Process process, String repr) {
            this.type = type;
            this.dispatcher = dispatcher;
            this.process = process;
            this.repr = repr;
        }

        public String toString() {
            return this.repr;
        }

        void kill(boolean wait) {
            this.process.destroy();
            if (wait) {
                SubProcess.dead(this);
                Handler.await(this.process);
            }
        }

        int stop(TimeUnit unit, long timeout) {
            final CountDownLatch latch = new CountDownLatch(unit == null ? 0 : 1);
            Thread stopper = new Thread(){

                @Override
                public void run() {
                    latch.countDown();
                    try {
                        dispatcher.stop();
                    }
                    catch (RemoteException e) {
                        process.destroy();
                    }
                }
            };
            stopper.start();
            try {
                latch.await();
                timeout = System.currentTimeMillis() + (unit == null ? 0L : unit.toMillis(timeout));
                while (stopper.isAlive() && System.currentTimeMillis() < timeout) {
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (stopper.isAlive()) {
                stopper.interrupt();
            }
            SubProcess.dead(this);
            return Handler.await(this.process);
        }

        private static int await(Process process) {
            return new ProcessStreamHandler(process, true).waitForResult();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass() == this.type) {
                    return this.dispatch(method, args);
                }
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                throw new UnsupportedOperationException(method.toString());
            }
            catch (ServerError ex) {
                throw ex.detail;
            }
            catch (RemoteException ex) {
                throw new ConnectionDisruptedException(ex);
            }
        }

        private Object dispatch(Method method, Object[] args) throws Throwable {
            Class<?>[] params = method.getParameterTypes();
            String[] types = new String[params.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = params[i].getName();
            }
            return this.dispatcher.dispatch(method.getName(), types, args);
        }
    }

    private static interface Dispatcher
    extends Remote {
        public void stop() throws RemoteException;

        public Object dispatch(String var1, String[] var2, Object[] var3) throws Throwable;
    }

    private static class DispatcherTrapImpl
    extends UnicastRemoteObject
    implements DispatcherTrap {
        private Object parameter;
        private volatile Dispatcher dispatcher;
        private SubProcess<?, ?> process;

        DispatcherTrapImpl(SubProcess<?, ?> process, Object parameter) throws RemoteException {
            this.process = process;
            this.parameter = parameter;
        }

        Dispatcher get(Process process) {
            while (this.dispatcher == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    continue;
                }
                return null;
            }
            return this.dispatcher;
        }

        @Override
        public synchronized Object trap(Dispatcher dispatcher) {
            if (this.dispatcher != null) {
                throw new IllegalStateException("Dispatcher already trapped!");
            }
            this.dispatcher = dispatcher;
            return this.parameter;
        }

        @Override
        public SubProcess<?, Object> getSubProcess() {
            return this.process;
        }
    }

    private static interface DispatcherTrap
    extends Remote {
        public Object trap(Dispatcher var1) throws RemoteException;

        public SubProcess<?, Object> getSubProcess() throws RemoteException;
    }

    private static class PipeThread
    extends Thread {
        final CopyOnWriteArrayList<PipeTask> tasks;

        private PipeThread() {
            this.setName(this.getClass().getSimpleName());
            this.tasks = new CopyOnWriteArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                ArrayList<PipeTask> done = new ArrayList<PipeTask>();
                for (PipeTask task : this.tasks) {
                    if (task.pipe()) continue;
                    done.add(task);
                }
                if (!done.isEmpty()) {
                    this.tasks.removeAll(done);
                }
                if (this.tasks.isEmpty()) {
                    Class<PipeThread> clazz = PipeThread.class;
                    // MONITORENTER : org.neo4j.test.subprocess.SubProcess$PipeThread.class
                    if (this.tasks.isEmpty()) {
                        piper = null;
                        // MONITOREXIT : clazz
                        return;
                    }
                    // MONITOREXIT : clazz
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }
    }

    private static class PipeTask {
        private final String prefix;
        private final InputStream source;
        private final PrintStream target;
        private StringBuilder line;

        PipeTask(String prefix, InputStream source, PrintStream target) {
            this.prefix = prefix;
            this.source = source;
            this.target = target;
            this.line = new StringBuilder();
        }

        boolean pipe() {
            try {
                byte[] data = new byte[Math.max(1, this.source.available())];
                int bytesRead = this.source.read(data);
                if (bytesRead == -1) {
                    this.printLastLine();
                    return false;
                }
                if (bytesRead < data.length) {
                    data = Arrays.copyOf(data, bytesRead);
                }
                ByteBuffer chars = ByteBuffer.wrap(data);
                while (chars.hasRemaining()) {
                    char c = (char)chars.get();
                    this.line.append(c);
                    if (c != '\n') continue;
                    this.print();
                }
            }
            catch (IOException e) {
                this.printLastLine();
                return false;
            }
            return true;
        }

        private void printLastLine() {
            if (this.line.length() > 0) {
                this.line.append('\n');
                this.print();
            }
        }

        private void print() {
            this.target.print(this.prefix + this.line.toString());
            this.line = new StringBuilder();
        }
    }

    private static interface NoInterface {
    }
}

