/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.CollectionMatcher;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.internal.BatchInserterImpl;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class BatchInsertTest {
    private final int denseNodeThreshold;
    private static final IndexDescriptor internalIndex = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private static final IndexDescriptor internalUniqueIndex = IndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{0});
    private static Map<String, Object> properties = new HashMap<String, Object>();
    private static RelationshipType[] relTypeArray = new RelationshipType[]{RelTypes.REL_TYPE1, RelTypes.REL_TYPE2, RelTypes.REL_TYPE3, RelTypes.REL_TYPE4, RelTypes.REL_TYPE5};
    @ClassRule
    public static TestDirectory globalStoreDir;
    @ClassRule
    public static DefaultFileSystemRule fileSystemRule;
    @Rule
    public TestDirectory storeDir = TestDirectory.testDirectory(this.getClass());
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private static BatchInserter globalInserter;

    @Parameterized.Parameters
    public static Collection<Integer> data() {
        return Arrays.asList(5, Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue()));
    }

    public BatchInsertTest(int denseNodeThreshold) {
        this.denseNodeThreshold = denseNodeThreshold;
    }

    @BeforeClass
    public static void startGlobalInserter() throws IOException {
        globalInserter = BatchInserters.inserter((File)globalStoreDir.directory("global"), (FileSystemAbstraction)fileSystemRule.get(), (Map)MapUtil.stringMap((String[])new String[0]));
    }

    @After
    public void flushGlobalInserter() {
        this.forceFlush(globalInserter);
    }

    @AfterClass
    public static void shutDownGlobalInserter() throws Exception {
        globalInserter.shutdown();
    }

    private Map<String, String> configuration() {
        return MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(this.denseNodeThreshold)});
    }

    private BatchInserter newBatchInserter() throws Exception {
        return BatchInserters.inserter((File)this.storeDir.absolutePath(), (FileSystemAbstraction)fileSystemRule.get(), this.configuration());
    }

    private BatchInserter newBatchInserterWithSchemaIndexProvider(KernelExtensionFactory<?> provider) throws Exception {
        return BatchInserters.inserter((File)this.storeDir.absolutePath(), (FileSystemAbstraction)fileSystemRule.get(), this.configuration(), Collections.singletonList(provider));
    }

    private GraphDatabaseService switchToEmbeddedGraphDatabaseService(BatchInserter inserter) {
        inserter.shutdown();
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem(fileSystemRule.get());
        GraphDatabaseService db = factory.newImpermanentDatabaseBuilder(new File(inserter.getStoreDir())).setConfig(this.configuration()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        return db;
    }

    @Test
    public void shouldUpdateStringArrayPropertiesOnNodesUsingBatchInserter1() throws Exception {
        BatchInserter inserter = globalInserter;
        String[] array1 = new String[]{"1"};
        String[] array2 = new String[]{"a"};
        long id1 = inserter.createNode(MapUtil.map((Object[])new Object[]{"array", array1}), new Label[0]);
        long id2 = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[0]);
        inserter.getNodeProperties(id1).get("array");
        inserter.setNodeProperty(id1, "array", (Object)array1);
        inserter.setNodeProperty(id2, "array", (Object)array2);
        inserter.getNodeProperties(id1).get("array");
        inserter.setNodeProperty(id1, "array", (Object)array1);
        inserter.setNodeProperty(id2, "array", (Object)array2);
        Assert.assertThat(inserter.getNodeProperties(id1).get("array"), (Matcher)CoreMatchers.equalTo((Object)array1));
    }

    @Test
    public void testSimple() throws Exception {
        BatchInserter graphDb = globalInserter;
        long node1 = graphDb.createNode(null, new Label[0]);
        long node2 = graphDb.createNode(null, new Label[0]);
        long rel1 = graphDb.createRelationship(node1, node2, (RelationshipType)RelTypes.BATCH_TEST, null);
        BatchRelationship rel = graphDb.getRelationshipById(rel1);
        Assert.assertEquals((long)rel.getStartNode(), (long)node1);
        Assert.assertEquals((long)rel.getEndNode(), (long)node2);
        Assert.assertEquals((Object)RelTypes.BATCH_TEST.name(), (Object)rel.getType().name());
    }

    @Test
    public void testSetAndAddNodeProperties() throws Exception {
        BatchInserter inserter = globalInserter;
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"one", "one", "two", "two", "three", "three"}), new Label[0]);
        inserter.setNodeProperty(tehNode, "four", (Object)"four");
        inserter.setNodeProperty(tehNode, "five", (Object)"five");
        Map<String, Object> props = this.getNodeProperties(inserter, tehNode);
        Assert.assertEquals((long)5L, (long)props.size());
        Assert.assertEquals((Object)"one", (Object)props.get("one"));
        Assert.assertEquals((Object)"five", (Object)props.get("five"));
    }

    @Test
    public void setSingleProperty() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        long node = inserter.createNode(null, new Label[0]);
        String value = "Something";
        String key = "name";
        inserter.setNodeProperty(node, key, (Object)value);
        GraphDatabaseService db = this.switchToEmbeddedGraphDatabaseService(inserter);
        Assert.assertThat((Object)this.getNodeInTx(node, db), Neo4jMatchers.inTx(db, Neo4jMatchers.hasProperty(key).withValue(value)));
        db.shutdown();
    }

    @Test
    public void testSetAndKeepNodeProperty() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"foo", "bar"}), new Label[0]);
        inserter.setNodeProperty(tehNode, "foo2", (Object)"bar2");
        Map<String, Object> props = this.getNodeProperties(inserter, tehNode);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter();
        props = this.getNodeProperties(inserter, tehNode);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.setNodeProperty(tehNode, "foo", (Object)"bar3");
        props = this.getNodeProperties(inserter, tehNode);
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter();
        props = this.getNodeProperties(inserter, tehNode);
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
    }

    @Test
    public void testSetAndKeepRelationshipProperty() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        long from = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long to = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long theRel = inserter.createRelationship(from, to, RelationshipType.withName((String)"TestingPropsHere"), MapUtil.map((Object[])new Object[]{"foo", "bar"}));
        inserter.setRelationshipProperty(theRel, "foo2", (Object)"bar2");
        Map<String, Object> props = this.getRelationshipProperties(inserter, theRel);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter();
        props = this.getRelationshipProperties(inserter, theRel);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.setRelationshipProperty(theRel, "foo", (Object)"bar3");
        props = this.getRelationshipProperties(inserter, theRel);
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter();
        props = this.getRelationshipProperties(inserter, theRel);
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", (Object)props.get("foo"));
        Assert.assertEquals((Object)"bar2", (Object)props.get("foo2"));
        inserter.shutdown();
    }

    @Test
    public void testNodeHasProperty() throws Exception {
        BatchInserter inserter = globalInserter;
        long theNode = inserter.createNode(properties, new Label[0]);
        long anotherNode = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long relationship = inserter.createRelationship(theNode, anotherNode, RelationshipType.withName((String)"foo"), properties);
        for (String key : properties.keySet()) {
            Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assert.assertFalse((boolean)inserter.nodeHasProperty(theNode, key + "-"));
            Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
            Assert.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key + "-"));
        }
    }

    @Test
    public void testRemoveProperties() throws Exception {
        String key;
        BatchInserter inserter = this.newBatchInserter();
        long theNode = inserter.createNode(properties, new Label[0]);
        long anotherNode = inserter.createNode(Collections.emptyMap(), new Label[0]);
        long relationship = inserter.createRelationship(theNode, anotherNode, RelationshipType.withName((String)"foo"), properties);
        inserter.removeNodeProperty(theNode, "key0");
        inserter.removeRelationshipProperty(relationship, "key1");
        Iterator<String> iterator = properties.keySet().iterator();
        block16: while (iterator.hasNext()) {
            switch (key = iterator.next()) {
                case "key0": {
                    Assert.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                    Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block16;
                }
                case "key1": {
                    Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                    Assert.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block16;
                }
            }
            Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
        inserter = this.newBatchInserter();
        iterator = properties.keySet().iterator();
        block17: while (iterator.hasNext()) {
            switch (key = iterator.next()) {
                case "key0": {
                    Assert.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                    Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block17;
                }
                case "key1": {
                    Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                    Assert.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                    continue block17;
                }
            }
            Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
    }

    @Test
    public void shouldBeAbleToRemoveDynamicProperty() throws Exception {
        BatchInserter batchInserter = globalInserter;
        String key = "tags";
        long nodeId = batchInserter.createNode(MapUtil.map((Object[])new Object[]{key, new String[]{"one", "two", "three"}}), new Label[0]);
        batchInserter.removeNodeProperty(nodeId, key);
        Assert.assertFalse((boolean)batchInserter.getNodeProperties(nodeId).containsKey(key));
    }

    @Test
    public void shouldBeAbleToOverwriteDynamicProperty() throws Exception {
        BatchInserter batchInserter = globalInserter;
        String key = "tags";
        long nodeId = batchInserter.createNode(MapUtil.map((Object[])new Object[]{key, new String[]{"one", "two", "three"}}), new Label[0]);
        Object[] secondValue = new String[]{"four", "five", "six"};
        batchInserter.setNodeProperty(nodeId, key, (Object)secondValue);
        Assert.assertTrue((boolean)Arrays.equals(secondValue, (String[])this.getNodeProperties(batchInserter, nodeId).get(key)));
    }

    @Test
    public void testMore() throws Exception {
        BatchInserter graphDb = globalInserter;
        long startNode = graphDb.createNode(properties, new Label[0]);
        long[] endNodes = new long[25];
        HashSet<Long> rels = new HashSet<Long>();
        for (int i = 0; i < 25; ++i) {
            endNodes[i] = graphDb.createNode(properties, new Label[0]);
            rels.add(graphDb.createRelationship(startNode, endNodes[i], relTypeArray[i % 5], properties));
        }
        for (BatchRelationship rel : graphDb.getRelationships(startNode)) {
            Assert.assertTrue((boolean)rels.contains(rel.getId()));
            Assert.assertEquals((long)rel.getStartNode(), (long)startNode);
        }
        graphDb.setNodeProperties(startNode, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureLoopsCanBeCreated() throws Exception {
        BatchInserter graphDb = this.newBatchInserter();
        long startNode = graphDb.createNode(properties, new Label[0]);
        long otherNode = graphDb.createNode(properties, new Label[0]);
        long selfRelationship = graphDb.createRelationship(startNode, startNode, relTypeArray[0], properties);
        long relationship = graphDb.createRelationship(startNode, otherNode, relTypeArray[0], properties);
        for (BatchRelationship rel : graphDb.getRelationships(startNode)) {
            if (rel.getId() == selfRelationship) {
                Assert.assertEquals((long)startNode, (long)rel.getStartNode());
                Assert.assertEquals((long)startNode, (long)rel.getEndNode());
                continue;
            }
            if (rel.getId() == relationship) {
                Assert.assertEquals((long)startNode, (long)rel.getStartNode());
                Assert.assertEquals((long)otherNode, (long)rel.getEndNode());
                continue;
            }
            Assert.fail((String)("Unexpected relationship " + rel.getId()));
        }
        GraphDatabaseService db = this.switchToEmbeddedGraphDatabaseService(graphDb);
        try (Transaction ignored = db.beginTx();){
            Node realStartNode = db.getNodeById(startNode);
            Relationship realSelfRelationship = db.getRelationshipById(selfRelationship);
            Relationship realRelationship = db.getRelationshipById(relationship);
            Assert.assertEquals((Object)realSelfRelationship, (Object)realStartNode.getSingleRelationship((RelationshipType)RelTypes.REL_TYPE1, Direction.INCOMING));
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{realSelfRelationship, realRelationship}), (Object)Iterables.asSet((Iterable)realStartNode.getRelationships(Direction.OUTGOING)));
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Relationship[]{realSelfRelationship, realRelationship}), (Object)Iterables.asSet((Iterable)realStartNode.getRelationships()));
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void createBatchNodeAndRelationshipsDeleteAllInEmbedded() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        long nodeId = inserter.createNode(null, new Label[0]);
        inserter.createRelationship(nodeId, inserter.createNode(null, new Label[0]), (RelationshipType)RelTypes.BATCH_TEST, null);
        inserter.createRelationship(inserter.createNode(null, new Label[0]), nodeId, (RelationshipType)RelTypes.REL_TYPE1, null);
        GraphDatabaseService db = this.switchToEmbeddedGraphDatabaseService(inserter);
        try (Transaction tx = db.beginTx();){
            Node node = db.getNodeById(nodeId);
            for (Relationship relationship : node.getRelationships()) {
                relationship.delete();
            }
            node.delete();
            tx.success();
        }
        db.shutdown();
    }

    @Test
    public void messagesLogGetsClosed() throws Exception {
        File storeDir = this.storeDir.graphDbDir();
        BatchInserter inserter = BatchInserters.inserter((File)storeDir, (FileSystemAbstraction)fileSystemRule.get(), (Map)MapUtil.stringMap((String[])new String[0]));
        inserter.shutdown();
        Assert.assertTrue((boolean)new File(storeDir, "debug.log").delete());
    }

    @Test
    public void createEntitiesWithEmptyPropertiesMap() throws Exception {
        BatchInserter inserter = globalInserter;
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[0]);
        this.getNodeProperties(inserter, nodeId);
        long anotherNodeId = inserter.createNode(null, new Label[0]);
        long relId = inserter.createRelationship(nodeId, anotherNodeId, (RelationshipType)RelTypes.BATCH_TEST, MapUtil.map((Object[])new Object[0]));
        inserter.getRelationshipProperties(relId);
    }

    @Test
    public void createEntitiesWithDynamicPropertiesMap() throws Exception {
        BatchInserter inserter = globalInserter;
        this.setAndGet(inserter, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.setAndGet(inserter, this.intArray());
    }

    @Test
    public void shouldAddInitialLabelsToCreatedNode() throws Exception {
        BatchInserter inserter = globalInserter;
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST, Labels.SECOND});
        Assert.assertTrue((boolean)inserter.nodeHasLabel(node, (Label)Labels.FIRST));
        Assert.assertTrue((boolean)inserter.nodeHasLabel(node, (Label)Labels.SECOND));
        Assert.assertFalse((boolean)inserter.nodeHasLabel(node, (Label)Labels.THIRD));
    }

    @Test
    public void shouldGetNodeLabels() throws Exception {
        BatchInserter inserter = globalInserter;
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST, Labels.THIRD});
        Iterable<String> labelNames = this.asNames(inserter.getNodeLabels(node));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{Labels.FIRST.name(), Labels.THIRD.name()}), (Object)Iterables.asSet(labelNames));
    }

    @Test
    public void shouldAddManyInitialLabelsAsDynamicRecords() throws Exception {
        BatchInserter inserter = globalInserter;
        Pair<Label[], Set<String>> labels = this.manyLabels(200);
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), (Label[])labels.first());
        this.forceFlush(inserter);
        Iterable<String> labelNames = this.asNames(inserter.getNodeLabels(node));
        Assert.assertEquals((Object)labels.other(), (Object)Iterables.asSet(labelNames));
    }

    @Test
    public void shouldReplaceExistingInlinedLabelsWithDynamic() throws Exception {
        BatchInserter inserter = globalInserter;
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[]{Labels.FIRST});
        Pair<Label[], Set<String>> labels = this.manyLabels(100);
        inserter.setNodeLabels(node, (Label[])labels.first());
        Iterable<String> labelNames = this.asNames(inserter.getNodeLabels(node));
        Assert.assertEquals((Object)labels.other(), (Object)Iterables.asSet(labelNames));
    }

    @Test
    public void shouldReplaceExistingDynamicLabelsWithInlined() throws Exception {
        BatchInserter inserter = globalInserter;
        long node = inserter.createNode(MapUtil.map((Object[])new Object[0]), (Label[])this.manyLabels(150).first());
        inserter.setNodeLabels(node, new Label[]{Labels.FIRST});
        Iterable<String> labelNames = this.asNames(inserter.getNodeLabels(node));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{Labels.FIRST.name()}), (Object)Iterables.asSet(labelNames));
    }

    @Test
    public void shouldCreateDeferredSchemaIndexesInEmptyDatabase() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        IndexDefinition definition = inserter.createDeferredSchemaIndex(Label.label((String)"Hacker")).on("handle").create();
        Assert.assertEquals((Object)"Hacker", (Object)definition.getLabel().name());
        Assert.assertEquals((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object)"handle")), (Object)Iterables.asCollection((Iterable)definition.getPropertyKeys()));
        inserter.shutdown();
    }

    @Test
    public void shouldCreateDeferredUniquenessConstraintInEmptyDatabase() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        ConstraintDefinition definition = inserter.createDeferredConstraint(Label.label((String)"Hacker")).assertPropertyIsUnique("handle").create();
        Assert.assertEquals((Object)"Hacker", (Object)definition.getLabel().name());
        Assert.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)definition.getConstraintType());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"handle"}), (Object)Iterables.asSet((Iterable)definition.getPropertyKeys()));
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateConsistentUniquenessConstraint() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        inserter.createDeferredConstraint(Label.label((String)"Hacker")).assertPropertyIsUnique("handle").create();
        GraphDatabaseAPI graphdb = (GraphDatabaseAPI)this.switchToEmbeddedGraphDatabaseService(inserter);
        try {
            ConstraintRule constraintRule;
            IndexRule indexRule;
            NeoStores neoStores = ((RecordStorageEngine)graphdb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
            SchemaStore store = neoStores.getSchemaStore();
            SchemaStorage storage = new SchemaStorage((RecordStore)store);
            ArrayList<Long> inUse = new ArrayList<Long>();
            DynamicRecord record = store.nextRecord();
            long high = store.getHighestPossibleIdInUse();
            for (long i = 1L; i <= high; ++i) {
                store.getRecord(i, (AbstractBaseRecord)record, RecordLoad.FORCE);
                if (!record.inUse() || !record.isStartRecord()) continue;
                inUse.add(i);
            }
            Assert.assertEquals((String)"records in use", (long)2L, (long)inUse.size());
            SchemaRule rule0 = storage.loadSingleSchemaRule(((Long)inUse.get(0)).longValue());
            SchemaRule rule1 = storage.loadSingleSchemaRule(((Long)inUse.get(1)).longValue());
            if (rule0 instanceof IndexRule) {
                indexRule = (IndexRule)rule0;
                constraintRule = (ConstraintRule)rule1;
            } else {
                constraintRule = (ConstraintRule)rule0;
                indexRule = (IndexRule)rule1;
            }
            Assert.assertEquals((String)"index should reference constraint", (long)constraintRule.getId(), (long)indexRule.getOwningConstraint());
            Assert.assertEquals((String)"constraint should reference index", (long)indexRule.getId(), (long)constraintRule.getOwnedIndex());
        }
        finally {
            graphdb.shutdown();
        }
    }

    @Test
    public void shouldNotAllowCreationOfDuplicateIndex() throws Exception {
        BatchInserter inserter = globalInserter;
        String labelName = "Hacker1-" + this.denseNodeThreshold;
        inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create();
        try {
            inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create();
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCreationOfDuplicateConstraint() throws Exception {
        BatchInserter inserter = globalInserter;
        String labelName = "Hacker2-" + this.denseNodeThreshold;
        inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create();
        try {
            inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create();
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCreationOfDeferredSchemaConstraintAfterIndexOnSameKeys() throws Exception {
        BatchInserter inserter = globalInserter;
        String labelName = "Hacker3-" + this.denseNodeThreshold;
        inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create();
        try {
            inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create();
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowCreationOfDeferredSchemaIndexAfterConstraintOnSameKeys() throws Exception {
        BatchInserter inserter = globalInserter;
        String labelName = "Hacker4-" + this.denseNodeThreshold;
        inserter.createDeferredConstraint(Label.label((String)labelName)).assertPropertyIsUnique("handle").create();
        try {
            inserter.createDeferredSchemaIndex(Label.label((String)labelName)).on("handle").create();
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldRunIndexPopulationJobAtShutdown() throws Throwable {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        BatchInserter inserter = this.newBatchInserterWithSchemaIndexProvider(SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("in-memory-index", provider));
        inserter.createDeferredSchemaIndex(Label.label((String)"Hacker")).on("handle").create();
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "Jakewins"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).init();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).start();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).add((Collection)Matchers.argThat(CollectionMatcher.matchesCollection(IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)internalIndex.schema(), (Value[])new Value[]{Values.of((Object)"Jakewins")}))));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((PropertyAccessor)Matchers.any(PropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).stop();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).shutdown();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{populator});
    }

    @Test
    public void shouldRunConstraintPopulationJobAtShutdown() throws Throwable {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        BatchInserter inserter = this.newBatchInserterWithSchemaIndexProvider(SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("in-memory-index", provider));
        inserter.createDeferredConstraint(Label.label((String)"Hacker")).assertPropertyIsUnique("handle").create();
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "Jakewins"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).init();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).start();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).add((Collection)Matchers.argThat(CollectionMatcher.matchesCollection(IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)internalUniqueIndex.schema(), (Value[])new Value[]{Values.of((Object)"Jakewins")}))));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((PropertyAccessor)Matchers.any(PropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).stop();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).shutdown();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{populator});
    }

    @Test
    public void shouldRepopulatePreexistingIndexed() throws Throwable {
        long jakewins = this.dbWithIndexAndSingleIndexedNode();
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        BatchInserter inserter = this.newBatchInserterWithSchemaIndexProvider(SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("in-memory-index", provider));
        long boggle = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "b0ggl3"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).init();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).start();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).add((Collection)Matchers.argThat(CollectionMatcher.matchesCollection(IndexEntryUpdate.add((long)jakewins, (LabelSchemaSupplier)internalIndex.schema(), (Value[])new Value[]{Values.of((Object)"Jakewins")}), IndexEntryUpdate.add((long)boggle, (LabelSchemaSupplier)internalIndex.schema(), (Value[])new Value[]{Values.of((Object)"b0ggl3")}))));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((PropertyAccessor)Matchers.any(PropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).stop();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).shutdown();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{populator});
    }

    @Test
    public void shouldPopulateLabelScanStoreOnShutdown() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        long node1 = inserter.createNode(null, new Label[]{Labels.FIRST});
        long node2 = inserter.createNode(null, new Label[]{Labels.SECOND});
        long node3 = inserter.createNode(null, new Label[]{Labels.THIRD});
        long node4 = inserter.createNode(null, new Label[]{Labels.FIRST, Labels.SECOND});
        long node5 = inserter.createNode(null, new Label[]{Labels.FIRST, Labels.THIRD});
        LabelScanStore labelScanStore = this.getLabelScanStore();
        inserter.shutdown();
        labelScanStore.init();
        labelScanStore.start();
        this.assertLabelScanStoreContains(labelScanStore, 0, node1, node4, node5);
        this.assertLabelScanStoreContains(labelScanStore, 1, node2, node4);
        this.assertLabelScanStoreContains(labelScanStore, 2, node3, node5);
        labelScanStore.shutdown();
    }

    @Test
    public void propertiesCanBeReSetUsingBatchInserter() throws Exception {
        BatchInserter batchInserter = globalInserter;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "One");
        props.put("count", 1);
        props.put("tags", new String[]{"one", "two"});
        props.put("something", "something");
        long nodeId = batchInserter.createNode(props, new Label[0]);
        batchInserter.setNodeProperty(nodeId, "name", (Object)"NewOne");
        batchInserter.removeNodeProperty(nodeId, "count");
        batchInserter.removeNodeProperty(nodeId, "something");
        batchInserter.setNodeProperty(nodeId, "name", (Object)"YetAnotherOne");
        batchInserter.setNodeProperty(nodeId, "additional", (Object)"something");
        Assert.assertEquals((Object)"YetAnotherOne", batchInserter.getNodeProperties(nodeId).get("name"));
        Assert.assertEquals((Object)"something", batchInserter.getNodeProperties(nodeId).get("additional"));
    }

    @Test
    public void testCleanupEmptyPropertyRecords() throws Exception {
        BatchInserter inserter = globalInserter;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", 1099511659993L);
        properties.put("firstName", "Edward");
        properties.put("lastName", "Shevchenko");
        properties.put("gender", "male");
        properties.put("birthday", new SimpleDateFormat("yyyy-MM-dd").parse("1987-11-08").getTime());
        properties.put("birthday_month", 11);
        properties.put("birthday_day", 8);
        long time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse("2010-04-22T18:05:40.912+0000").getTime();
        properties.put("creationDate", time);
        properties.put("locationIP", "46.151.255.205");
        properties.put("browserUsed", "Firefox");
        properties.put("email", new String[0]);
        properties.put("languages", new String[0]);
        long personNodeId = inserter.createNode(properties, new Label[0]);
        Assert.assertEquals((Object)"Shevchenko", (Object)this.getNodeProperties(inserter, personNodeId).get("lastName"));
        Assert.assertThat((Object)((String[])this.getNodeProperties(inserter, personNodeId).get("email")), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.emptyArray()));
        inserter.setNodeProperty(personNodeId, "email", (Object)new String[]{"Edward1099511659993@gmail.com"});
        Assert.assertThat((Object)((String[])this.getNodeProperties(inserter, personNodeId).get("email")), (Matcher)org.hamcrest.Matchers.arrayContaining((Object[])new String[]{"Edward1099511659993@gmail.com"}));
        inserter.setNodeProperty(personNodeId, "email", (Object)new String[]{"Edward1099511659993@gmail.com", "backup@gmail.com"});
        Assert.assertThat((Object)((String[])this.getNodeProperties(inserter, personNodeId).get("email")), (Matcher)org.hamcrest.Matchers.arrayContaining((Object[])new String[]{"Edward1099511659993@gmail.com", "backup@gmail.com"}));
    }

    @Test
    public void propertiesCanBeReSetUsingBatchInserter2() throws Exception {
        BatchInserter batchInserter = globalInserter;
        long id = batchInserter.createNode(new HashMap(), new Label[0]);
        batchInserter.setNodeProperty(id, "test", (Object)"looooooooooong test");
        batchInserter.setNodeProperty(id, "test", (Object)"small test");
        Assert.assertEquals((Object)"small test", batchInserter.getNodeProperties(id).get("test"));
    }

    @Test
    public void replaceWithBiggerPropertySpillsOverIntoNewPropertyRecord() throws Exception {
        BatchInserter batchInserter = globalInserter;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "One");
        props.put("count", 1);
        props.put("tags", new String[]{"one", "two"});
        long id = batchInserter.createNode(props, new Label[0]);
        batchInserter.setNodeProperty(id, "name", (Object)"NewOne");
        batchInserter.setNodeProperty(id, "count", (Object)"something");
        Assert.assertEquals((Object)"something", batchInserter.getNodeProperties(id).get("count"));
    }

    @Test
    public void mustSplitUpRelationshipChainsWhenCreatingDenseNodes() throws Exception {
        BatchInserter inserter = globalInserter;
        long node1 = inserter.createNode(null, new Label[0]);
        long node2 = inserter.createNode(null, new Label[0]);
        for (int i = 0; i < 1000; ++i) {
            for (MyRelTypes relType : MyRelTypes.values()) {
                inserter.createRelationship(node1, node2, (RelationshipType)relType, null);
            }
        }
        NeoStores neoStores = this.getFlushedNeoStores(inserter);
        NodeRecord record = (NodeRecord)RecordStore.getRecord((RecordStore)neoStores.getNodeStore(), (long)node1);
        Assert.assertTrue((String)("Node " + record + " should have been dense"), (boolean)record.isDense());
    }

    @Test
    public void shouldGetRelationships() throws Exception {
        BatchInserter inserter = globalInserter;
        long node = inserter.createNode(null, new Label[0]);
        this.createRelationships(inserter, node, RelTypes.REL_TYPE1, 3);
        this.createRelationships(inserter, node, RelTypes.REL_TYPE2, 4);
        Set gottenRelationships = Iterables.asSet((Iterable)inserter.getRelationshipIds(node));
        Assert.assertEquals((long)21L, (long)gottenRelationships.size());
    }

    @Test
    public void shouldNotCreateSameLabelTwiceOnSameNode() throws Exception {
        BatchInserter inserter = globalInserter;
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"itemId", 1000L}), new Label[]{Label.label((String)"Item"), Label.label((String)"Item")});
        NodeStore nodeStore = this.getFlushedNeoStores(inserter).getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.getRecord(nodeId, nodeStore.newRecord(), RecordLoad.NORMAL);
        NodeLabels labels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        long[] labelIds = labels.get(nodeStore);
        Assert.assertEquals((long)1L, (long)labelIds.length);
    }

    @Test
    public void shouldSortLabelIdsWhenGetOrCreate() throws Exception {
        BatchInserter inserter = globalInserter;
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"Item", 123456789123L}), new Label[]{Label.label((String)"AA"), Label.label((String)"BB"), Label.label((String)"CC"), Label.label((String)"DD")});
        inserter.setNodeLabels(nodeId, new Label[]{Label.label((String)"CC"), Label.label((String)"AA"), Label.label((String)"DD"), Label.label((String)"EE"), Label.label((String)"FF")});
        NodeStore nodeStore = this.getFlushedNeoStores(inserter).getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.getRecord(nodeId, nodeStore.newRecord(), RecordLoad.NORMAL);
        NodeLabels labels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        long[] labelIds = labels.get(nodeStore);
        long[] sortedLabelIds = (long[])labelIds.clone();
        Arrays.sort(sortedLabelIds);
        Assert.assertArrayEquals((long[])sortedLabelIds, (long[])labelIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateUniquenessConstraint() throws Exception {
        Label label = Label.label((String)"Person");
        String propertyKey = "name";
        String duplicatedValue = "Tom";
        BatchInserter inserter = this.newBatchInserter();
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(propertyKey).create();
        GraphDatabaseService db = this.switchToEmbeddedGraphDatabaseService(inserter);
        try {
            try (Transaction tx = db.beginTx();){
                List constraints = Iterables.asList((Iterable)db.schema().getConstraints());
                Assert.assertEquals((long)1L, (long)constraints.size());
                ConstraintDefinition constraint = (ConstraintDefinition)constraints.get(0);
                Assert.assertEquals((Object)label.name(), (Object)constraint.getLabel().name());
                Assert.assertEquals((Object)propertyKey, (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                db.createNode(new Label[]{label}).setProperty(propertyKey, (Object)duplicatedValue);
                tx.success();
            }
            tx = db.beginTx();
            var7_8 = null;
            try {
                db.createNode(new Label[]{label}).setProperty(propertyKey, (Object)duplicatedValue);
                tx.success();
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_8 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            Assert.fail((String)"Uniqueness property constraint was violated, exception expected");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)String.format("Node(0) already exists with label `%s` and property `%s` = '%s'", label.name(), propertyKey, duplicatedValue), (Object)e.getMessage());
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void shouldNotAllowCreationOfUniquenessConstraintAndIndexOnSameLabelAndProperty() throws Exception {
        Label label = Label.label((String)("Person1-" + this.denseNodeThreshold));
        String property = "name";
        BatchInserter inserter = globalInserter;
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create();
        try {
            inserter.createDeferredSchemaIndex(label).on(property).create();
            Assert.fail((String)"Exception expected");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)"Index for given {label;property} already exists", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldNotAllowDuplicatedUniquenessConstraints() throws Exception {
        Label label = Label.label((String)("Person2-" + this.denseNodeThreshold));
        String property = "name";
        BatchInserter inserter = globalInserter;
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create();
        try {
            inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create();
            Assert.fail((String)"Exception expected");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)"It is not allowed to create node keys, uniqueness constraints or indexes on the same {label;property}", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldNotAllowDuplicatedIndexes() throws Exception {
        Label label = Label.label((String)("Person3-" + this.denseNodeThreshold));
        String property = "name";
        BatchInserter inserter = globalInserter;
        inserter.createDeferredSchemaIndex(label).on(property).create();
        try {
            inserter.createDeferredSchemaIndex(label).on(property).create();
            Assert.fail((String)"Exception expected");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)"Index for given {label;property} already exists", (Object)e.getMessage());
        }
    }

    @Test
    public void uniquenessConstraintShouldBeCheckedOnBatchInserterShutdownAndFailIfViolated() throws Exception {
        Label label = Label.label((String)"Foo");
        String property = "Bar";
        String value = "Baz";
        BatchInserter inserter = this.newBatchInserter();
        inserter.createDeferredConstraint(label).assertPropertyIsUnique(property).create();
        inserter.createNode(Collections.singletonMap(property, value), new Label[]{label});
        inserter.createNode(Collections.singletonMap(property, value), new Label[]{label});
        try {
            inserter.shutdown();
            Assert.fail((String)"Node that violates uniqueness constraint was created by batch inserter");
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)new IndexEntryConflictException(0L, 1L, new Value[]{Values.of((Object)value)}), (Object)ex.getCause());
        }
    }

    @Test
    public void shouldChangePropertiesInCurrentBatch() throws Exception {
        BatchInserter inserter = globalInserter;
        Map properties = MapUtil.map((Object[])new Object[]{"key1", "value1"});
        long node = inserter.createNode(properties, new Label[0]);
        properties.put("additionalKey", "Additional value");
        inserter.setNodeProperties(node, properties);
        Assert.assertEquals((Object)properties, this.getNodeProperties(inserter, node));
    }

    @Test
    public void shouldIgnoreRemovingNonExistentNodeProperty() throws Exception {
        BatchInserter inserter = globalInserter;
        long id = inserter.createNode(Collections.emptyMap(), new Label[0]);
        inserter.removeNodeProperty(id, "non-existent");
    }

    @Test
    public void shouldIgnoreRemovingNonExistentRelationshipProperty() throws Exception {
        BatchInserter inserter = globalInserter;
        Map noProperties = Collections.emptyMap();
        long nodeId1 = inserter.createNode(noProperties, new Label[0]);
        long nodeId2 = inserter.createNode(noProperties, new Label[0]);
        long id = inserter.createRelationship(nodeId1, nodeId2, (RelationshipType)MyRelTypes.TEST, noProperties);
        inserter.removeRelationshipProperty(id, "non-existent");
    }

    private LabelScanStore getLabelScanStore() {
        return new NativeLabelScanStore(this.pageCacheRule.getPageCache(fileSystemRule.get()), this.storeDir.absolutePath(), FullStoreChangeStream.EMPTY, true, new Monitors(), RecoveryCleanupWorkCollector.immediate());
    }

    private void assertLabelScanStoreContains(LabelScanStore labelScanStore, int labelId, long ... nodes) {
        try (LabelScanReader labelScanReader = labelScanStore.newReader();){
            List<Long> actualNodeIds = this.extractPrimitiveLongIteratorAsList(labelScanReader.nodesWithLabel(labelId));
            List expectedNodeIds = Arrays.stream(nodes).boxed().collect(Collectors.toList());
            Assert.assertEquals(expectedNodeIds, actualNodeIds);
        }
    }

    private List<Long> extractPrimitiveLongIteratorAsList(PrimitiveLongIterator primitiveLongIterator) {
        ArrayList<Long> actualNodeIds = new ArrayList<Long>();
        while (primitiveLongIterator.hasNext()) {
            actualNodeIds.add(primitiveLongIterator.next());
        }
        return actualNodeIds;
    }

    private void createRelationships(BatchInserter inserter, long node, RelationshipType relType, int out) {
        int i;
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(node, inserter.createNode(null, new Label[0]), relType, null);
        }
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(inserter.createNode(null, new Label[0]), node, relType, null);
        }
        for (i = 0; i < out; ++i) {
            inserter.createRelationship(node, node, relType, null);
        }
    }

    private long dbWithIndexAndSingleIndexedNode() throws Exception {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)provider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        BatchInserter inserter = this.newBatchInserterWithSchemaIndexProvider(SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("in-memory-index", provider));
        inserter.createDeferredSchemaIndex(Label.label((String)"Hacker")).on("handle").create();
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"handle", "Jakewins"}), new Label[]{Label.label((String)"Hacker")});
        inserter.shutdown();
        return nodeId;
    }

    private void setAndGet(BatchInserter inserter, Object value) {
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"key", value}), new Label[0]);
        Object readValue = inserter.getNodeProperties(nodeId).get("key");
        if (readValue.getClass().isArray()) {
            Assert.assertTrue((boolean)Arrays.equals((int[])value, (int[])readValue));
        } else {
            Assert.assertEquals((Object)value, readValue);
        }
    }

    private int[] intArray() {
        int length = 20;
        int[] array = new int[length];
        int startValue = (int)Math.pow(2.0, 30.0);
        for (int i = 0; i < length; ++i) {
            array[i] = startValue + i;
        }
        return array;
    }

    private Node getNodeInTx(long nodeId, GraphDatabaseService db) {
        try (Transaction ignored = db.beginTx();){
            Node node = db.getNodeById(nodeId);
            return node;
        }
    }

    private void forceFlush(BatchInserter inserter) {
        ((BatchInserterImpl)inserter).forceFlushChanges();
    }

    private NeoStores getFlushedNeoStores(BatchInserter inserter) {
        this.forceFlush(inserter);
        return ((BatchInserterImpl)inserter).getNeoStores();
    }

    private Iterable<String> asNames(Iterable<Label> nodeLabels) {
        return Iterables.map(Label::name, nodeLabels);
    }

    private Pair<Label[], Set<String>> manyLabels(int count) {
        Label[] labels = new Label[count];
        HashSet<String> expectedLabelNames = new HashSet<String>();
        for (int i = 0; i < labels.length; ++i) {
            String labelName = "bach label " + i;
            labels[i] = Label.label((String)labelName);
            expectedLabelNames.add(labelName);
        }
        return Pair.of((Object)labels, expectedLabelNames);
    }

    private Map<String, Object> getNodeProperties(BatchInserter inserter, long nodeId) {
        return inserter.getNodeProperties(nodeId);
    }

    private Map<String, Object> getRelationshipProperties(BatchInserter inserter, long relId) {
        return inserter.getRelationshipProperties(relId);
    }

    static {
        properties.put("key0", "SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA");
        properties.put("key1", 1);
        properties.put("key2", (short)2);
        properties.put("key3", 3L);
        properties.put("key4", Float.valueOf(4.0f));
        properties.put("key5", 5.0);
        properties.put("key6", (byte)6);
        properties.put("key7", true);
        properties.put("key8", Character.valueOf('\b'));
        properties.put("key10", new String[]{"SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA", "dsasda", "dssadsad"});
        properties.put("key11", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key12", new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key13", new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        properties.put("key14", new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f});
        properties.put("key15", new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        properties.put("key16", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key17", new boolean[]{true, false, true, false});
        properties.put("key18", new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t'});
        globalStoreDir = TestDirectory.testDirectory(BatchInsertTest.class);
        fileSystemRule = new DefaultFileSystemRule();
    }

    private static enum Labels implements Label
    {
        FIRST,
        SECOND,
        THIRD;

    }

    private static enum RelTypes implements RelationshipType
    {
        BATCH_TEST,
        REL_TYPE1,
        REL_TYPE2,
        REL_TYPE3,
        REL_TYPE4,
        REL_TYPE5;

    }
}

