/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.unsafe.batchinsert.internal.BatchInserterImpl;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccessSet;

public class BatchedFlushStrategyTest {
    @Test
    public void testFlush() throws Exception {
        DirectRecordAccessSet recordAccessSet = (DirectRecordAccessSet)Mockito.mock(DirectRecordAccessSet.class);
        BatchInserterImpl.BatchedFlushStrategy flushStrategy = this.createFlushStrategy(recordAccessSet, 2);
        flushStrategy.flush();
        Mockito.verifyZeroInteractions((Object[])new Object[]{recordAccessSet});
        flushStrategy.flush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet)).commit();
        Mockito.reset((Object[])new DirectRecordAccessSet[]{recordAccessSet});
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet, (VerificationMode)Mockito.times((int)3))).commit();
    }

    @Test
    public void testForceFlush() throws Exception {
        DirectRecordAccessSet recordAccessSet = (DirectRecordAccessSet)Mockito.mock(DirectRecordAccessSet.class);
        BatchInserterImpl.BatchedFlushStrategy flushStrategy = this.createFlushStrategy(recordAccessSet, 2);
        flushStrategy.forceFlush();
        flushStrategy.forceFlush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet, (VerificationMode)Mockito.times((int)2))).commit();
        flushStrategy.flush();
        flushStrategy.forceFlush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet, (VerificationMode)Mockito.times((int)3))).commit();
    }

    @Test
    public void testResetBatchCounterOnForce() {
        DirectRecordAccessSet recordAccessSet = (DirectRecordAccessSet)Mockito.mock(DirectRecordAccessSet.class);
        BatchInserterImpl.BatchedFlushStrategy flushStrategy = this.createFlushStrategy(recordAccessSet, 3);
        flushStrategy.flush();
        flushStrategy.flush();
        Mockito.verifyZeroInteractions((Object[])new Object[]{recordAccessSet});
        flushStrategy.forceFlush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{recordAccessSet});
        flushStrategy.flush();
        flushStrategy.flush();
    }

    private BatchInserterImpl.BatchedFlushStrategy createFlushStrategy(DirectRecordAccessSet recordAccessSet, int batchSize) {
        return new BatchInserterImpl.BatchedFlushStrategy(recordAccessSet, batchSize);
    }
}

