/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class RelationshipCountsProcessorTest {
    private static final int ANY = -1;
    private NodeLabelsCache nodeLabelCache = (NodeLabelsCache)Mockito.mock(NodeLabelsCache.class);
    private CountsAccessor.Updater countsUpdater = (CountsAccessor.Updater)Mockito.mock(CountsAccessor.Updater.class);

    @Test
    public void shouldHandleBigNumberOfLabelsAndRelationshipTypes() throws Exception {
        int relTypeCount = 256;
        int labelCount = 0x400000;
        NumberArrayFactory numberArrayFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        new RelationshipCountsProcessor(this.nodeLabelCache, labelCount, relTypeCount, this.countsUpdater, numberArrayFactory);
        ((NumberArrayFactory)Mockito.verify((Object)numberArrayFactory, (VerificationMode)Mockito.times((int)2))).newLongArray(Matchers.longThat((Matcher)new IsNonNegativeLong()), Matchers.anyLong());
    }

    @Test
    public void testRelationshipCountersUpdates() {
        int relationTypes = 2;
        int labels = 3;
        NodeLabelsCache.Client client = (NodeLabelsCache.Client)Mockito.mock(NodeLabelsCache.Client.class);
        Mockito.when((Object)this.nodeLabelCache.newClient()).thenReturn((Object)client);
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)Matchers.eq((Object)client), Matchers.eq((long)1L), (int[])Matchers.any(int[].class))).thenReturn((Object)new int[]{0, 2});
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)Matchers.eq((Object)client), Matchers.eq((long)2L), (int[])Matchers.any(int[].class))).thenReturn((Object)new int[]{1});
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)Matchers.eq((Object)client), Matchers.eq((long)3L), (int[])Matchers.any(int[].class))).thenReturn((Object)new int[]{1, 2});
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)Matchers.eq((Object)client), Matchers.eq((long)4L), (int[])Matchers.any(int[].class))).thenReturn((Object)new int[0]);
        RelationshipCountsProcessor countsProcessor = new RelationshipCountsProcessor(this.nodeLabelCache, labels, relationTypes, this.countsUpdater, NumberArrayFactory.AUTO_WITHOUT_PAGECACHE);
        countsProcessor.process(1L, 0, 3L);
        countsProcessor.process(2L, 1, 4L);
        countsProcessor.done();
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1, -1, -1, 2L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1, 0, -1, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1, 1, -1, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(0, 0, -1, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(2, 0, -1, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1, 0, 1, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1, 0, 2, 1L);
    }

    private class IsNonNegativeLong
    extends ArgumentMatcher<Long> {
        private IsNonNegativeLong() {
        }

        public boolean matches(Object argument) {
            return argument != null && (Long)argument >= 0L;
        }
    }
}

