/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipRecordPreparationStep;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.DeadEndStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipRecordPreparationStepTest {
    @Test
    public void shouldCollectBadRelationships() throws Exception {
        Collector collector = (Collector)Mockito.mock(Collector.class);
        StageControl control = (StageControl)Mockito.mock(StageControl.class);
        try (RelationshipRecordPreparationStep step = new RelationshipRecordPreparationStep(control, Configuration.DEFAULT, (BatchingTokenRepository.BatchingRelationshipTypeTokenRepository)Mockito.mock(BatchingTokenRepository.BatchingRelationshipTypeTokenRepository.class), collector);){
            DeadEndStep end = new DeadEndStep(control);
            end.start(0);
            step.setDownstream((Step)end);
            step.start(0);
            Batch<InputRelationship, RelationshipRecord> batch = RelationshipRecordPreparationStepTest.batch(RelationshipRecordPreparationStepTest.relationship(1L, 5L), RelationshipRecordPreparationStepTest.relationship(3L, 10L), RelationshipRecordPreparationStepTest.relationship("a", 2, -1L, 2L), RelationshipRecordPreparationStepTest.relationship(2, "b", 2L, -1L), RelationshipRecordPreparationStepTest.relationship("c", "d", -1L, -1L));
            step.receive(0L, batch);
            step.endOfUpstream();
            while (!step.isCompleted()) {
            }
            ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectBadRelationship((InputRelationship)Matchers.any(InputRelationship.class), Matchers.eq((Object)"a"));
            ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectBadRelationship((InputRelationship)Matchers.any(InputRelationship.class), Matchers.eq((Object)"b"));
            ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectBadRelationship((InputRelationship)Matchers.any(InputRelationship.class), Matchers.eq((Object)"c"));
            ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectBadRelationship((InputRelationship)Matchers.any(InputRelationship.class), Matchers.eq((Object)"d"));
        }
    }

    private static Batch<InputRelationship, RelationshipRecord> batch(Data ... relationships) {
        Batch batch = new Batch((Object[])new InputRelationship[relationships.length]);
        batch.ids = new long[relationships.length * 2];
        for (int i = 0; i < relationships.length; ++i) {
            ((InputRelationship[])batch.input)[i] = new InputRelationship("test", (long)i, (long)i, InputEntity.NO_PROPERTIES, null, relationships[i].startNode, relationships[i].endNode, "TYPE", null);
            batch.ids[i * 2] = relationships[i].startNodeId;
            batch.ids[i * 2 + 1] = relationships[i].endNodeId;
        }
        return batch;
    }

    private static Data relationship(Object startNode, Object endNode, long startNodeId, long endNodeId) {
        return new Data(startNode, endNode, startNodeId, endNodeId);
    }

    private static Data relationship(long startNodeId, long endNodeId) {
        return new Data(startNodeId, endNodeId, startNodeId, endNodeId);
    }

    private static class Data {
        private final long startNodeId;
        private final long endNodeId;
        private final Object startNode;
        private final Object endNode;

        Data(Object startNode, Object endNode, long startNodeId, long endNodeId) {
            this.startNode = startNode;
            this.endNode = endNode;
            this.startNodeId = startNodeId;
            this.endNodeId = endNodeId;
        }
    }
}

