/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayPageCacheTestSupport;
import org.neo4j.unsafe.impl.batchimport.cache.PageCachedNumberArrayFactory;

@RunWith(value=Parameterized.class)
public class ByteArrayTest
extends NumberArrayPageCacheTestSupport {
    private static final byte[] DEFAULT = new byte[25];
    private static final int LENGTH = 1000;
    private static NumberArrayPageCacheTestSupport.Fixture fixture;
    @Parameterized.Parameter
    public Supplier<ByteArray> factory;
    private ByteArray array;

    @Parameterized.Parameters
    public static Collection<Supplier<ByteArray>> data() throws IOException {
        fixture = ByteArrayTest.prepareDirectoryAndPageCache(ByteArrayTest.class);
        PageCache pageCache = ByteArrayTest.fixture.pageCache;
        File dir = ByteArrayTest.fixture.directory;
        NumberArrayFactory autoWithPageCacheFallback = NumberArrayFactory.auto((PageCache)pageCache, (File)dir, (boolean)true);
        PageCachedNumberArrayFactory pageCacheArrayFactory = new PageCachedNumberArrayFactory(pageCache, dir);
        int chunkSize = 100;
        return Arrays.asList(() -> NumberArrayFactory.HEAP.newByteArray(1000L, DEFAULT), () -> NumberArrayFactory.HEAP.newDynamicByteArray((long)chunkSize, DEFAULT), () -> NumberArrayFactory.OFF_HEAP.newByteArray(1000L, DEFAULT), () -> NumberArrayFactory.OFF_HEAP.newDynamicByteArray((long)chunkSize, DEFAULT), () -> NumberArrayFactory.AUTO_WITHOUT_PAGECACHE.newByteArray(1000L, DEFAULT), () -> NumberArrayFactory.AUTO_WITHOUT_PAGECACHE.newDynamicByteArray((long)chunkSize, DEFAULT), () -> autoWithPageCacheFallback.newByteArray(1000L, DEFAULT), () -> autoWithPageCacheFallback.newDynamicByteArray((long)chunkSize, DEFAULT), () -> ByteArrayTest.lambda$data$8((NumberArrayFactory)pageCacheArrayFactory), () -> ByteArrayTest.lambda$data$9((NumberArrayFactory)pageCacheArrayFactory, chunkSize));
    }

    @AfterClass
    public static void closeFixture() throws Exception {
        fixture.close();
    }

    @Before
    public void before() {
        this.array = this.factory.get();
    }

    @After
    public void after() {
        this.array.close();
    }

    @Test
    public void shouldSetAndGetBasicTypes() throws Exception {
        int index = 0;
        byte[] actualBytes = new byte[DEFAULT.length];
        byte[] expectedBytes = new byte[actualBytes.length];
        ThreadLocalRandom.current().nextBytes(actualBytes);
        int len = 999;
        for (int i = 0; i < len; ++i) {
            try {
                this.setSimpleValues(index);
                this.setArray(index + 1, actualBytes);
                this.verifySimpleValues(index);
                this.verifyArray(index + 1, actualBytes, expectedBytes);
                continue;
            }
            catch (Throwable throwable) {
                throw new AssertionError("Failure at index " + i, throwable);
            }
        }
    }

    private void setSimpleValues(int index) {
        this.array.setByte((long)index, 0, (byte)123);
        this.array.setShort((long)index, 1, (short)1234);
        this.array.setInt((long)index, 5, 12345);
        this.array.setLong((long)index, 9, 9223372036854775707L);
        this.array.set3ByteInt((long)index, 17, 76767);
    }

    private void setArray(int index, byte[] bytes) {
        this.array.set((long)index, bytes);
    }

    private void verifySimpleValues(int index) {
        Assert.assertEquals((long)123L, (long)this.array.getByte((long)index, 0));
        Assert.assertEquals((long)1234L, (long)this.array.getShort((long)index, 1));
        Assert.assertEquals((long)12345L, (long)this.array.getInt((long)index, 5));
        Assert.assertEquals((long)9223372036854775707L, (long)this.array.getLong((long)index, 9));
        Assert.assertEquals((long)76767L, (long)this.array.get3ByteInt((long)index, 17));
    }

    private void verifyArray(int index, byte[] actualBytes, byte[] scratchBuffer) {
        this.array.get((long)index, scratchBuffer);
        Assert.assertArrayEquals((byte[])actualBytes, (byte[])scratchBuffer);
    }

    @Test
    public void shouldDetectMinusOne() throws Exception {
        this.array.set6ByteLong(10L, 2, -1L);
        this.array.set6ByteLong(10L, 8, -1L);
        Assert.assertEquals((long)-1L, (long)this.array.get6ByteLong(10L, 2));
        Assert.assertEquals((long)-1L, (long)this.array.get6ByteLong(10L, 8));
    }

    @Test
    public void shouldHandleMultipleCallsToClose() throws Exception {
        this.array.close();
        this.array.close();
    }

    private static /* synthetic */ ByteArray lambda$data$9(NumberArrayFactory pageCacheArrayFactory, int chunkSize) {
        return pageCacheArrayFactory.newDynamicByteArray((long)chunkSize, DEFAULT);
    }

    private static /* synthetic */ ByteArray lambda$data$8(NumberArrayFactory pageCacheArrayFactory) {
        return pageCacheArrayFactory.newByteArray(1000L, DEFAULT);
    }
}

