/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicLongArrayTest {
    @Test
    public void shouldWorkOnSingleChunk() throws Exception {
        long defaultValue = 0L;
        LongArray array = NumberArrayFactory.AUTO_WITHOUT_PAGECACHE.newDynamicLongArray(10L, defaultValue);
        array.set(4L, 5L);
        Assert.assertEquals((long)5L, (long)array.get(4L));
        Assert.assertEquals((long)defaultValue, (long)array.get(12L));
        array.set(7L, 1324L);
        Assert.assertEquals((long)1324L, (long)array.get(7L));
    }

    @Test
    public void shouldChunksAsNeeded() throws Exception {
        LongArray array = NumberArrayFactory.AUTO_WITHOUT_PAGECACHE.newDynamicLongArray(10L, 0L);
        long index = 243L;
        long value = 5485748L;
        array.set(index, value);
        Assert.assertEquals((long)value, (long)array.get(index));
    }
}

