/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Receiver;

public class InputCacheTest {
    private static final int BATCH_SIZE = 100;
    private static final int BATCHES = 100;
    private static final String[] TOKENS = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven"};
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final TestDirectory dir = TestDirectory.testDirectory();
    private final RandomRule randomRule = new RandomRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.dir).around((TestRule)this.randomRule).around((TestRule)this.fileSystemRule);
    private String[] previousLabels;
    private final Group[] previousGroups = new Group[]{Group.GLOBAL, Group.GLOBAL};
    private String previousType;

    @Test
    public void shouldCacheAndRetrieveNodes() throws Exception {
        try (InputCache cache = new InputCache(this.fileSystemRule.get(), this.dir.directory(), Standard.LATEST_RECORD_FORMATS, this.withMaxProcessors(50), (int)ByteUnit.kibiBytes((long)8L), 100);){
            ArrayList<InputNode> nodes = new ArrayList<InputNode>();
            Randoms random = this.getRandoms();
            try (Receiver cacher = cache.cacheNodes("main");){
                InputNode[] batch = new InputNode[100];
                for (int b = 0; b < 100; ++b) {
                    for (int i = 0; i < 100; ++i) {
                        InputNode node;
                        batch[i] = node = this.randomNode(random);
                        nodes.add(node);
                    }
                    cacher.receive((Object)batch);
                }
            }
            var6_8 = null;
            try (InputIterator reader = cache.nodes("main", true).iterator();){
                reader.processors(50 - reader.processors(0));
                Iterator expected = nodes.iterator();
                while (expected.hasNext()) {
                    Assert.assertTrue((boolean)reader.hasNext());
                    InputNode expectedNode = (InputNode)expected.next();
                    InputNode node = (InputNode)reader.next();
                    this.assertNodesEquals(expectedNode, node);
                }
                Assert.assertFalse((boolean)reader.hasNext());
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
        this.assertNoFilesLeftBehind();
    }

    @Test
    public void shouldCacheAndRetrieveRelationships() throws Exception {
        try (InputCache cache = new InputCache(this.fileSystemRule.get(), this.dir.directory(), Standard.LATEST_RECORD_FORMATS, this.withMaxProcessors(50), (int)ByteUnit.kibiBytes((long)8L), 100);){
            ArrayList<InputRelationship> relationships = new ArrayList<InputRelationship>();
            Randoms random = this.getRandoms();
            try (Receiver cacher = cache.cacheRelationships("main");){
                InputRelationship[] batch = new InputRelationship[100];
                for (int b = 0; b < 100; ++b) {
                    for (int i = 0; i < 100; ++i) {
                        InputRelationship relationship;
                        batch[i] = relationship = this.randomRelationship(random);
                        relationships.add(relationship);
                    }
                    cacher.receive((Object)batch);
                }
            }
            var6_8 = null;
            try (InputIterator reader = cache.relationships("main", true).iterator();){
                reader.processors(50 - reader.processors(0));
                Iterator expected = relationships.iterator();
                while (expected.hasNext()) {
                    Assert.assertTrue((boolean)reader.hasNext());
                    InputRelationship expectedRelationship = (InputRelationship)expected.next();
                    InputRelationship relationship = (InputRelationship)reader.next();
                    this.assertRelationshipsEquals(expectedRelationship, relationship);
                }
                Assert.assertFalse((boolean)reader.hasNext());
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
        this.assertNoFilesLeftBehind();
    }

    private Configuration withMaxProcessors(final int maxProcessors) {
        return new Configuration(){

            public int maxNumberOfProcessors() {
                return maxProcessors;
            }
        };
    }

    private void assertNoFilesLeftBehind() {
        Assert.assertEquals((long)0L, (long)((DefaultFileSystemAbstraction)this.fileSystemRule.get()).listFiles(this.dir.directory()).length);
    }

    private void assertRelationshipsEquals(InputRelationship expectedRelationship, InputRelationship relationship) {
        this.assertProperties((InputEntity)expectedRelationship, (InputEntity)relationship);
        Assert.assertEquals((Object)expectedRelationship.startNode(), (Object)relationship.startNode());
        Assert.assertEquals((Object)expectedRelationship.startNodeGroup(), (Object)relationship.startNodeGroup());
        Assert.assertEquals((Object)expectedRelationship.endNode(), (Object)relationship.endNode());
        Assert.assertEquals((Object)expectedRelationship.endNodeGroup(), (Object)relationship.endNodeGroup());
        if (expectedRelationship.hasTypeId()) {
            Assert.assertEquals((long)expectedRelationship.typeId(), (long)relationship.typeId());
        } else {
            Assert.assertEquals((Object)expectedRelationship.type(), (Object)relationship.type());
        }
    }

    private Randoms getRandoms() {
        return new Randoms(this.randomRule.random(), Randoms.DEFAULT);
    }

    private void assertProperties(InputEntity expected, InputEntity entity) {
        if (expected.hasFirstPropertyId()) {
            Assert.assertEquals((long)expected.firstPropertyId(), (long)entity.firstPropertyId());
        } else {
            Assert.assertArrayEquals((Object[])expected.properties(), (Object[])entity.properties());
        }
    }

    private InputRelationship randomRelationship(Randoms random) {
        if (random.random().nextFloat() < 0.1f) {
            return new InputRelationship(null, 0L, 0L, InputEntity.NO_PROPERTIES, Long.valueOf(Math.abs(random.random().nextLong())), this.randomGroup(random, 0), this.randomId(random), this.randomGroup(random, 1), this.randomId(random), null, Integer.valueOf(Math.abs(random.random().nextInt(20000))));
        }
        return new InputRelationship(null, 0L, 0L, this.randomProperties(random), null, this.randomGroup(random, 0), this.randomId(random), this.randomGroup(random, 1), this.randomId(random), this.randomType(random), null);
    }

    private String randomType(Randoms random) {
        if (this.previousType == null || random.random().nextFloat() < 0.1f) {
            this.previousType = (String)random.among((Object[])TOKENS);
            return this.previousType;
        }
        return this.previousType;
    }

    private void assertNodesEquals(InputNode expectedNode, InputNode node) {
        Assert.assertEquals((Object)expectedNode.group(), (Object)node.group());
        Assert.assertEquals((Object)expectedNode.id(), (Object)node.id());
        if (expectedNode.hasFirstPropertyId()) {
            Assert.assertEquals((long)expectedNode.firstPropertyId(), (long)node.firstPropertyId());
        } else {
            Assert.assertArrayEquals((Object[])expectedNode.properties(), (Object[])node.properties());
        }
        if (expectedNode.hasLabelField()) {
            Assert.assertEquals((Object)expectedNode.labelField(), (Object)node.labelField());
        } else {
            Assert.assertEquals((Object)Iterators.asSet((Object[])expectedNode.labels()), (Object)Iterators.asSet((Object[])node.labels()));
        }
    }

    private InputNode randomNode(Randoms random) {
        if (random.random().nextFloat() < 0.1f) {
            return new InputNode(null, 0L, 0L, this.randomId(random), InputEntity.NO_PROPERTIES, Long.valueOf(Math.abs(random.random().nextLong())), InputEntity.NO_LABELS, Long.valueOf(Math.abs(random.random().nextLong())));
        }
        return new InputNode(null, 0L, 0L, this.randomGroup(random, 0), this.randomId(random), this.randomProperties(random), null, this.randomLabels(random), null);
    }

    private Group randomGroup(Randoms random, int slot) {
        if (random.random().nextFloat() < 0.01f) {
            this.previousGroups[slot] = new Group.Adapter(random.nextInt(20000), random.string());
            return this.previousGroups[slot];
        }
        return this.previousGroups[slot];
    }

    private String[] randomLabels(Randoms random) {
        if (this.previousLabels == null || (double)random.random().nextFloat() < 0.1) {
            this.previousLabels = (String[])random.selection((Object[])TOKENS, 1, 5, false);
            return this.previousLabels;
        }
        return this.previousLabels;
    }

    private Object[] randomProperties(Randoms random) {
        int length = random.random().nextInt(10);
        Object[] properties = new Object[length * 2];
        for (int i = 0; i < properties.length; ++i) {
            properties[i++] = random.random().nextFloat() < 0.2f ? Integer.valueOf(random.intBetween(0, 10)) : random.among((Object[])TOKENS);
            properties[i] = random.propertyValue();
        }
        return properties;
    }

    private Object randomId(Randoms random) {
        return Math.abs(random.random().nextLong());
    }
}

